/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import sun.awt.X11.XAtom;
import sun.awt.X11.XToolkit;

class MotifColorUtilities {
    static final float XmRED_LUMINOSITY = 0.3f;
    static final float XmGREEN_LUMINOSITY = 0.59f;
    static final float XmBLUE_LUMINOSITY = 0.11f;
    static final int XmINTENSITY_FACTOR = 75;
    static final int XmLIGHT_FACTOR = 0;
    static final int XmLUMINOSITY_FACTOR = 25;
    static final int XmMAX_SHORT = 65535;
    static final int XmCOLOR_PERCENTILE = 655;
    static final int XmDEFAULT_DARK_THRESHOLD = 20;
    static final int XmDEFAULT_LIGHT_THRESHOLD = 93;
    static final int XmDEFAULT_FOREGROUND_THRESHOLD = 70;
    static final int BLACK = -16777216;
    static final int WHITE = -1;
    static final int DEFAULT_COLOR = -3881788;
    static final int XmCOLOR_LITE_THRESHOLD = 60915;
    static final int XmCOLOR_DARK_THRESHOLD = 13100;
    static final int XmFOREGROUND_THRESHOLD = 45850;
    static final int XmCOLOR_LITE_SEL_FACTOR = 15;
    static final int XmCOLOR_LITE_BS_FACTOR = 40;
    static final int XmCOLOR_LITE_TS_FACTOR = 20;
    static final int XmCOLOR_DARK_SEL_FACTOR = 15;
    static final int XmCOLOR_DARK_BS_FACTOR = 30;
    static final int XmCOLOR_DARK_TS_FACTOR = 50;
    static final int XmCOLOR_HI_SEL_FACTOR = 15;
    static final int XmCOLOR_HI_BS_FACTOR = 40;
    static final int XmCOLOR_HI_TS_FACTOR = 60;
    static final int XmCOLOR_LO_SEL_FACTOR = 15;
    static final int XmCOLOR_LO_BS_FACTOR = 60;
    static final int XmCOLOR_LO_TS_FACTOR = 50;

    MotifColorUtilities() {
    }

    static int brightness(int n2, int n3, int n4) {
        float f2 = ((n2 <<= 8) + (n3 <<= 8) + (n4 <<= 8)) / 3;
        float f3 = (int)(0.3f * (float)n2 + 0.59f * (float)n3 + 0.11f * (float)n4);
        float f4 = n2 > n3 ? (n2 > n4 ? n2 : n4) : (n3 > n4 ? n3 : n4);
        float f5 = n2 < n3 ? (n2 < n4 ? n2 : n4) : (n3 < n4 ? n3 : n4);
        float f6 = (f5 + f4) / 2.0f;
        float f7 = (f2 * 75.0f + f6 * 0.0f + f3 * 25.0f) / 100.0f;
        return Math.round(f7);
    }

    static int calculateForegroundFromBackground(int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = MotifColorUtilities.brightness(n2, n3, n4);
        n5 = n6 > 45850 ? -16777216 : -1;
        return n5;
    }

    static int calculateTopShadowFromBackground(int n2, int n3, int n4) {
        float f2;
        float f3;
        float f4;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = n4 << 8;
        int n8 = MotifColorUtilities.brightness(n2, n3, n4);
        if (n8 < 13100) {
            float f5 = n5;
            f5 += 50.0f * (65535.0f - f5) / 100.0f;
            f4 = f5;
            f5 = n6;
            f5 += 50.0f * (65535.0f - f5) / 100.0f;
            f3 = f5;
            f5 = n7;
            f5 += 50.0f * (65535.0f - f5) / 100.0f;
            f2 = f5;
        } else if (n8 > 60915) {
            float f6 = n5;
            f6 -= f6 * 20.0f / 100.0f;
            f4 = f6;
            f6 = n6;
            f6 -= f6 * 20.0f / 100.0f;
            f3 = f6;
            f6 = n7;
            f6 -= f6 * 20.0f / 100.0f;
            f2 = f6;
        } else {
            float f7 = 50 + n8 * 10 / 65535;
            float f8 = n5;
            f8 += f7 * (65535.0f - f8) / 100.0f;
            f4 = f8;
            f8 = n6;
            f8 += f7 * (65535.0f - f8) / 100.0f;
            f3 = f8;
            f8 = n7;
            f8 += f7 * (65535.0f - f8) / 100.0f;
            f2 = f8;
        }
        int n9 = (int)f4 >> 8;
        int n10 = (int)f3 >> 8;
        int n11 = (int)f2 >> 8;
        int n12 = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
        return n12;
    }

    static int calculateBottomShadowFromBackground(int n2, int n3, int n4) {
        float f2;
        float f3;
        float f4;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = n4 << 8;
        int n8 = MotifColorUtilities.brightness(n2, n3, n4);
        if (n8 < 13100) {
            float f5 = n5;
            f5 += 30.0f * (65535.0f - f5) / 100.0f;
            f4 = f5;
            f5 = n6;
            f5 += 30.0f * (65535.0f - f5) / 100.0f;
            f3 = f5;
            f5 = n7;
            f5 += 30.0f * (65535.0f - f5) / 100.0f;
            f2 = f5;
        } else if (n8 > 60915) {
            float f6 = n5;
            f6 -= f6 * 40.0f / 100.0f;
            f4 = f6;
            f6 = n6;
            f6 -= f6 * 40.0f / 100.0f;
            f3 = f6;
            f6 = n7;
            f6 -= f6 * 40.0f / 100.0f;
            f2 = f6;
        } else {
            float f7 = 60 + n8 * -20 / 65535;
            float f8 = n5;
            f8 -= f8 * f7 / 100.0f;
            f4 = f8;
            f8 = n6;
            f8 -= f8 * f7 / 100.0f;
            f3 = f8;
            f8 = n7;
            f8 -= f8 * f7 / 100.0f;
            f2 = f8;
        }
        int n9 = (int)f4 >> 8;
        int n10 = (int)f3 >> 8;
        int n11 = (int)f2 >> 8;
        int n12 = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
        return n12;
    }

    static int calculateSelectFromBackground(int n2, int n3, int n4) {
        float f2;
        float f3;
        float f4;
        int n5 = n2 << 8;
        int n6 = n3 << 8;
        int n7 = n4 << 8;
        int n8 = MotifColorUtilities.brightness(n2, n3, n4);
        if (n8 < 13100) {
            float f5 = n5;
            f5 += 15.0f * (65535.0f - f5) / 100.0f;
            f4 = f5;
            f5 = n6;
            f5 += 15.0f * (65535.0f - f5) / 100.0f;
            f3 = f5;
            f5 = n7;
            f5 += 15.0f * (65535.0f - f5) / 100.0f;
            f2 = f5;
        } else if (n8 > 60915) {
            float f6 = n5;
            f6 -= f6 * 15.0f / 100.0f;
            f4 = f6;
            f6 = n6;
            f6 -= f6 * 15.0f / 100.0f;
            f3 = f6;
            f6 = n7;
            f6 -= f6 * 15.0f / 100.0f;
            f2 = f6;
        } else {
            float f7 = 15 + n8 * 0 / 65535;
            float f8 = n5;
            f8 -= f8 * f7 / 100.0f;
            f4 = f8;
            f8 = n6;
            f8 -= f8 * f7 / 100.0f;
            f3 = f8;
            f8 = n7;
            f8 -= f8 * f7 / 100.0f;
            f2 = f8;
        }
        int n9 = (int)f4 >> 8;
        int n10 = (int)f3 >> 8;
        int n11 = (int)f2 >> 8;
        int n12 = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
        return n12;
    }

    static void loadSystemColorsForCDE(int[] nArray) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        XAtom xAtom = XAtom.get("RESOURCE_MANAGER");
        String string = xAtom.getProperty(XToolkit.getDefaultRootWindow());
        int n7 = string.length();
        for (n6 = string.indexOf("ColorPalette:"); n6 < n7 && string.charAt(n6) != ':'; ++n6) {
        }
        if (string.charAt(++n6) == '\t') {
            ++n6;
        }
        String string2 = string.substring(n6, string.indexOf("\n", n6));
        String string3 = System.getProperty("user.home") + "/.dt/palettes/" + string2;
        File file = new File(string3);
        if (!file.exists() && !(file = new File(string3 = "/usr/dt/palettes/" + string2)).exists()) {
            throw new FileNotFoundException("Could not open : " + string3);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int[] nArray2 = new int[8];
        for (n5 = 0; n5 < 8; ++n5) {
            String string4 = bufferedReader.readLine();
            String string5 = string4.substring(1, string4.length());
            n4 = Integer.valueOf(string5.substring(0, 4), 16) >> 8;
            n3 = Integer.valueOf(string5.substring(4, 8), 16) >> 8;
            n2 = Integer.valueOf(string5.substring(8, 12), 16) >> 8;
            nArray2[n5] = 0xFF000000 | n4 << 16 | n3 << 8 | n2;
        }
        nArray[1] = nArray2[0];
        nArray[3] = nArray2[0];
        nArray[4] = nArray2[1];
        nArray[6] = nArray2[1];
        nArray[7] = nArray2[1];
        nArray[8] = nArray2[1];
        nArray[10] = nArray2[1];
        nArray[12] = nArray2[3];
        nArray[23] = nArray2[1];
        nArray[17] = nArray2[1];
        n4 = (nArray2[0] & 0xFF0000) >> 16;
        n3 = (nArray2[0] & 0xFF00) >> 8;
        n2 = nArray2[0] & 0xFF;
        n5 = MotifColorUtilities.calculateForegroundFromBackground(n4, n3, n2);
        n4 = (nArray2[1] & 0xFF0000) >> 16;
        n3 = (nArray2[1] & 0xFF00) >> 8;
        n2 = nArray2[1] & 0xFF;
        int n8 = MotifColorUtilities.calculateForegroundFromBackground(n4, n3, n2);
        int n9 = MotifColorUtilities.calculateTopShadowFromBackground(n4, n3, n2);
        int n10 = MotifColorUtilities.calculateBottomShadowFromBackground(n4, n3, n2);
        n4 = (nArray2[3] & 0xFF0000) >> 16;
        n3 = (nArray2[3] & 0xFF00) >> 8;
        n2 = nArray2[3] & 0xFF;
        int n11 = MotifColorUtilities.calculateForegroundFromBackground(n4, n3, n2);
        nArray[2] = n5;
        nArray[5] = n8;
        nArray[9] = n8;
        nArray[11] = n8;
        nArray[13] = n11;
        nArray[14] = -16777216;
        nArray[15] = -3881788;
        nArray[18] = n8;
        Color color = new Color(n9);
        nArray[19] = n9;
        nArray[20] = color.brighter().getRGB();
        color = new Color(n10);
        nArray[21] = n10;
        nArray[22] = color.darker().getRGB();
    }

    static void loadMotifDefaultColors(int[] nArray) {
        nArray[7] = -3881788;
        nArray[12] = -3881788;
        nArray[9] = -16777216;
        nArray[11] = -16777216;
        nArray[2] = -16777216;
        nArray[5] = -16777216;
        nArray[13] = -16777216;
        nArray[14] = -16777216;
        nArray[15] = -3881788;
        nArray[18] = -16777216;
        nArray[8] = -3881788;
        nArray[10] = -3881788;
        nArray[23] = -3881788;
        nArray[17] = -3881788;
        int n2 = 196;
        int n3 = 196;
        int n4 = 196;
        int n5 = MotifColorUtilities.calculateTopShadowFromBackground(n2, n3, n4);
        int n6 = MotifColorUtilities.calculateBottomShadowFromBackground(n2, n3, n4);
        Color color = new Color(n5);
        nArray[19] = n5;
        nArray[20] = color.brighter().getRGB();
        color = new Color(n6);
        nArray[21] = n6;
        nArray[22] = color.darker().getRGB();
    }

    static void loadSystemColors(int[] nArray) {
        if (System.getProperty("os.name").equals("Linux")) {
            MotifColorUtilities.loadMotifDefaultColors(nArray);
        } else {
            try {
                MotifColorUtilities.loadSystemColorsForCDE(nArray);
            }
            catch (Exception exception) {
                MotifColorUtilities.loadMotifDefaultColors(nArray);
            }
        }
    }
}

