/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizBagLayout
implements LayoutManager {
    int hgap;

    public HorizBagLayout() {
        this(0);
    }

    public HorizBagLayout(int n2) {
        this.hgap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        for (int i2 = 0; i2 < container.countComponents(); ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        for (int i2 = 0; i2 < container.countComponents(); ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.preferredSize();
            dimension.width += dimension2.width + this.hgap;
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n2 = insets.top;
        int n3 = container.size().height - insets.bottom;
        int n4 = insets.left;
        int n5 = container.size().width - insets.right;
        for (int i2 = 0; i2 < container.countComponents(); ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            int n6 = component.size().width;
            component.resize(n6, n3 - n2);
            Dimension dimension = component.preferredSize();
            component.reshape(n4, n2, dimension.width, n3 - n2);
            n4 += dimension.width + this.hgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + "]";
    }
}

