/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    protected Vector<TableColumn> tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    public DefaultTableColumnModel() {
        this.tableColumns = new Vector();
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.tableColumns.addElement(tableColumn);
        tableColumn.addPropertyChangeListener(this);
        this.invalidateWidthCache();
        this.checkLeadAnchor();
        this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
    }

    @Override
    public void removeColumn(TableColumn tableColumn) {
        int n2 = this.tableColumns.indexOf(tableColumn);
        if (n2 != -1) {
            if (this.selectionModel != null) {
                this.selectionModel.removeIndexInterval(n2, n2);
            }
            this.checkLeadAnchor();
            tableColumn.removePropertyChangeListener(this);
            this.tableColumns.removeElementAt(n2);
            this.invalidateWidthCache();
            this.fireColumnRemoved(new TableColumnModelEvent(this, n2, 0));
        }
    }

    @Override
    public void moveColumn(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getColumnCount() || n3 < 0 || n3 >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        if (n2 == n3) {
            this.fireColumnMoved(new TableColumnModelEvent(this, n2, n3));
            return;
        }
        TableColumn tableColumn = this.tableColumns.elementAt(n2);
        this.tableColumns.removeElementAt(n2);
        boolean bl2 = this.selectionModel.isSelectedIndex(n2);
        this.selectionModel.removeIndexInterval(n2, n2);
        this.tableColumns.insertElementAt(tableColumn, n3);
        this.selectionModel.insertIndexInterval(n3, 1, true);
        if (bl2) {
            this.selectionModel.addSelectionInterval(n3, n3);
        } else {
            this.selectionModel.removeSelectionInterval(n3, n3);
        }
        this.fireColumnMoved(new TableColumnModelEvent(this, n2, n3));
    }

    @Override
    public void setColumnMargin(int n2) {
        if (n2 != this.columnMargin) {
            this.columnMargin = n2;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return this.tableColumns.elements();
    }

    @Override
    public int getColumnIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration<TableColumn> enumeration = this.getColumns();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (object.equals(tableColumn.getIdentifier())) {
                return n2;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    @Override
    public TableColumn getColumn(int n2) {
        return this.tableColumns.elementAt(n2);
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    @Override
    public int getColumnIndexAtX(int n2) {
        if (n2 < 0) {
            return -1;
        }
        int n3 = this.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if ((n2 -= this.getColumn(i2).getWidth()) >= 0) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
            this.checkLeadAnchor();
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void checkLeadAnchor() {
        int n2 = this.selectionModel.getLeadSelectionIndex();
        int n3 = this.tableColumns.size();
        if (n3 == 0) {
            if (n2 != -1) {
                this.selectionModel.setValueIsAdjusting(true);
                this.selectionModel.setAnchorSelectionIndex(-1);
                this.selectionModel.setLeadSelectionIndex(-1);
                this.selectionModel.setValueIsAdjusting(false);
            }
        } else if (n2 == -1) {
            if (this.selectionModel.isSelectedIndex(0)) {
                this.selectionModel.addSelectionInterval(0, 0);
            } else {
                this.selectionModel.removeSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl2) {
        this.columnSelectionAllowed = bl2;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int n2 = this.selectionModel.getMinSelectionIndex();
            int n3 = this.selectionModel.getMaxSelectionIndex();
            if (n2 == -1 || n3 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n3 - n2)];
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.selectionModel.isSelectedIndex(i2)) continue;
                nArray[n4++] = i2;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int n2 = this.selectionModel.getMinSelectionIndex();
            int n3 = this.selectionModel.getMaxSelectionIndex();
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.selectionModel.isSelectedIndex(i2)) continue;
                ++n4;
            }
            return n4;
        }
        return 0;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.add(TableColumnModelListener.class, tableColumnModelListener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
        this.listenerList.remove(TableColumnModelListener.class, tableColumnModelListener);
    }

    public TableColumnModelListener[] getColumnModelListeners() {
        return (TableColumnModelListener[])this.listenerList.getListeners(TableColumnModelListener.class);
    }

    protected void fireColumnAdded(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnAdded(tableColumnModelEvent);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnRemoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent tableColumnModelEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnMoved(tableColumnModelEvent);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)objectArray[i2 + 1]).columnSelectionChanged(listSelectionEvent);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableColumnModelListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((TableColumnModelListener)objectArray[i2 + 1]).columnMarginChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "width" || string == "preferredWidth") {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.fireColumnSelectionChanged(listSelectionEvent);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void recalcWidthCache() {
        Enumeration<TableColumn> enumeration = this.getColumns();
        this.totalColumnWidth = 0;
        while (enumeration.hasMoreElements()) {
            this.totalColumnWidth += enumeration.nextElement().getWidth();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

