/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.DefaultSynthStyleFactory;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthCheckBoxMenuItemUI;
import javax.swing.plaf.synth.SynthCheckBoxUI;
import javax.swing.plaf.synth.SynthColorChooserUI;
import javax.swing.plaf.synth.SynthComboBoxUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthDefaultLookup;
import javax.swing.plaf.synth.SynthDesktopIconUI;
import javax.swing.plaf.synth.SynthDesktopPaneUI;
import javax.swing.plaf.synth.SynthEditorPaneUI;
import javax.swing.plaf.synth.SynthFormattedTextFieldUI;
import javax.swing.plaf.synth.SynthInternalFrameUI;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthListUI;
import javax.swing.plaf.synth.SynthMenuBarUI;
import javax.swing.plaf.synth.SynthMenuItemUI;
import javax.swing.plaf.synth.SynthMenuUI;
import javax.swing.plaf.synth.SynthOptionPaneUI;
import javax.swing.plaf.synth.SynthPanelUI;
import javax.swing.plaf.synth.SynthParser;
import javax.swing.plaf.synth.SynthPasswordFieldUI;
import javax.swing.plaf.synth.SynthPopupMenuUI;
import javax.swing.plaf.synth.SynthProgressBarUI;
import javax.swing.plaf.synth.SynthRadioButtonMenuItemUI;
import javax.swing.plaf.synth.SynthRadioButtonUI;
import javax.swing.plaf.synth.SynthRootPaneUI;
import javax.swing.plaf.synth.SynthScrollBarUI;
import javax.swing.plaf.synth.SynthScrollPaneUI;
import javax.swing.plaf.synth.SynthSeparatorUI;
import javax.swing.plaf.synth.SynthSliderUI;
import javax.swing.plaf.synth.SynthSpinnerUI;
import javax.swing.plaf.synth.SynthSplitPaneUI;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import javax.swing.plaf.synth.SynthTabbedPaneUI;
import javax.swing.plaf.synth.SynthTableHeaderUI;
import javax.swing.plaf.synth.SynthTableUI;
import javax.swing.plaf.synth.SynthTextAreaUI;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.plaf.synth.SynthTextPaneUI;
import javax.swing.plaf.synth.SynthToggleButtonUI;
import javax.swing.plaf.synth.SynthToolBarUI;
import javax.swing.plaf.synth.SynthToolTipUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.plaf.synth.SynthViewportUI;
import sun.awt.AppContext;
import sun.swing.DefaultLookup;
import sun.swing.plaf.synth.SynthFileChooserUI;
import sun.swing.plaf.synth.SynthUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthLookAndFeel
extends BasicLookAndFeel {
    static final Insets EMPTY_UIRESOURCE_INSETS = new InsetsUIResource(0, 0, 0, 0);
    private static final Object STYLE_FACTORY_KEY = new StringBuffer("com.sun.java.swing.plaf.gtk.StyleCache");
    private static SynthStyleFactory lastFactory;
    private static boolean multipleApps;
    private static AppContext lastContext;
    static ComponentUI selectedUI;
    static int selectedUIState;
    private SynthStyleFactory factory = new DefaultSynthStyleFactory();
    private Map defaultsMap;

    static void setSelectedUI(ComponentUI componentUI, boolean bl2, boolean bl3, boolean bl4) {
        selectedUI = componentUI;
        selectedUIState = 0;
        if (bl2) {
            selectedUIState = 512;
            if (bl3) {
                selectedUIState |= 0x100;
            }
        } else {
            selectedUIState = 256;
            selectedUIState = bl4 ? (selectedUIState |= 1) : (selectedUIState |= 8);
        }
    }

    static void resetSelectedUI() {
        selectedUI = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStyleFactory(SynthStyleFactory synthStyleFactory) {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            AppContext appContext = AppContext.getAppContext();
            if (!multipleApps && appContext != lastContext && lastContext != null) {
                multipleApps = true;
            }
            lastFactory = synthStyleFactory;
            lastContext = appContext;
            appContext.put(STYLE_FACTORY_KEY, synthStyleFactory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthStyleFactory getStyleFactory() {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            if (!multipleApps) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return lastFactory;
            }
            AppContext appContext = AppContext.getAppContext();
            if (lastContext == appContext) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return lastFactory;
            }
            lastContext = appContext;
            lastFactory = (SynthStyleFactory)AppContext.getAppContext().get(STYLE_FACTORY_KEY);
            // ** MonitorExit[var0] (shouldn't be in output)
            return lastFactory;
        }
    }

    static int getComponentState(Component component) {
        if (component.isEnabled()) {
            if (component.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    public static SynthStyle getStyle(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getStyleFactory().getStyle(jComponent, region);
    }

    static boolean shouldUpdateStyle(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name" == string) {
            return true;
        }
        if ("ancestor" == string && propertyChangeEvent.getNewValue() != null) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            return lookAndFeel instanceof SynthLookAndFeel && ((SynthLookAndFeel)lookAndFeel).shouldUpdateStyleOnAncestorChanged();
        }
        return false;
    }

    static SynthStyle updateStyle(SynthContext synthContext, SynthUI synthUI) {
        SynthStyle synthStyle;
        SynthStyle synthStyle2 = SynthLookAndFeel.getStyle(synthContext.getComponent(), synthContext.getRegion());
        if (synthStyle2 != (synthStyle = synthContext.getStyle())) {
            if (synthStyle != null) {
                synthStyle.uninstallDefaults(synthContext);
            }
            synthContext.setStyle(synthStyle2);
            synthStyle2.installDefaults(synthContext, synthUI);
        }
        return synthStyle2;
    }

    public static void updateStyles(Component component) {
        SynthLookAndFeel._updateStyles(component);
        component.repaint();
    }

    private static void _updateStyles(Component component) {
        Component[] componentArray;
        if (component instanceof JComponent) {
            componentArray = component.getName();
            component.setName(null);
            if (componentArray != null) {
                component.setName((String)componentArray);
            }
            ((JComponent)component).revalidate();
        }
        componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                SynthLookAndFeel.updateStyles(componentArray[i2]);
            }
        }
    }

    public static Region getRegion(JComponent jComponent) {
        return Region.getRegion(jComponent);
    }

    static Insets getPaintingInsets(SynthContext synthContext, Insets insets) {
        insets = synthContext.isSubregion() ? synthContext.getStyle().getInsets(synthContext, insets) : synthContext.getComponent().getInsets(insets);
        return insets;
    }

    static void update(SynthContext synthContext, Graphics graphics) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, null);
    }

    static void updateSubregion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, rectangle);
    }

    private static void paintRegion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n2;
        int n3;
        int n4;
        int n5;
        JComponent jComponent = synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        if (rectangle == null) {
            n5 = 0;
            n4 = 0;
            n3 = jComponent.getWidth();
            n2 = jComponent.getHeight();
        } else {
            n5 = rectangle.x;
            n4 = rectangle.y;
            n3 = rectangle.width;
            n2 = rectangle.height;
        }
        boolean bl2 = synthContext.isSubregion();
        if (bl2 && synthStyle.isOpaque(synthContext) || !bl2 && jComponent.isOpaque()) {
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n5, n4, n3, n2);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        String string = jComponent.getUIClassID().intern();
        if (string == "ButtonUI") {
            return SynthButtonUI.createUI(jComponent);
        }
        if (string == "CheckBoxUI") {
            return SynthCheckBoxUI.createUI(jComponent);
        }
        if (string == "CheckBoxMenuItemUI") {
            return SynthCheckBoxMenuItemUI.createUI(jComponent);
        }
        if (string == "ColorChooserUI") {
            return SynthColorChooserUI.createUI(jComponent);
        }
        if (string == "ComboBoxUI") {
            return SynthComboBoxUI.createUI(jComponent);
        }
        if (string == "DesktopPaneUI") {
            return SynthDesktopPaneUI.createUI(jComponent);
        }
        if (string == "DesktopIconUI") {
            return SynthDesktopIconUI.createUI(jComponent);
        }
        if (string == "EditorPaneUI") {
            return SynthEditorPaneUI.createUI(jComponent);
        }
        if (string == "FileChooserUI") {
            return SynthFileChooserUI.createUI(jComponent);
        }
        if (string == "FormattedTextFieldUI") {
            return SynthFormattedTextFieldUI.createUI(jComponent);
        }
        if (string == "InternalFrameUI") {
            return SynthInternalFrameUI.createUI(jComponent);
        }
        if (string == "LabelUI") {
            return SynthLabelUI.createUI(jComponent);
        }
        if (string == "ListUI") {
            return SynthListUI.createUI(jComponent);
        }
        if (string == "MenuBarUI") {
            return SynthMenuBarUI.createUI(jComponent);
        }
        if (string == "MenuUI") {
            return SynthMenuUI.createUI(jComponent);
        }
        if (string == "MenuItemUI") {
            return SynthMenuItemUI.createUI(jComponent);
        }
        if (string == "OptionPaneUI") {
            return SynthOptionPaneUI.createUI(jComponent);
        }
        if (string == "PanelUI") {
            return SynthPanelUI.createUI(jComponent);
        }
        if (string == "PasswordFieldUI") {
            return SynthPasswordFieldUI.createUI(jComponent);
        }
        if (string == "PopupMenuSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "PopupMenuUI") {
            return SynthPopupMenuUI.createUI(jComponent);
        }
        if (string == "ProgressBarUI") {
            return SynthProgressBarUI.createUI(jComponent);
        }
        if (string == "RadioButtonUI") {
            return SynthRadioButtonUI.createUI(jComponent);
        }
        if (string == "RadioButtonMenuItemUI") {
            return SynthRadioButtonMenuItemUI.createUI(jComponent);
        }
        if (string == "RootPaneUI") {
            return SynthRootPaneUI.createUI(jComponent);
        }
        if (string == "ScrollBarUI") {
            return SynthScrollBarUI.createUI(jComponent);
        }
        if (string == "ScrollPaneUI") {
            return SynthScrollPaneUI.createUI(jComponent);
        }
        if (string == "SeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "SliderUI") {
            return SynthSliderUI.createUI(jComponent);
        }
        if (string == "SpinnerUI") {
            return SynthSpinnerUI.createUI(jComponent);
        }
        if (string == "SplitPaneUI") {
            return SynthSplitPaneUI.createUI(jComponent);
        }
        if (string == "TabbedPaneUI") {
            return SynthTabbedPaneUI.createUI(jComponent);
        }
        if (string == "TableUI") {
            return SynthTableUI.createUI(jComponent);
        }
        if (string == "TableHeaderUI") {
            return SynthTableHeaderUI.createUI(jComponent);
        }
        if (string == "TextAreaUI") {
            return SynthTextAreaUI.createUI(jComponent);
        }
        if (string == "TextFieldUI") {
            return SynthTextFieldUI.createUI(jComponent);
        }
        if (string == "TextPaneUI") {
            return SynthTextPaneUI.createUI(jComponent);
        }
        if (string == "ToggleButtonUI") {
            return SynthToggleButtonUI.createUI(jComponent);
        }
        if (string == "ToolBarSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "ToolBarUI") {
            return SynthToolBarUI.createUI(jComponent);
        }
        if (string == "ToolTipUI") {
            return SynthToolTipUI.createUI(jComponent);
        }
        if (string == "TreeUI") {
            return SynthTreeUI.createUI(jComponent);
        }
        if (string == "ViewportUI") {
            return SynthViewportUI.createUI(jComponent);
        }
        return null;
    }

    public void load(InputStream inputStream, Class<?> clazz) throws ParseException, IllegalArgumentException {
        if (this.defaultsMap == null) {
            this.defaultsMap = new HashMap();
        }
        new SynthParser().parse(inputStream, (DefaultSynthStyleFactory)this.factory, clazz, this.defaultsMap);
    }

    @Override
    public void initialize() {
        super.initialize();
        DefaultLookup.setDefaultLookup(new SynthDefaultLookup());
        SynthLookAndFeel.setStyleFactory(this.factory);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        Region.registerUIs(uIDefaults);
        uIDefaults.setDefaultLocale(Locale.getDefault());
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.synth.resources.synth");
        uIDefaults.put("ColorChooser.swatchesRecentSwatchSize", new Dimension(10, 10));
        uIDefaults.put("ColorChooser.swatchesDefaultRecentColor", Color.RED);
        uIDefaults.put("ColorChooser.swatchesSwatchSize", new Dimension(10, 10));
        uIDefaults.put("PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"});
        uIDefaults.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"});
        if (this.defaultsMap != null) {
            uIDefaults.putAll(this.defaultsMap);
        }
        return uIDefaults;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Synth look and feel";
    }

    @Override
    public String getName() {
        return "Synth look and feel";
    }

    @Override
    public String getID() {
        return "Synth";
    }

    public boolean shouldUpdateStyleOnAncestorChanged() {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

