/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicMenuBarUI
extends MenuBarUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("takeFocus"));
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        LookAndFeel.installProperty(this.menuBar, "opaque", Boolean.TRUE);
        LookAndFeel.installBorder(this.menuBar, "MenuBar.border");
        LookAndFeel.installColorsAndFont(this.menuBar, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().addChangeListener(this.changeListener);
        }
        this.menuBar.addContainerListener(this.containerListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        LazyActionMap.installLazyActionMap(this.menuBar, BasicMenuBarUI.class, "MenuBar.actionMap");
    }

    InputMap getInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])DefaultLookup.get(this.menuBar, this, "MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.menuBar, objectArray);
        }
        return null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected void uninstallDefaults() {
        if (this.menuBar != null) {
            LookAndFeel.uninstallBorder(this.menuBar);
        }
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().removeChangeListener(this.changeListener);
        }
        this.containerListener = null;
        this.changeListener = null;
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected ContainerListener createContainerListener() {
        return this.getHandler();
    }

    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String TAKE_FOCUS = "takeFocus";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }

    private class Handler
    implements ChangeListener,
    ContainerListener {
        private Handler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2 = BasicMenuBarUI.this.menuBar.getMenuCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(i2);
                if (jMenu == null || !jMenu.isSelected()) continue;
                BasicMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(i2);
                break;
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(BasicMenuBarUI.this.changeListener);
            }
        }
    }
}

