/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;

    public SysexMessage() {
        this(new byte[2]);
        this.data[0] = -16;
        this.data[1] = -9;
    }

    protected SysexMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(byte[] byArray, int n2) throws InvalidMidiDataException {
        int n3 = byArray[0] & 0xFF;
        if (n3 != 240 && n3 != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(n3));
        }
        super.setMessage(byArray, n2);
    }

    public void setMessage(int n2, byte[] byArray, int n3) throws InvalidMidiDataException {
        if (n2 != 240 && n2 != 247) {
            throw new InvalidMidiDataException("Invalid status byte for sysex message: 0x" + Integer.toHexString(n2));
        }
        if (n3 < 0 || n3 > byArray.length) {
            throw new IndexOutOfBoundsException("length out of bounds: " + n3);
        }
        this.length = n3 + 1;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[this.length];
        }
        this.data[0] = (byte)(n2 & 0xFF);
        if (n3 > 0) {
            System.arraycopy(byArray, 0, this.data, 1, n3);
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, byArray, 0, this.length - 1);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        SysexMessage sysexMessage = new SysexMessage(byArray);
        return sysexMessage;
    }
}

