/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

class MemoryCache {
    private static final int BUFFER_LENGTH = 8192;
    private ArrayList cache = new ArrayList();
    private long cacheStart = 0L;
    private long length = 0L;

    MemoryCache() {
    }

    private byte[] getCacheBlock(long l2) throws IOException {
        long l3 = l2 - this.cacheStart;
        if (l3 > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return (byte[])this.cache.get((int)l3);
    }

    public long loadFromStream(InputStream inputStream, long l2) throws IOException {
        if (l2 < this.length) {
            return l2;
        }
        int n2 = (int)(this.length % 8192L);
        byte[] byArray = null;
        long l3 = l2 - this.length;
        if (n2 != 0) {
            byArray = this.getCacheBlock(this.length / 8192L);
        }
        while (l3 > 0L) {
            if (byArray == null) {
                try {
                    byArray = new byte[8192];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new IOException("No memory left for cache!");
                }
                n2 = 0;
            }
            int n3 = 8192 - n2;
            int n4 = (int)Math.min(l3, (long)n3);
            if ((n4 = inputStream.read(byArray, n2, n4)) == -1) {
                return this.length;
            }
            if (n2 == 0) {
                this.cache.add(byArray);
            }
            l3 -= (long)n4;
            this.length += (long)n4;
            if ((n2 += n4) < 8192) continue;
            byArray = null;
        }
        return l2;
    }

    public void writeToStream(OutputStream outputStream, long l2, long l3) throws IOException {
        if (l2 + l3 > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (l2 < 0L || l3 < 0L) {
            throw new IndexOutOfBoundsException("Negative pos or len");
        }
        if (l3 == 0L) {
            return;
        }
        long l4 = l2 / 8192L;
        if (l4 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        int n2 = (int)(l2 % 8192L);
        byte[] byArray = this.getCacheBlock(l4++);
        while (l3 > 0L) {
            if (byArray == null) {
                byArray = this.getCacheBlock(l4++);
                n2 = 0;
            }
            int n3 = (int)Math.min(l3, (long)(8192 - n2));
            outputStream.write(byArray, n2, n3);
            byArray = null;
            l3 -= (long)n3;
        }
    }

    private void pad(long l2) throws IOException {
        long l3 = this.cacheStart + (long)this.cache.size() - 1L;
        long l4 = l2 / 8192L;
        long l5 = l4 - l3;
        for (long i2 = 0L; i2 < l5; ++i2) {
            try {
                this.cache.add(new byte[8192]);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException("No memory left for cache!");
            }
        }
    }

    public void write(byte[] byArray, int n2, int n3, long l2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n2 < 0 || n3 < 0 || l2 < 0L || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        long l3 = l2 + (long)n3 - 1L;
        if (l3 >= this.length) {
            this.pad(l3);
            this.length = l3 + 1L;
        }
        int n4 = (int)(l2 % 8192L);
        while (n3 > 0) {
            byte[] byArray2 = this.getCacheBlock(l2 / 8192L);
            int n5 = Math.min(n3, 8192 - n4);
            System.arraycopy(byArray, n2, byArray2, n4, n5);
            l2 += (long)n5;
            n2 += n5;
            n3 -= n5;
            n4 = 0;
        }
    }

    public void write(int n2, long l2) throws IOException {
        if (l2 < 0L) {
            throw new ArrayIndexOutOfBoundsException("pos < 0");
        }
        if (l2 >= this.length) {
            this.pad(l2);
            this.length = l2 + 1L;
        }
        byte[] byArray = this.getCacheBlock(l2 / 8192L);
        int n3 = (int)(l2 % 8192L);
        byArray[n3] = (byte)n2;
    }

    public long getLength() {
        return this.length;
    }

    public int read(long l2) throws IOException {
        if (l2 >= this.length) {
            return -1;
        }
        byte[] byArray = this.getCacheBlock(l2 / 8192L);
        if (byArray == null) {
            return -1;
        }
        return byArray[(int)(l2 % 8192L)] & 0xFF;
    }

    public void read(byte[] byArray, int n2, int n3, long l2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null!");
        }
        if (n2 < 0 || n3 < 0 || l2 < 0L || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (l2 + (long)n3 > this.length) {
            throw new IndexOutOfBoundsException();
        }
        long l3 = l2 / 8192L;
        int n4 = (int)l2 % 8192;
        while (n3 > 0) {
            int n5 = Math.min(n3, 8192 - n4);
            byte[] byArray2 = this.getCacheBlock(l3++);
            System.arraycopy(byArray2, n4, byArray, n2, n5);
            n3 -= n5;
            n2 += n5;
            n4 = 0;
        }
    }

    public void disposeBefore(long l2) {
        long l3 = l2 / 8192L;
        if (l3 < this.cacheStart) {
            throw new IndexOutOfBoundsException("pos already disposed");
        }
        long l4 = Math.min(l3 - this.cacheStart, (long)this.cache.size());
        for (long i2 = 0L; i2 < l4; ++i2) {
            this.cache.remove(0);
        }
        this.cacheStart = l3;
    }

    public void reset() {
        this.cache.clear();
        this.cacheStart = 0L;
        this.length = 0L;
    }
}

