/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.util.Locale;
import javax.imageio.IIOParam;

public class ImageWriteParam
extends IIOParam {
    public static final int MODE_DISABLED = 0;
    public static final int MODE_DEFAULT = 1;
    public static final int MODE_EXPLICIT = 2;
    public static final int MODE_COPY_FROM_METADATA = 3;
    private static final int MAX_MODE = 3;
    protected boolean canWriteTiles = false;
    protected int tilingMode = 3;
    protected Dimension[] preferredTileSizes = null;
    protected boolean tilingSet = false;
    protected int tileWidth = 0;
    protected int tileHeight = 0;
    protected boolean canOffsetTiles = false;
    protected int tileGridXOffset = 0;
    protected int tileGridYOffset = 0;
    protected boolean canWriteProgressive = false;
    protected int progressiveMode = 3;
    protected boolean canWriteCompressed = false;
    protected int compressionMode = 3;
    protected String[] compressionTypes = null;
    protected String compressionType = null;
    protected float compressionQuality = 1.0f;
    protected Locale locale = null;

    protected ImageWriteParam() {
    }

    public ImageWriteParam(Locale locale) {
        this.locale = locale;
    }

    private static Dimension[] clonePreferredTileSizes(Dimension[] dimensionArray) {
        if (dimensionArray == null) {
            return null;
        }
        Dimension[] dimensionArray2 = new Dimension[dimensionArray.length];
        for (int i2 = 0; i2 < dimensionArray.length; ++i2) {
            dimensionArray2[i2] = new Dimension(dimensionArray[i2]);
        }
        return dimensionArray2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean canWriteTiles() {
        return this.canWriteTiles;
    }

    public boolean canOffsetTiles() {
        return this.canOffsetTiles;
    }

    public void setTilingMode(int n2) {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal value for mode!");
        }
        this.tilingMode = n2;
        if (n2 == 2) {
            this.unsetTiling();
        }
    }

    public int getTilingMode() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported");
        }
        return this.tilingMode;
    }

    public Dimension[] getPreferredTileSizes() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported");
        }
        return ImageWriteParam.clonePreferredTileSizes(this.preferredTileSizes);
    }

    public void setTiling(int n2, int n3, int n4, int n5) {
        boolean bl2;
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("tile dimensions are non-positive!");
        }
        boolean bl3 = bl2 = n4 != 0 || n5 != 0;
        if (!this.canOffsetTiles() && bl2) {
            throw new UnsupportedOperationException("Can't offset tiles!");
        }
        if (this.preferredTileSizes != null) {
            boolean bl4 = true;
            for (int i2 = 0; i2 < this.preferredTileSizes.length; i2 += 2) {
                Dimension dimension = this.preferredTileSizes[i2];
                Dimension dimension2 = this.preferredTileSizes[i2 + 1];
                if (n2 >= dimension.width && n2 <= dimension2.width && n3 >= dimension.height && n3 <= dimension2.height) continue;
                bl4 = false;
                break;
            }
            if (!bl4) {
                throw new IllegalArgumentException("Illegal tile size!");
            }
        }
        this.tilingSet = true;
        this.tileWidth = n2;
        this.tileHeight = n3;
        this.tileGridXOffset = n4;
        this.tileGridYOffset = n5;
    }

    public void unsetTiling() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        this.tilingSet = false;
        this.tileWidth = 0;
        this.tileHeight = 0;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
    }

    public int getTileWidth() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileWidth;
    }

    public int getTileHeight() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileHeight;
    }

    public int getTileGridXOffset() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException("Tiling not supported!");
        }
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException("Tiling mode not MODE_EXPLICIT!");
        }
        if (!this.tilingSet) {
            throw new IllegalStateException("Tiling parameters not set!");
        }
        return this.tileGridYOffset;
    }

    public boolean canWriteProgressive() {
        return this.canWriteProgressive;
    }

    public void setProgressiveMode(int n2) {
        if (!this.canWriteProgressive()) {
            throw new UnsupportedOperationException("Progressive output not supported");
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal value for mode!");
        }
        if (n2 == 2) {
            throw new IllegalArgumentException("MODE_EXPLICIT not supported for progressive output");
        }
        this.progressiveMode = n2;
    }

    public int getProgressiveMode() {
        if (!this.canWriteProgressive()) {
            throw new UnsupportedOperationException("Progressive output not supported");
        }
        return this.progressiveMode;
    }

    public boolean canWriteCompressed() {
        return this.canWriteCompressed;
    }

    public void setCompressionMode(int n2) {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal value for mode!");
        }
        this.compressionMode = n2;
        if (n2 == 2) {
            this.unsetCompression();
        }
    }

    public int getCompressionMode() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        return this.compressionMode;
    }

    public String[] getCompressionTypes() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported");
        }
        if (this.compressionTypes == null) {
            return null;
        }
        return (String[])this.compressionTypes.clone();
    }

    public void setCompressionType(String string) {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        String[] stringArray = this.getCompressionTypes();
        if (stringArray == null) {
            throw new UnsupportedOperationException("No settable compression types");
        }
        if (string != null) {
            boolean bl2 = false;
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!string.equals(stringArray[i2])) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) {
                throw new IllegalArgumentException("Unknown compression type!");
            }
        }
        this.compressionType = string;
    }

    public String getCompressionType() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        return this.compressionType;
    }

    public void unsetCompression() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        this.compressionType = null;
        this.compressionQuality = 1.0f;
    }

    public String getLocalizedCompressionTypeName() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return this.getCompressionType();
    }

    public boolean isCompressionLossless() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return true;
    }

    public void setCompressionQuality(float f2) {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Quality out-of-bounds!");
        }
        this.compressionQuality = f2;
    }

    public float getCompressionQuality() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return this.compressionQuality;
    }

    public float getBitRate(float f2) {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Quality out-of-bounds!");
        }
        return -1.0f;
    }

    public String[] getCompressionQualityDescriptions() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return null;
    }

    public float[] getCompressionQualityValues() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException("Compression not supported.");
        }
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return null;
    }
}

