/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed = false;
    private boolean entryEOF = false;
    private byte[] b = new byte[256];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipInputStream(InputStream inputStream) {
        super(new PushbackInputStream(inputStream, 512), new Inflater(true), 512);
        this.usesDefaultInflater = true;
        if (inputStream == null) {
            throw new NullPointerException("in is null");
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.inf.reset();
        this.entry = this.readLOC();
        if (this.entry == null) {
            return null;
        }
        if (this.entry.method == 0) {
            this.remaining = this.entry.size;
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.method) {
            case 8: {
                n3 = super.read(byArray, n2, n3);
                if (n3 == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(byArray, n2, n3);
                }
                return n3;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)n3 > this.remaining) {
                    n3 = (int)this.remaining;
                }
                if ((n3 = this.in.read(byArray, n2, n3)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(byArray, n2, n3);
                this.remaining -= (long)n3;
                return n3;
            }
        }
        throw new InternalError("invalid compression method");
    }

    public long skip(long l2) throws IOException {
        int n2;
        int n3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n4 = (int)Math.min(l2, Integer.MAX_VALUE);
        for (n2 = 0; n2 < n4; n2 += n3) {
            n3 = n4 - n2;
            if (n3 > this.tmpbuf.length) {
                n3 = this.tmpbuf.length;
            }
            if ((n3 = this.read(this.tmpbuf, 0, n3)) != -1) continue;
            this.entryEOF = true;
            break;
        }
        return n2;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException eOFException) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        int n2 = ZipInputStream.get16(this.tmpbuf, 26);
        if (n2 == 0) {
            throw new ZipException("missing entry name");
        }
        int n3 = this.b.length;
        if (n2 > n3) {
            while (n2 > (n3 *= 2)) {
            }
            this.b = new byte[n3];
        }
        this.readFully(this.b, 0, n2);
        ZipEntry zipEntry = this.createZipEntry(ZipInputStream.getUTF8String(this.b, 0, n2));
        zipEntry.version = ZipInputStream.get16(this.tmpbuf, 4);
        zipEntry.flag = ZipInputStream.get16(this.tmpbuf, 6);
        if ((zipEntry.flag & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        zipEntry.method = ZipInputStream.get16(this.tmpbuf, 8);
        zipEntry.time = ZipInputStream.get32(this.tmpbuf, 10);
        if ((zipEntry.flag & 8) == 8) {
            if (zipEntry.method != 8) {
                throw new ZipException("only DEFLATED entries can have EXT descriptor");
            }
        } else {
            zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 14);
            zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 18);
            zipEntry.size = ZipInputStream.get32(this.tmpbuf, 22);
        }
        if ((n2 = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] byArray = new byte[n2];
            this.readFully(byArray, 0, n2);
            zipEntry.extra = byArray;
        }
        return zipEntry;
    }

    private static String getUTF8String(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 + n3;
        int n6 = n2;
        block10: while (n6 < n5) {
            int n7 = byArray[n6++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((byArray[n6++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n4;
                    continue block10;
                }
                case 14: {
                    if ((byArray[n6++] & 0xC0) != 128 || (byArray[n6++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n4;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (n6 != n5) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n4];
        n6 = 0;
        block11: while (n2 < n5) {
            int n8 = byArray[n2++] & 0xFF;
            switch (n8 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)n8;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cArray[n6++] = (char)((n8 & 0x1F) << 6 | byArray[n2++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int n9 = (byArray[n2++] & 0x3F) << 6;
                    cArray[n6++] = (char)((n8 & 0xF) << 12 | n9 | byArray[n2++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cArray, 0, n4);
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }

    private void readEnd(ZipEntry zipEntry) throws IOException {
        int n2 = this.inf.getRemaining();
        if (n2 > 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - n2, n2);
        }
        if ((zipEntry.flag & 8) == 8) {
            this.readFully(this.tmpbuf, 0, 16);
            long l2 = ZipInputStream.get32(this.tmpbuf, 0);
            if (l2 != 134695760L) {
                zipEntry.crc = l2;
                zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 4);
                zipEntry.size = ZipInputStream.get32(this.tmpbuf, 8);
                ((PushbackInputStream)this.in).unread(this.tmpbuf, 11, 4);
            } else {
                zipEntry.crc = ZipInputStream.get32(this.tmpbuf, 4);
                zipEntry.csize = ZipInputStream.get32(this.tmpbuf, 8);
                zipEntry.size = ZipInputStream.get32(this.tmpbuf, 12);
            }
        }
        if (zipEntry.size != this.inf.getBytesWritten()) {
            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.inf.getBytesWritten() + " bytes)");
        }
        if (zipEntry.csize != this.inf.getBytesRead()) {
            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.inf.getBytesRead() + " bytes)");
        }
        if (zipEntry.crc != this.crc.getValue()) {
            throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
        }
    }

    private void readFully(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.in.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    private static final int get16(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n2) {
        return (long)ZipInputStream.get16(byArray, n2) | (long)ZipInputStream.get16(byArray, n2 + 2) << 16;
    }
}

