/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlSupport {
    private static final String PREFS_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String EXTERNAL_XML_VERSION = "1.0";
    private static final String MAP_XML_VERSION = "1.0";

    XmlSupport() {
    }

    static void export(OutputStream outputStream, Preferences preferences, boolean bl2) throws IOException, BackingStoreException {
        if (((AbstractPreferences)preferences).isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        Document document = XmlSupport.createPrefsDoc("preferences");
        Element element = document.getDocumentElement();
        element.setAttribute("EXTERNAL_XML_VERSION", "1.0");
        Element element2 = (Element)element.appendChild(document.createElement("root"));
        element2.setAttribute("type", preferences.isUserNode() ? "user" : "system");
        ArrayList<Preferences> arrayList = new ArrayList<Preferences>();
        Object object = preferences;
        Preferences preferences2 = ((Preferences)object).parent();
        while (preferences2 != null) {
            arrayList.add((Preferences)object);
            object = preferences2;
            preferences2 = ((Preferences)object).parent();
        }
        object = element2;
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            object.appendChild(document.createElement("map"));
            object = (Element)object.appendChild(document.createElement("node"));
            object.setAttribute("name", ((Preferences)arrayList.get(i2)).name());
        }
        XmlSupport.putPreferencesInXml((Element)object, document, preferences, bl2);
        XmlSupport.writeDoc(document, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putPreferencesInXml(Element element, Document document, Preferences preferences, boolean bl2) throws BackingStoreException {
        Object object;
        Preferences[] preferencesArray = null;
        String[] stringArray = null;
        Object object2 = ((AbstractPreferences)preferences).lock;
        synchronized (object2) {
            int n2;
            if (((AbstractPreferences)preferences).isRemoved()) {
                element.getParentNode().removeChild(element);
                return;
            }
            object = preferences.keys();
            Element element2 = (Element)element.appendChild(document.createElement("map"));
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                Element element3 = (Element)element2.appendChild(document.createElement("entry"));
                element3.setAttribute("key", object[n2]);
                element3.setAttribute("value", preferences.get(object[n2], null));
            }
            if (bl2) {
                stringArray = preferences.childrenNames();
                preferencesArray = new Preferences[stringArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    preferencesArray[n2] = preferences.node(stringArray[n2]);
                }
            }
        }
        if (bl2) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                object = (Element)element.appendChild(document.createElement("node"));
                object.setAttribute("name", stringArray[i2]);
                XmlSupport.putPreferencesInXml((Element)object, document, preferencesArray[i2], bl2);
            }
        }
    }

    static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        try {
            Document document = XmlSupport.loadPrefsDoc(inputStream);
            String string = ((Element)document.getChildNodes().item(1)).getAttribute("EXTERNAL_XML_VERSION");
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            Element element = (Element)document.getChildNodes().item(1).getChildNodes().item(0);
            Preferences preferences = element.getAttribute("type").equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XmlSupport.ImportSubtree(preferences, element);
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static Document createPrefsDoc(String string) {
        try {
            DOMImplementation dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, null, PREFS_DTD_URI);
            return dOMImplementation.createDocument(null, string, documentType);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    private static Document loadPrefsDoc(InputStream inputStream) throws SAXException, IOException {
        Resolver resolver = new Resolver();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new Resolver());
            documentBuilder.setErrorHandler(new EH());
            return documentBuilder.parse(new InputSource(inputStream));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    private static final void writeDoc(Document document, OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw new AssertionError((Object)transformerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ImportSubtree(Preferences preferences, Element element) {
        Preferences[] preferencesArray;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        Object object = ((AbstractPreferences)preferences).lock;
        synchronized (object) {
            if (((AbstractPreferences)preferences).isRemoved()) {
                return;
            }
            Element element2 = (Element)nodeList.item(0);
            XmlSupport.ImportPrefs(preferences, element2);
            preferencesArray = new Preferences[n2 - 1];
            for (int i2 = 1; i2 < n2; ++i2) {
                Element element3 = (Element)nodeList.item(i2);
                preferencesArray[i2 - 1] = preferences.node(element3.getAttribute("name"));
            }
        }
        for (int i3 = 1; i3 < n2; ++i3) {
            XmlSupport.ImportSubtree(preferencesArray[i3 - 1], (Element)nodeList.item(i3));
        }
    }

    private static void ImportPrefs(Preferences preferences, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)nodeList.item(i2);
            preferences.put(element2.getAttribute("key"), element2.getAttribute("value"));
        }
    }

    static void exportMap(OutputStream outputStream, Map map) throws IOException {
        Document document = XmlSupport.createPrefsDoc("map");
        Element element = document.getDocumentElement();
        element.setAttribute("MAP_XML_VERSION", "1.0");
        for (Map.Entry entry : map.entrySet()) {
            Element element2 = (Element)element.appendChild(document.createElement("entry"));
            element2.setAttribute("key", (String)entry.getKey());
            element2.setAttribute("value", (String)entry.getValue());
        }
        XmlSupport.writeDoc(document, outputStream);
    }

    static void importMap(InputStream inputStream, Map map) throws IOException, InvalidPreferencesFormatException {
        try {
            Document document = XmlSupport.loadPrefsDoc(inputStream);
            Element element = (Element)document.getChildNodes().item(1);
            String string = element.getAttribute("MAP_XML_VERSION");
            if (string.compareTo("1.0") > 0) {
                throw new InvalidPreferencesFormatException("Preferences map file format version " + string + " is not supported. This java installation can read" + " versions " + "1.0" + " or older. You may need" + " to install a newer version of JDK.");
            }
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                map.put(element2.getAttribute("key"), element2.getAttribute("value"));
            }
        }
        catch (SAXException sAXException) {
            throw new InvalidPreferencesFormatException(sAXException);
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(XmlSupport.PREFS_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(XmlSupport.PREFS_DTD));
                inputSource.setSystemId(XmlSupport.PREFS_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Invalid system identifier: " + string2);
        }
    }
}

