/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> clazz, Class<W> clazz2, String string) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(clazz, clazz2, string);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T t2, V v2) {
        V v3;
        while (!this.compareAndSet(t2, v3 = this.get(t2), v2)) {
        }
        return v3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<V> vclass;

        AtomicReferenceFieldUpdaterImpl(Class<T> clazz, Class<V> clazz2, String string) {
            Field field = null;
            Class<?> clazz3 = null;
            try {
                field = clazz.getDeclaredField(string);
                clazz3 = field.getType();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (clazz2 != clazz3) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(field.getModifiers())) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.tclass = clazz;
            this.vclass = clazz2;
            this.offset = unsafe.objectFieldOffset(field);
        }

        @Override
        public boolean compareAndSet(T t2, V v2, V v3) {
            if (!this.tclass.isInstance(t2) || v3 != null && !this.vclass.isInstance(v3)) {
                throw new ClassCastException();
            }
            return unsafe.compareAndSwapObject(t2, this.offset, v2, v3);
        }

        @Override
        public boolean weakCompareAndSet(T t2, V v2, V v3) {
            if (!this.tclass.isInstance(t2) || v3 != null && !this.vclass.isInstance(v3)) {
                throw new ClassCastException();
            }
            return unsafe.compareAndSwapObject(t2, this.offset, v2, v3);
        }

        @Override
        public void set(T t2, V v2) {
            if (!this.tclass.isInstance(t2) || v2 != null && !this.vclass.isInstance(v2)) {
                throw new ClassCastException();
            }
            unsafe.putObjectVolatile(t2, this.offset, v2);
        }

        @Override
        public V get(T t2) {
            if (!this.tclass.isInstance(t2)) {
                throw new ClassCastException();
            }
            return (V)unsafe.getObjectVolatile(t2, this.offset);
        }
    }
}

