/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReference<V>
implements Serializable {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile V value;

    public AtomicReference(V v2) {
        this.value = v2;
    }

    public AtomicReference() {
    }

    public final V get() {
        return this.value;
    }

    public final void set(V v2) {
        this.value = v2;
    }

    public final boolean compareAndSet(V v2, V v3) {
        return unsafe.compareAndSwapObject(this, valueOffset, v2, v3);
    }

    public final boolean weakCompareAndSet(V v2, V v3) {
        return unsafe.compareAndSwapObject(this, valueOffset, v2, v3);
    }

    public final V getAndSet(V v2) {
        V v3;
        while (!this.compareAndSet(v3 = this.get(), v2)) {
        }
        return v3;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicReference.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

