/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "head");
    private volatile transient Node<E> head = new Node<Object>(null, null);
    private volatile transient Node<E> tail = this.head;

    private boolean casTail(Node<E> node, Node<E> node2) {
        return tailUpdater.compareAndSet(this, node, node2);
    }

    private boolean casHead(Node<E> node, Node<E> node2) {
        return headUpdater.compareAndSet(this, node, node2);
    }

    public ConcurrentLinkedQueue() {
    }

    public ConcurrentLinkedQueue(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e2) {
        return this.offer(e2);
    }

    @Override
    public boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e2, null);
        while (true) {
            Node<E> node2 = this.tail;
            Node<E> node3 = node2.getNext();
            if (node2 != this.tail) continue;
            if (node3 == null) {
                if (!node2.casNext(node3, node)) continue;
                this.casTail(node2, node);
                return true;
            }
            this.casTail(node2, node3);
        }
    }

    @Override
    public E poll() {
        E e2;
        Node<E> node;
        while (true) {
            Node<E> node2 = this.head;
            Node<E> node3 = this.tail;
            node = node2.getNext();
            if (node2 != this.head) continue;
            if (node2 == node3) {
                if (node == null) {
                    return null;
                }
                this.casTail(node3, node);
                continue;
            }
            if (this.casHead(node2, node) && (e2 = node.getItem()) != null) break;
        }
        node.setItem(null);
        return e2;
    }

    @Override
    public E peek() {
        while (true) {
            Node<E> node = this.head;
            Node<E> node2 = this.tail;
            Node<E> node3 = node.getNext();
            if (node != this.head) continue;
            if (node == node2) {
                if (node3 == null) {
                    return null;
                }
                this.casTail(node2, node3);
                continue;
            }
            E e2 = node3.getItem();
            if (e2 != null) {
                return e2;
            }
            this.casHead(node, node3);
        }
    }

    Node<E> first() {
        while (true) {
            Node<E> node = this.head;
            Node<E> node2 = this.tail;
            Node<E> node3 = node.getNext();
            if (node != this.head) continue;
            if (node == node2) {
                if (node3 == null) {
                    return null;
                }
                this.casTail(node2, node3);
                continue;
            }
            if (node3.getItem() != null) {
                return node3;
            }
            this.casHead(node, node3);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int n2 = 0;
        for (Node<E> node = this.first(); node != null && (node.getItem() == null || ++n2 != Integer.MAX_VALUE); node = node.getNext()) {
        }
        return n2;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        for (Node<E> node = this.first(); node != null; node = node.getNext()) {
            E e2 = node.getItem();
            if (e2 == null || !object.equals(e2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        for (Node<E> node = this.first(); node != null; node = node.getNext()) {
            E e2 = node.getItem();
            if (e2 == null || !object.equals(e2) || !node.casItem(e2, null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (Node<E> node = this.first(); node != null; node = node.getNext()) {
            E e2 = node.getItem();
            if (e2 == null) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList arrayList;
        Node<E> node;
        int n2 = 0;
        for (node = this.first(); node != null && n2 < TArray.length; node = node.getNext()) {
            arrayList = node.getItem();
            if (arrayList == null) continue;
            TArray[n2++] = arrayList;
        }
        if (node == null) {
            if (n2 < TArray.length) {
                TArray[n2] = null;
            }
            return TArray;
        }
        arrayList = new ArrayList();
        for (Node<E> node2 = this.first(); node2 != null; node2 = node2.getNext()) {
            E e2 = node2.getItem();
            if (e2 == null) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray(TArray);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (Node<E> node = this.first(); node != null; node = node.getNext()) {
            E e2 = node.getItem();
            if (e2 == null) continue;
            objectOutputStream.writeObject(e2);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.head = new Node<Object>(null, null);
        this.tail = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node node;
            this.lastRet = this.nextNode;
            Object e2 = this.nextItem;
            Node node2 = node = this.nextNode == null ? ConcurrentLinkedQueue.this.first() : this.nextNode.getNext();
            while (true) {
                if (node == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return e2;
                }
                Object e3 = node.getItem();
                if (e3 != null) {
                    this.nextNode = node;
                    this.nextItem = e3;
                    return e2;
                }
                node = node.getNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node<Object> node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            node.setItem(null);
            this.lastRet = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        private volatile E item;
        private volatile Node<E> next;
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater<Node, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");

        Node(E e2) {
            this.item = e2;
        }

        Node(E e2, Node<E> node) {
            this.item = e2;
            this.next = node;
        }

        E getItem() {
            return this.item;
        }

        boolean casItem(E e2, E e3) {
            return itemUpdater.compareAndSet(this, e2, e3);
        }

        void setItem(E e2) {
            itemUpdater.set(this, e2);
        }

        Node<E> getNext() {
            return this.next;
        }

        boolean casNext(Node<E> node, Node<E> node2) {
            return nextUpdater.compareAndSet(this, node, node2);
        }

        void setNext(Node<E> node) {
            nextUpdater.set(this, node);
        }
    }
}

