/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    int size() {
        return this.size;
    }

    void add(TimerTask timerTask) {
        if (++this.size == this.queue.length) {
            TimerTask[] timerTaskArray = new TimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, timerTaskArray, 0, this.size);
            this.queue = timerTaskArray;
        }
        this.queue[this.size] = timerTask;
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    TimerTask get(int n2) {
        return this.queue[n2];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void quickRemove(int n2) {
        assert (n2 <= this.size);
        this.queue[n2] = this.queue[this.size];
        this.queue[this.size--] = null;
    }

    void rescheduleMin(long l2) {
        this.queue[1].nextExecutionTime = l2;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    private void fixUp(int n2) {
        while (n2 > 1) {
            int n3 = n2 >> 1;
            if (this.queue[n3].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = timerTask;
            n2 = n3;
        }
    }

    private void fixDown(int n2) {
        int n3;
        while ((n3 = n2 << 1) <= this.size && n3 > 0) {
            if (n3 < this.size && this.queue[n3].nextExecutionTime > this.queue[n3 + 1].nextExecutionTime) {
                ++n3;
            }
            if (this.queue[n2].nextExecutionTime <= this.queue[n3].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = timerTask;
            n2 = n3;
        }
    }

    void heapify() {
        for (int i2 = this.size / 2; i2 >= 1; --i2) {
            this.fixDown(i2);
        }
    }
}

