/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECParameterSpec
implements AlgorithmParameterSpec {
    private final EllipticCurve curve;
    private final ECPoint g;
    private final BigInteger n;
    private final int h;

    public ECParameterSpec(EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, int n2) {
        if (ellipticCurve == null) {
            throw new NullPointerException("curve is null");
        }
        if (eCPoint == null) {
            throw new NullPointerException("g is null");
        }
        if (bigInteger == null) {
            throw new NullPointerException("n is null");
        }
        if (bigInteger.signum() != 1) {
            throw new IllegalArgumentException("n is not positive");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("h is not positive");
        }
        this.curve = ellipticCurve;
        this.g = eCPoint;
        this.n = bigInteger;
        this.h = n2;
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public ECPoint getGenerator() {
        return this.g;
    }

    public BigInteger getOrder() {
        return this.n;
    }

    public int getCofactor() {
        return this.h;
    }
}

