/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class ActivationID
implements Serializable {
    private transient Activator activator;
    private transient UID uid = new UID();
    private static final long serialVersionUID = -4608673054848209235L;

    public ActivationID(Activator activator) {
        this.activator = activator;
    }

    public Remote activate(boolean bl2) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            MarshalledObject marshalledObject = this.activator.activate(this, bl2);
            return (Remote)marshalledObject.get();
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            throw new UnmarshalException("activation failed", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("activation failed", classNotFoundException);
        }
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationID) {
            ActivationID activationID = (ActivationID)object;
            return this.uid.equals(activationID.uid) && this.activator.equals(activationID.activator);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        RemoteRef remoteRef;
        objectOutputStream.writeObject(this.uid);
        if (this.activator instanceof RemoteObject) {
            remoteRef = ((RemoteObject)((Object)this.activator)).getRef();
        } else if (Proxy.isProxyClass(this.activator.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.activator);
            if (!(invocationHandler instanceof RemoteObjectInvocationHandler)) {
                throw new InvalidObjectException("unexpected invocation handler");
            }
            remoteRef = ((RemoteObjectInvocationHandler)invocationHandler).getRef();
        } else {
            throw new InvalidObjectException("unexpected activator type");
        }
        objectOutputStream.writeUTF(remoteRef.getRefClass(objectOutputStream));
        remoteRef.writeExternal(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uid = (UID)objectInputStream.readObject();
        try {
            Class<?> clazz = Class.forName("sun.rmi.server." + objectInputStream.readUTF());
            RemoteRef remoteRef = (RemoteRef)clazz.newInstance();
            remoteRef.readExternal(objectInputStream);
            this.activator = (Activator)Proxy.newProxyInstance(null, new Class[]{Activator.class}, new RemoteObjectInvocationHandler(remoteRef));
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new InvalidObjectException("Unable to create remote reference").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new InvalidObjectException("Unable to create remote reference").initCause(illegalAccessException);
        }
    }
}

