/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetEncoder {
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacement;
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    private int state = 0;
    private static String[] stateNames = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};
    private WeakReference cachedDecoder = null;

    protected CharsetEncoder(Charset charset, float f2, float f3, byte[] byArray) {
        this.charset = charset;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageBytesPerChar");
        }
        if (f3 <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxBytesPerChar");
        }
        if (!Charset.atBugLevel("1.4") && f2 > f3) {
            throw new IllegalArgumentException("averageBytesPerChar exceeds maxBytesPerChar");
        }
        this.replacement = byArray;
        this.averageBytesPerChar = f2;
        this.maxBytesPerChar = f3;
        this.replaceWith(byArray);
    }

    protected CharsetEncoder(Charset charset, float f2, float f3) {
        this(charset, f2, f3, new byte[]{63});
    }

    public final Charset charset() {
        return this.charset;
    }

    public final byte[] replacement() {
        return this.replacement;
    }

    public final CharsetEncoder replaceWith(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        if ((float)n2 > this.maxBytesPerChar) {
            throw new IllegalArgumentException("Replacement too long");
        }
        if (!this.isLegalReplacement(byArray)) {
            throw new IllegalArgumentException("Illegal replacement");
        }
        this.replacement = byArray;
        this.implReplaceWith(byArray);
        return this;
    }

    protected void implReplaceWith(byte[] byArray) {
    }

    public boolean isLegalReplacement(byte[] byArray) {
        WeakReference weakReference = this.cachedDecoder;
        CharsetDecoder charsetDecoder = null;
        if (weakReference == null || (charsetDecoder = (CharsetDecoder)weakReference.get()) == null) {
            charsetDecoder = this.charset().newDecoder();
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.cachedDecoder = new WeakReference<CharsetDecoder>(charsetDecoder);
        } else {
            charsetDecoder.reset();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.allocate((int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte()));
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
        return !coderResult.isError();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CoderResult encode(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl2) {
        int n2;
        int n3 = n2 = bl2 ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl2 && this.state == 2)) {
            this.throwIllegalStateException(this.state, n2);
        }
        this.state = n2;
        while (true) {
            CoderResult coderResult;
            try {
                coderResult = this.encodeLoop(charBuffer, byteBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new CoderMalfunctionError(bufferUnderflowException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new CoderMalfunctionError(bufferOverflowException);
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl2 && charBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(charBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction = null;
            if (coderResult.isMalformed()) {
                codingErrorAction = this.malformedInputAction;
            } else if (coderResult.isUnmappable()) {
                codingErrorAction = this.unmappableCharacterAction;
            } else assert (false) : coderResult.toString();
            if (codingErrorAction == CodingErrorAction.REPORT) {
                return coderResult;
            }
            if (codingErrorAction == CodingErrorAction.REPLACE) {
                if (byteBuffer.remaining() < this.replacement.length) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put(this.replacement);
            }
            if (codingErrorAction == CodingErrorAction.IGNORE || codingErrorAction == CodingErrorAction.REPLACE) {
                charBuffer.position(charBuffer.position() + coderResult.length());
                continue;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    public final CoderResult flush(ByteBuffer byteBuffer) {
        if (this.state != 2) {
            this.throwIllegalStateException(this.state, 3);
        }
        this.state = 3;
        return this.implFlush(byteBuffer);
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetEncoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final ByteBuffer encode(CharBuffer charBuffer) throws CharacterCodingException {
        CoderResult coderResult;
        int n2 = (int)((float)charBuffer.remaining() * this.averageBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (n2 == 0) {
            return byteBuffer;
        }
        this.reset();
        while (!(coderResult = charBuffer.hasRemaining() ? this.encode(charBuffer, byteBuffer, true) : this.flush(byteBuffer)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2 *= 2);
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
                continue;
            }
            coderResult.throwException();
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canEncode(CharBuffer charBuffer) {
        if (this.state == 3) {
            this.reset();
        } else if (this.state != 0) {
            this.throwIllegalStateException(this.state, 1);
        }
        CodingErrorAction codingErrorAction = this.malformedInputAction();
        CodingErrorAction codingErrorAction2 = this.unmappableCharacterAction();
        try {
            this.onMalformedInput(CodingErrorAction.REPORT);
            this.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encode(charBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.onMalformedInput(codingErrorAction);
            this.onUnmappableCharacter(codingErrorAction2);
            this.reset();
        }
        return true;
    }

    public boolean canEncode(char c2) {
        CharBuffer charBuffer = CharBuffer.allocate(1);
        charBuffer.put(c2);
        charBuffer.flip();
        return this.canEncode(charBuffer);
    }

    public boolean canEncode(CharSequence charSequence) {
        CharBuffer charBuffer = charSequence instanceof CharBuffer ? ((CharBuffer)charSequence).duplicate() : CharBuffer.wrap(((Object)charSequence).toString());
        return this.canEncode(charBuffer);
    }

    private void throwIllegalStateException(int n2, int n3) {
        throw new IllegalStateException("Current state = " + stateNames[n2] + ", new state = " + stateNames[n3]);
    }
}

