/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

class ByteBufferAsDoubleBufferL
extends DoubleBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsDoubleBufferL(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 3, byteBuffer.remaining() >> 3);
        this.bb = byteBuffer;
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        assert (n3 <= n2);
        this.offset = n3;
    }

    ByteBufferAsDoubleBufferL(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.bb = byteBuffer;
        this.offset = n6;
    }

    public DoubleBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = (n2 << 3) + this.offset;
        assert (n5 >= 0);
        return new ByteBufferAsDoubleBufferL(this.bb, -1, 0, n4, n4, n5);
    }

    public DoubleBuffer duplicate() {
        return new ByteBufferAsDoubleBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new ByteBufferAsDoubleBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n2) {
        return (n2 << 3) + this.offset;
    }

    public double get() {
        return Bits.getDoubleL(this.bb, this.ix(this.nextGetIndex()));
    }

    public double get(int n2) {
        return Bits.getDoubleL(this.bb, this.ix(this.checkIndex(n2)));
    }

    public DoubleBuffer put(double d2) {
        Bits.putDoubleL(this.bb, this.ix(this.nextPutIndex()), d2);
        return this;
    }

    public DoubleBuffer put(int n2, double d2) {
        Bits.putDoubleL(this.bb, this.ix(this.checkIndex(n2)), d2);
        return this;
    }

    public DoubleBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n3));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n2 << 3);
        byteBuffer2.compact();
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

