/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocal<T> {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static int nextHashCode = 0;
    private static final int HASH_INCREMENT = 1640531527;

    private static synchronized int nextHashCode() {
        int n2 = nextHashCode;
        nextHashCode = n2 + 1640531527;
        return n2;
    }

    protected T initialValue() {
        return null;
    }

    public T get() {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            return (T)threadLocalMap.get(this);
        }
        T t2 = this.initialValue();
        this.createMap(thread, t2);
        return t2;
    }

    public void set(T t2) {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, t2);
        } else {
            this.createMap(thread, t2);
        }
    }

    public void remove() {
        ThreadLocalMap threadLocalMap = this.getMap(Thread.currentThread());
        if (threadLocalMap != null) {
            threadLocalMap.remove(this);
        }
    }

    ThreadLocalMap getMap(Thread thread) {
        return thread.threadLocals;
    }

    void createMap(Thread thread, T t2) {
        thread.threadLocals = new ThreadLocalMap(this, t2);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap threadLocalMap) {
        return new ThreadLocalMap(threadLocalMap);
    }

    T childValue(T t2) {
        throw new UnsupportedOperationException();
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int n2) {
            this.threshold = n2 * 2 / 3;
        }

        private static int nextIndex(int n2, int n3) {
            return n2 + 1 < n3 ? n2 + 1 : 0;
        }

        private static int prevIndex(int n2, int n3) {
            return n2 - 1 >= 0 ? n2 - 1 : n3 - 1;
        }

        ThreadLocalMap(ThreadLocal threadLocal, Object object) {
            this.table = new Entry[16];
            int n2 = threadLocal.threadLocalHashCode & 0xF;
            this.table[n2] = new Entry(threadLocal, object);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap threadLocalMap) {
            Entry[] entryArray = threadLocalMap.table;
            int n2 = entryArray.length;
            this.setThreshold(n2);
            this.table = new Entry[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ThreadLocal threadLocal;
                Entry entry = entryArray[i2];
                if (entry == null || (threadLocal = (ThreadLocal)entry.get()) == null) continue;
                ThreadLocal threadLocal2 = threadLocal;
                Object object = threadLocal2.childValue(entry.value);
                Entry entry2 = new Entry(threadLocal2, object);
                int n3 = threadLocal2.threadLocalHashCode & n2 - 1;
                while (this.table[n3] != null) {
                    n3 = ThreadLocalMap.nextIndex(n3, n2);
                }
                this.table[n3] = entry2;
                ++this.size;
            }
        }

        private Object get(ThreadLocal threadLocal) {
            int n2 = threadLocal.threadLocalHashCode & this.table.length - 1;
            Entry entry = this.table[n2];
            if (entry != null && entry.get() == threadLocal) {
                return entry.value;
            }
            return this.getAfterMiss(threadLocal, n2, entry);
        }

        private Object getAfterMiss(ThreadLocal threadLocal, int n2, Entry entry) {
            int n3;
            Object object;
            Entry[] entryArray = this.table;
            int n4 = entryArray.length;
            while (entry != null) {
                object = (ThreadLocal)entry.get();
                if (object == threadLocal) {
                    return entry.value;
                }
                if (object == null) {
                    return this.replaceStaleEntry(threadLocal, null, n2, true);
                }
                n2 = ThreadLocalMap.nextIndex(n2, n4);
                entry = entryArray[n2];
            }
            object = threadLocal.initialValue();
            entryArray[n2] = new Entry(threadLocal, object);
            if (!this.cleanSomeSlots(n2, n3 = ++this.size) && n3 >= this.threshold) {
                this.rehash();
            }
            return object;
        }

        private void set(ThreadLocal threadLocal, Object object) {
            int n2;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            int n4 = threadLocal.threadLocalHashCode & n3 - 1;
            Entry entry = entryArray[n4];
            while (entry != null) {
                ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
                if (threadLocal2 == threadLocal) {
                    entry.value = object;
                    return;
                }
                if (threadLocal2 == null) {
                    this.replaceStaleEntry(threadLocal, object, n4, false);
                    return;
                }
                n4 = ThreadLocalMap.nextIndex(n4, n3);
                entry = entryArray[n4];
            }
            entryArray[n4] = new Entry(threadLocal, object);
            if (!this.cleanSomeSlots(n4, n2 = ++this.size) && n2 >= this.threshold) {
                this.rehash();
            }
        }

        private void remove(ThreadLocal threadLocal) {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = threadLocal.threadLocalHashCode & n2 - 1;
            Entry entry = entryArray[n3];
            while (entry != null) {
                if (entry.get() == threadLocal) {
                    entry.clear();
                    this.expungeStaleEntry(n3);
                    return;
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
                entry = entryArray[n3];
            }
        }

        private Object replaceStaleEntry(ThreadLocal threadLocal, Object object, int n2, boolean bl2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            int n4 = n2;
            int n5 = ThreadLocalMap.prevIndex(n2, n3);
            while ((entry = entryArray[n5]) != null) {
                if (entry.get() == null) {
                    n4 = n5;
                }
                n5 = ThreadLocalMap.prevIndex(n5, n3);
            }
            n5 = ThreadLocalMap.nextIndex(n2, n3);
            while ((entry = entryArray[n5]) != null) {
                ThreadLocal threadLocal2 = (ThreadLocal)entry.get();
                if (threadLocal2 == threadLocal) {
                    if (bl2) {
                        object = entry.value;
                    } else {
                        entry.value = object;
                    }
                    entryArray[n5] = entryArray[n2];
                    entryArray[n2] = entry;
                    if (n4 == n2) {
                        n4 = n5;
                    }
                    this.cleanSomeSlots(this.expungeStaleEntry(n4), n3);
                    return object;
                }
                if (threadLocal2 == null && n4 == n2) {
                    n4 = n5;
                }
                n5 = ThreadLocalMap.nextIndex(n5, n3);
            }
            if (bl2) {
                object = threadLocal.initialValue();
            }
            entryArray[n2].value = null;
            entryArray[n2] = new Entry(threadLocal, object);
            if (n4 != n2) {
                this.cleanSomeSlots(this.expungeStaleEntry(n4), n3);
            }
            return object;
        }

        private int expungeStaleEntry(int n2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            entryArray[n2].value = null;
            entryArray[n2] = null;
            --this.size;
            int n4 = ThreadLocalMap.nextIndex(n2, n3);
            while ((entry = entryArray[n4]) != null) {
                ThreadLocal threadLocal = (ThreadLocal)entry.get();
                if (threadLocal == null) {
                    entry.value = null;
                    entryArray[n4] = null;
                    --this.size;
                } else {
                    ThreadLocal threadLocal2 = threadLocal;
                    int n5 = threadLocal2.threadLocalHashCode & n3 - 1;
                    if (n5 != n4) {
                        entryArray[n4] = null;
                        while (entryArray[n5] != null) {
                            n5 = ThreadLocalMap.nextIndex(n5, n3);
                        }
                        entryArray[n5] = entry;
                    }
                }
                n4 = ThreadLocalMap.nextIndex(n4, n3);
            }
            return n4;
        }

        private boolean cleanSomeSlots(int n2, int n3) {
            boolean bl2 = false;
            Entry[] entryArray = this.table;
            int n4 = entryArray.length;
            do {
                Entry entry;
                if ((entry = entryArray[n2 = ThreadLocalMap.nextIndex(n2, n4)]) == null || entry.get() != null) continue;
                n3 = n4;
                bl2 = true;
                n2 = this.expungeStaleEntry(n2);
            } while ((n3 >>>= 1) != 0);
            return bl2;
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = n2 * 2;
            Entry[] entryArray2 = new Entry[n3];
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Entry entry = entryArray[i2];
                entryArray[i2] = null;
                if (entry == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)entry.get();
                if (threadLocal == null) {
                    entry.value = null;
                    continue;
                }
                ThreadLocal threadLocal2 = threadLocal;
                int n5 = threadLocal2.threadLocalHashCode & n3 - 1;
                while (entryArray2[n5] != null) {
                    n5 = ThreadLocalMap.nextIndex(n5, n3);
                }
                entryArray2[n5] = entry;
                ++n4;
            }
            this.setThreshold(n3);
            this.size = n4;
            this.table = entryArray2;
        }

        private void expungeStaleEntries() {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Entry entry = entryArray[i2];
                if (entry == null || entry.get() != null) continue;
                this.expungeStaleEntry(i2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Entry
        extends WeakReference<ThreadLocal> {
            private Object value;

            private Entry(ThreadLocal threadLocal, Object object) {
                super(threadLocal);
                this.value = object;
            }
        }
    }
}

