/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ExpiringCache {
    private long millisUntilExpiration;
    private Map map;
    private int queryCount;
    private int queryOverflow = 300;
    private int MAX_ENTRIES = 200;

    ExpiringCache() {
        this(30000L);
    }

    ExpiringCache(long l2) {
        this.millisUntilExpiration = l2;
        this.map = new LinkedHashMap(){

            protected boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > ExpiringCache.this.MAX_ENTRIES;
            }
        };
    }

    synchronized String get(String string) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            return entry.val();
        }
        return null;
    }

    synchronized void put(String string, String string2) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            entry.setTimestamp(System.currentTimeMillis());
            entry.setVal(string2);
        } else {
            this.map.put(string, new Entry(System.currentTimeMillis(), string2));
        }
    }

    synchronized void clear() {
        this.map.clear();
    }

    private Entry entryFor(String string) {
        long l2;
        Entry entry = (Entry)this.map.get(string);
        if (entry != null && ((l2 = System.currentTimeMillis() - entry.timestamp()) < 0L || l2 >= this.millisUntilExpiration)) {
            this.map.remove(string);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        Set set = this.map.keySet();
        String[] stringArray = new String[set.size()];
        int n2 = 0;
        for (String string : set) {
            stringArray[n2++] = string;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.entryFor(stringArray[i2]);
        }
        this.queryCount = 0;
    }

    static class Entry {
        private long timestamp;
        private String val;

        Entry(long l2, String string) {
            this.timestamp = l2;
            this.val = string;
        }

        long timestamp() {
            return this.timestamp;
        }

        void setTimestamp(long l2) {
            this.timestamp = l2;
        }

        String val() {
            return this.val;
        }

        void setVal(String string) {
            this.val = string;
        }
    }
}

