/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n2, int n3, int n4, int[] nArray) {
        this(n2, n3, n4, n3, nArray);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
    }

    public SinglePixelPackedSampleModel(int n2, int n3, int n4, int n5, int[] nArray) {
        super(n2, n3, n4, nArray.length);
        if (n2 != 0 && n2 != 1 && n2 != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n2);
        }
        this.dataType = n2;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n5;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            int n6 = 0;
            int n7 = 0;
            int n8 = nArray[i2];
            if (n8 != 0) {
                while ((n8 & 1) == 0) {
                    n8 >>>= 1;
                    ++n6;
                }
                while ((n8 & 1) == 1) {
                    n8 >>>= 1;
                    ++n7;
                }
                if (n8 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[i2] + " must be contiguous");
                }
            }
            this.bitOffsets[i2] = n6;
            this.bitSizes[i2] = n7;
            if (n7 <= this.maxBitSize) continue;
            this.maxBitSize = n7;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    private long getBufferSize() {
        long l2 = this.scanlineStride * (this.height - 1) + this.width;
        return l2;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(this.dataType, n2, n3, this.bitMasks);
        return singlePixelPackedSampleModel;
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2);
            }
        }
        return dataBuffer;
    }

    public int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray[i2] = 0;
            int n2 = this.bitMasks[i2] >>> this.bitOffsets[i2];
            while ((n2 & 1) != 0) {
                int n3 = i2;
                nArray[n3] = nArray[n3] + 1;
                n2 >>>= 1;
            }
        }
        return nArray;
    }

    public int getSampleSize(int n2) {
        int n3 = 0;
        int n4 = this.bitMasks[n2] >>> this.bitOffsets[n2];
        while ((n4 & 1) != 0) {
            ++n3;
            n4 >>>= 1;
        }
        return n3;
    }

    public int getOffset(int n2, int n3) {
        int n4 = n3 * this.scanlineStride + n2;
        return n4;
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.numBands) {
            throw new RasterFormatException("There are only " + this.numBands + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = this.bitMasks[nArray[i2]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2);
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = byArray;
                break;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[1] : (int[])object;
                nArray[0] = dataBuffer.getElem(n3 * this.scanlineStride + n2);
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray == null ? new int[this.numBands] : nArray;
        int n4 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray2[i2] = (n4 & this.bitMasks[i2]) >>> this.bitOffsets[i2];
        }
        return nArray2;
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = n3 * this.scanlineStride + n2;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n8 = dataBuffer.getElem(n6 + i3);
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    nArray2[n7++] = (n8 & this.bitMasks[i4]) >>> this.bitOffsets[i4];
                }
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        return (n5 & this.bitMasks[n4]) >>> this.bitOffsets[n4];
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2;
        int n8 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n9 = dataBuffer.getElem(n7 + i3);
                nArray2[n8++] = (n9 & this.bitMasks[n6]) >>> this.bitOffsets[n6];
            }
            n7 += this.scanlineStride;
        }
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, byArray[0] & 0xFF);
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, sArray[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                dataBuffer.setElem(n3 * this.scanlineStride + n2, nArray[0]);
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2;
        int n5 = dataBuffer.getElem(n4);
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            n5 &= ~this.bitMasks[i2];
            n5 |= nArray[i2] << this.bitOffsets[i2] & this.bitMasks[i2];
        }
        dataBuffer.setElem(n4, n5);
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n3 * this.scanlineStride + n2;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n8 = dataBuffer.getElem(n6 + i3);
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    n8 &= ~this.bitMasks[i4];
                    int n9 = nArray[n7++];
                    n8 |= n9 << this.bitOffsets[i4] & this.bitMasks[i4];
                }
                dataBuffer.setElem(n6 + i3, n8);
            }
            n6 += this.scanlineStride;
        }
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = dataBuffer.getElem(n3 * this.scanlineStride + n2);
        n6 &= ~this.bitMasks[n4];
        dataBuffer.setElem(n3 * this.scanlineStride + n2, n6 |= n5 << this.bitOffsets[n4] & this.bitMasks[n4]);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2;
        int n8 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n9 = dataBuffer.getElem(n7 + i3);
                n9 &= ~this.bitMasks[n6];
                int n10 = nArray[n8++];
                dataBuffer.setElem(n7 + i3, n9 |= n10 << this.bitOffsets[n6] & this.bitMasks[n6]);
            }
            n7 += this.scanlineStride;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)object;
        return this.width == singlePixelPackedSampleModel.width && this.height == singlePixelPackedSampleModel.height && this.numBands == singlePixelPackedSampleModel.numBands && this.dataType == singlePixelPackedSampleModel.dataType && Arrays.equals(this.bitMasks, singlePixelPackedSampleModel.bitMasks) && Arrays.equals(this.bitOffsets, singlePixelPackedSampleModel.bitOffsets) && Arrays.equals(this.bitSizes, singlePixelPackedSampleModel.bitSizes) && this.maxBitSize == singlePixelPackedSampleModel.maxBitSize && this.scanlineStride == singlePixelPackedSampleModel.scanlineStride;
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        n3 = this.width;
        n3 <<= 8;
        n3 ^= this.height;
        n3 <<= 8;
        n3 ^= this.numBands;
        n3 <<= 8;
        n3 ^= this.dataType;
        n3 <<= 8;
        for (n2 = 0; n2 < this.bitMasks.length; ++n2) {
            n3 ^= this.bitMasks[n2];
            n3 <<= 8;
        }
        for (n2 = 0; n2 < this.bitOffsets.length; ++n2) {
            n3 ^= this.bitOffsets[n2];
            n3 <<= 8;
        }
        for (n2 = 0; n2 < this.bitSizes.length; ++n2) {
            n3 ^= this.bitSizes[n2];
            n3 <<= 8;
        }
        n3 ^= this.maxBitSize;
        n3 <<= 8;
        return n3 ^= this.scanlineStride;
    }

    static {
        ColorModel.loadLibraries();
        SinglePixelPackedSampleModel.initIDs();
    }
}

