/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static double distanceSq(double d2, double d3, double d4, double d5) {
        return (d2 -= d4) * d2 + (d3 -= d5) * d3;
    }

    public static double distance(double d2, double d3, double d4, double d5) {
        return Math.sqrt((d2 -= d4) * d2 + (d3 -= d5) * d3);
    }

    public double distanceSq(double d2, double d3) {
        return (d2 -= this.getX()) * d2 + (d3 -= this.getY()) * d3;
    }

    public double distanceSq(Point2D point2D) {
        double d2 = point2D.getX() - this.getX();
        double d3 = point2D.getY() - this.getY();
        return d2 * d2 + d3 * d3;
    }

    public double distance(double d2, double d3) {
        return Math.sqrt((d2 -= this.getX()) * d2 + (d3 -= this.getY()) * d3);
    }

    public double distance(Point2D point2D) {
        double d2 = point2D.getX() - this.getX();
        double d3 = point2D.getY() - this.getY();
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        long l2 = java.lang.Double.doubleToLongBits(this.getX());
        return (int)(l2 ^= java.lang.Double.doubleToLongBits(this.getY()) * 31L) ^ (int)(l2 >> 32);
    }

    public boolean equals(Object object) {
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return this.getX() == point2D.getX() && this.getY() == point2D.getY();
        }
        return super.equals(object);
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double d2, double d3) {
            this.x = d2;
            this.y = d3;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d2, double d3) {
            this.x = d2;
            this.y = d3;
        }

        public String toString() {
            return "Point2D.Double[" + this.x + ", " + this.y + "]";
        }
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float f2, float f3) {
            this.x = f2;
            this.y = f3;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d2, double d3) {
            this.x = (float)d2;
            this.y = (float)d3;
        }

        public void setLocation(float f2, float f3) {
            this.x = f2;
            this.y = f3;
        }

        public String toString() {
            return "Point2D.Float[" + this.x + ", " + this.y + "]";
        }
    }
}

