/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.LineIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D point2D, Point2D point2D2) {
        this.setLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setLine(Line2D line2D) {
        this.setLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static int relativeCCW(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d6 -= d2) * (d5 -= d3) - (d7 -= d3) * (d4 -= d2);
        if (d8 == 0.0 && (d8 = d6 * d4 + d7 * d5) > 0.0 && (d8 = (d6 -= d4) * d4 + (d7 -= d5) * d5) < 0.0) {
            d8 = 0.0;
        }
        return d8 < 0.0 ? -1 : (d8 > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double d2, double d3) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d2, d3);
    }

    public int relativeCCW(Point2D point2D) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public static boolean linesIntersect(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return Line2D.relativeCCW(d2, d3, d4, d5, d6, d7) * Line2D.relativeCCW(d2, d3, d4, d5, d8, d9) <= 0 && Line2D.relativeCCW(d6, d7, d8, d9, d2, d3) * Line2D.relativeCCW(d6, d7, d8, d9, d4, d5) <= 0;
    }

    public boolean intersectsLine(double d2, double d3, double d4, double d5) {
        return Line2D.linesIntersect(d2, d3, d4, d5, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersectsLine(Line2D line2D) {
        return Line2D.linesIntersect(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static double ptSegDistSq(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d6 -= d2) * (d4 -= d2) + (d7 -= d3) * (d5 -= d3);
        if ((d9 = d6 * d6 + d7 * d7 - (d8 = d10 <= 0.0 ? 0.0 : ((d10 = (d6 = d4 - d6) * d4 + (d7 = d5 - d7) * d5) <= 0.0 ? 0.0 : d10 * d10 / (d4 * d4 + d5 * d5)))) < 0.0) {
            d9 = 0.0;
        }
        return d9;
    }

    public static double ptSegDist(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Math.sqrt(Line2D.ptSegDistSq(d2, d3, d4, d5, d6, d7));
    }

    public double ptSegDistSq(double d2, double d3) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d2, d3);
    }

    public double ptSegDistSq(Point2D point2D) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptSegDist(double d2, double d3) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d2, d3);
    }

    public double ptSegDist(Point2D point2D) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public static double ptLineDistSq(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        if ((d10 = (d6 -= d2) * d6 + (d7 -= d3) * d7 - (d9 = (d8 = d6 * (d4 -= d2) + d7 * (d5 -= d3)) * d8 / (d4 * d4 + d5 * d5))) < 0.0) {
            d10 = 0.0;
        }
        return d10;
    }

    public static double ptLineDist(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Math.sqrt(Line2D.ptLineDistSq(d2, d3, d4, d5, d6, d7));
    }

    public double ptLineDistSq(double d2, double d3) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d2, d3);
    }

    public double ptLineDistSq(Point2D point2D) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptLineDist(double d2, double d3) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d2, d3);
    }

    public double ptLineDist(Point2D point2D) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public boolean contains(double d2, double d3) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.intersects(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return rectangle2D.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new LineIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new LineIterator(this, affineTransform);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Line2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double d2, double d3, double d4, double d5) {
            this.setLine(d2, d3, d4, d5);
        }

        public Double(Point2D point2D, Point2D point2D2) {
            this.setLine(point2D, point2D2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setLine(double d2, double d3, double d4, double d5) {
            this.x1 = d2;
            this.y1 = d3;
            this.x2 = d4;
            this.y2 = d5;
        }

        public Rectangle2D getBounds2D() {
            double d2;
            double d3;
            double d4;
            double d5;
            if (this.x1 < this.x2) {
                d5 = this.x1;
                d4 = this.x2 - this.x1;
            } else {
                d5 = this.x2;
                d4 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                d3 = this.y1;
                d2 = this.y2 - this.y1;
            } else {
                d3 = this.y2;
                d2 = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(d5, d3, d4, d2);
        }
    }

    public static class Float
    extends Line2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float f2, float f3, float f4, float f5) {
            this.setLine(f2, f3, f4, f5);
        }

        public Float(Point2D point2D, Point2D point2D2) {
            this.setLine(point2D, point2D2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setLine(double d2, double d3, double d4, double d5) {
            this.x1 = (float)d2;
            this.y1 = (float)d3;
            this.x2 = (float)d4;
            this.y2 = (float)d5;
        }

        public void setLine(float f2, float f3, float f4, float f5) {
            this.x1 = f2;
            this.y1 = f3;
            this.x2 = f4;
            this.y2 = f5;
        }

        public Rectangle2D getBounds2D() {
            float f2;
            float f3;
            float f4;
            float f5;
            if (this.x1 < this.x2) {
                f5 = this.x1;
                f4 = this.x2 - this.x1;
            } else {
                f5 = this.x2;
                f4 = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                f3 = this.y1;
                f2 = this.y2 - this.y1;
            } else {
                f3 = this.y2;
                f2 = this.y1 - this.y2;
            }
            return new Rectangle2D.Float(f5, f3, f4, f2);
        }
    }
}

