/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import sun.security.util.SecurityConstants;

public class MouseInfo {
    private MouseInfo() {
    }

    public static PointerInfo getPointerInfo() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.WATCH_MOUSE_PERMISSION);
        }
        Point point = new Point(0, 0);
        int n2 = Toolkit.getDefaultToolkit().getMouseInfoPeer().fillPointWithCoords(point);
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        PointerInfo pointerInfo = null;
        if (MouseInfo.areScreenDevicesIndependent(graphicsDeviceArray)) {
            pointerInfo = new PointerInfo(graphicsDeviceArray[n2], point);
        } else {
            for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
                GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[i2].getDefaultConfiguration();
                Rectangle rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                pointerInfo = new PointerInfo(graphicsDeviceArray[i2], point);
            }
        }
        return pointerInfo;
    }

    private static boolean areScreenDevicesIndependent(GraphicsDevice[] graphicsDeviceArray) {
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            Rectangle rectangle = graphicsDeviceArray[i2].getDefaultConfiguration().getBounds();
            if (rectangle.x == 0 && rectangle.y == 0) continue;
            return false;
        }
        return true;
    }

    public static int getNumberOfButtons() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.mouse.numButtons");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        assert (false) : "awt.mouse.numButtons is not an integer property";
        return 0;
    }
}

