/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.peer.FramePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class Frame
extends Window
implements MenuContainer {
    @Deprecated
    public static final int DEFAULT_CURSOR = 0;
    @Deprecated
    public static final int CROSSHAIR_CURSOR = 1;
    @Deprecated
    public static final int TEXT_CURSOR = 2;
    @Deprecated
    public static final int WAIT_CURSOR = 3;
    @Deprecated
    public static final int SW_RESIZE_CURSOR = 4;
    @Deprecated
    public static final int SE_RESIZE_CURSOR = 5;
    @Deprecated
    public static final int NW_RESIZE_CURSOR = 6;
    @Deprecated
    public static final int NE_RESIZE_CURSOR = 7;
    @Deprecated
    public static final int N_RESIZE_CURSOR = 8;
    @Deprecated
    public static final int S_RESIZE_CURSOR = 9;
    @Deprecated
    public static final int W_RESIZE_CURSOR = 10;
    @Deprecated
    public static final int E_RESIZE_CURSOR = 11;
    @Deprecated
    public static final int HAND_CURSOR = 12;
    @Deprecated
    public static final int MOVE_CURSOR = 13;
    public static final int NORMAL = 0;
    public static final int ICONIFIED = 1;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int MAXIMIZED_BOTH = 6;
    Rectangle maximizedBounds;
    String title = "Untitled";
    transient Image icon;
    MenuBar menuBar;
    boolean resizable = true;
    boolean undecorated = false;
    boolean mbManagement = false;
    private int state = 0;
    Vector ownedWindows;
    private transient WeakReference weakThis;
    private static final String base = "frame";
    private static int nameCounter = 0;
    private static final long serialVersionUID = 2673458971256075116L;
    private int frameSerializedDataVersion = 1;

    public Frame() throws HeadlessException {
        this("");
    }

    public Frame(GraphicsConfiguration graphicsConfiguration) {
        this("", graphicsConfiguration);
    }

    public Frame(String string) throws HeadlessException {
        this.init(string, null);
    }

    public Frame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.init(string, graphicsConfiguration);
    }

    private void init(String string, GraphicsConfiguration graphicsConfiguration) {
        this.title = string;
        this.weakThis = new WeakReference<Frame>(this);
        this.addToFrameList();
        SunToolkit.checkAndSetPolicy(this, false);
    }

    protected void finalize() throws Throwable {
        this.removeFromFrameList();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class<? extends Object> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createFrame(this);
            }
            FramePeer framePeer = (FramePeer)this.peer;
            MenuBar menuBar = this.menuBar;
            if (menuBar != null) {
                this.mbManagement = true;
                menuBar.addNotify();
                framePeer.setMenuBar(menuBar);
            }
            framePeer.setMaximizedBounds(this.maximizedBounds);
            super.addNotify();
        }
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String string) {
        String string2 = this.title;
        if (string == null) {
            string = "";
        }
        Frame frame = this;
        synchronized (frame) {
            this.title = string;
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                framePeer.setTitle(string);
            }
        }
        this.firePropertyChange("title", string2, string);
    }

    public Image getIconImage() {
        return this.icon;
    }

    public synchronized void setIconImage(Image image) {
        this.icon = image;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setIconImage(image);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMenuBar(MenuBar menuBar) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.menuBar == menuBar) {
                return;
            }
            if (menuBar != null && menuBar.parent != null) {
                menuBar.parent.remove(menuBar);
            }
            if (this.menuBar != null) {
                this.remove(this.menuBar);
            }
            this.menuBar = menuBar;
            if (this.menuBar != null) {
                this.menuBar.parent = this;
                FramePeer framePeer = (FramePeer)this.peer;
                if (framePeer != null) {
                    this.mbManagement = true;
                    this.menuBar.addNotify();
                    if (this.valid) {
                        this.invalidate();
                    }
                    framePeer.setMenuBar(this.menuBar);
                }
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizable(boolean bl2) {
        boolean bl3 = this.resizable;
        boolean bl4 = false;
        Frame frame = this;
        synchronized (frame) {
            this.resizable = bl2;
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                framePeer.setResizable(bl2);
                bl4 = true;
            }
        }
        if (bl4 && this.valid) {
            this.invalidate();
        }
        this.firePropertyChange("resizable", bl3, bl2);
    }

    public synchronized void setState(int n2) {
        int n3 = this.getExtendedState();
        if (n2 == 1 && (n3 & 1) == 0) {
            this.setExtendedState(n3 | 1);
        } else if (n2 == 0 && (n3 & 1) != 0) {
            this.setExtendedState(n3 & 0xFFFFFFFE);
        }
    }

    public synchronized void setExtendedState(int n2) {
        if (!this.isFrameStateSupported(n2)) {
            return;
        }
        this.state = n2;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setState(n2);
        }
    }

    private boolean isFrameStateSupported(int n2) {
        if (!this.getToolkit().isFrameStateSupported(n2)) {
            if ((n2 & 1) != 0 && !this.getToolkit().isFrameStateSupported(1)) {
                return false;
            }
            return this.getToolkit().isFrameStateSupported(n2 &= 0xFFFFFFFE);
        }
        return true;
    }

    public synchronized int getState() {
        return (this.getExtendedState() & 1) != 0 ? 1 : 0;
    }

    public synchronized int getExtendedState() {
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            this.state = framePeer.getState();
        }
        return this.state;
    }

    public synchronized void setMaximizedBounds(Rectangle rectangle) {
        this.maximizedBounds = rectangle;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setMaximizedBounds(rectangle);
        }
    }

    public Rectangle getMaximizedBounds() {
        return this.maximizedBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUndecorated(boolean bl2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisplayable()) {
                throw new IllegalComponentStateException("The frame is displayable.");
            }
            this.undecorated = bl2;
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuComponent == this.menuBar) {
                this.menuBar = null;
                FramePeer framePeer = (FramePeer)this.peer;
                if (framePeer != null) {
                    this.mbManagement = true;
                    if (this.valid) {
                        this.invalidate();
                    }
                    framePeer.setMenuBar(null);
                    menuComponent.removeNotify();
                }
                menuComponent.parent = null;
            } else {
                super.remove(menuComponent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                this.getState();
                if (this.menuBar != null) {
                    this.mbManagement = true;
                    framePeer.setMenuBar(null);
                    this.menuBar.removeNotify();
                }
            }
            super.removeNotify();
        }
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        if (this.menuBar != null && this.menuBar.handleShortcut(keyEvent)) {
            keyEvent.consume();
            return;
        }
        super.postProcessKeyEvent(keyEvent);
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.title != null) {
            string = string + ",title=" + this.title;
        }
        if (this.resizable) {
            string = string + ",resizable";
        }
        this.getExtendedState();
        if (this.state == 0) {
            string = string + ",normal";
        } else {
            if ((this.state & 1) != 0) {
                string = string + ",iconified";
            }
            if ((this.state & 6) == 6) {
                string = string + ",maximized";
            } else if ((this.state & 2) != 0) {
                string = string + ",maximized_horiz";
            } else if ((this.state & 4) != 0) {
                string = string + ",maximized_vert";
            }
        }
        return string;
    }

    @Deprecated
    public void setCursor(int n2) {
        if (n2 < 0 || n2 > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.setCursor(Cursor.getPredefinedCursor(n2));
    }

    @Deprecated
    public int getCursorType() {
        return this.getCursor().getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame[] getFrames() {
        Class<Frame> clazz = Frame.class;
        synchronized (Frame.class) {
            Frame[] frameArray;
            Vector vector = (Vector)AppContext.getAppContext().get(Frame.class);
            if (vector != null) {
                int n2 = vector.size();
                int n3 = 0;
                Frame[] frameArray2 = new Frame[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    frameArray2[n3] = (Frame)((WeakReference)vector.elementAt(i2)).get();
                    if (frameArray2[n3] == null) continue;
                    ++n3;
                }
                if (n2 != n3) {
                    frameArray = new Frame[n3];
                    System.arraycopy(frameArray2, 0, frameArray, 0, n3);
                } else {
                    frameArray = frameArray2;
                }
            } else {
                frameArray = new Frame[]{};
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return frameArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToFrameList() {
        Class<Frame> clazz = Frame.class;
        synchronized (Frame.class) {
            Vector<WeakReference> vector = (Vector<WeakReference>)this.appContext.get(Frame.class);
            if (vector == null) {
                vector = new Vector<WeakReference>();
                this.appContext.put(Frame.class, vector);
            }
            vector.addElement(this.weakThis);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromFrameList() {
        Class<Frame> clazz = Frame.class;
        synchronized (Frame.class) {
            Vector vector = (Vector)this.appContext.get(Frame.class);
            if (vector != null) {
                vector.removeElement(this.weakThis);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.icon instanceof Serializable) {
            objectOutputStream.writeObject(this.icon);
        } else {
            objectOutputStream.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        block5: {
            objectInputStream.defaultReadObject();
            try {
                this.icon = (Image)objectInputStream.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block5;
                throw optionalDataException;
            }
        }
        if (this.menuBar != null) {
            this.menuBar.parent = this;
        }
        if (this.ownedWindows != null) {
            for (int i2 = 0; i2 < this.ownedWindows.size(); ++i2) {
                this.connectOwnedWindow((Window)this.ownedWindows.elementAt(i2));
            }
            this.ownedWindows = null;
        }
        this.weakThis = new WeakReference<Frame>(this);
        this.addToFrameList();
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTFrame();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Frame.initIDs();
        }
    }

    protected class AccessibleAWTFrame
    extends Window.AccessibleAWTWindow {
        private static final long serialVersionUID = -6172960752956030250L;

        protected AccessibleAWTFrame() {
            super(Frame.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Frame.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (Frame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }
    }
}

