/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.CramMD5Client;
import com.sun.security.sasl.ExternalClient;
import com.sun.security.sasl.PlainClient;
import com.sun.security.sasl.util.PolicyUtils;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientFactoryImpl
implements SaslClientFactory {
    private static final String[] myMechs = new String[]{"EXTERNAL", "CRAM-MD5", "PLAIN"};
    private static final int[] mechPolicies = new int[]{7, 17, 16};
    private static final int EXTERNAL = 0;
    private static final int CRAMMD5 = 1;
    private static final int PLAIN = 2;

    @Override
    public SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals(myMechs[0]) && PolicyUtils.checkPolicy(mechPolicies[0], map)) {
                return new ExternalClient(string);
            }
            if (stringArray[i2].equals(myMechs[1]) && PolicyUtils.checkPolicy(mechPolicies[1], map)) {
                Object[] objectArray = this.getUserInfo("CRAM-MD5", string, callbackHandler);
                return new CramMD5Client((String)objectArray[0], (byte[])objectArray[1]);
            }
            if (!stringArray[i2].equals(myMechs[2]) || !PolicyUtils.checkPolicy(mechPolicies[2], map)) continue;
            Object[] objectArray = this.getUserInfo("PLAIN", string, callbackHandler);
            return new PlainClient(string, (String)objectArray[0], (byte[])objectArray[1]);
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> map) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, map);
    }

    private Object[] getUserInfo(String string, String string2, CallbackHandler callbackHandler) throws SaslException {
        if (callbackHandler == null) {
            throw new SaslException("Callback handler to get username/password required");
        }
        try {
            byte[] byArray;
            String string3 = string + " authentication id: ";
            String string4 = string + " password: ";
            NameCallback nameCallback = string2 == null ? new NameCallback(string3) : new NameCallback(string3, string2);
            PasswordCallback passwordCallback = new PasswordCallback(string4, false);
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
            char[] cArray = passwordCallback.getPassword();
            if (cArray != null) {
                byArray = new String(cArray).getBytes("UTF8");
                passwordCallback.clearPassword();
            } else {
                byArray = null;
            }
            String string5 = nameCallback.getName();
            return new Object[]{string5, byArray};
        }
        catch (IOException iOException) {
            throw new SaslException("Cannot get password", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Cannot get userid/password", unsupportedCallbackException);
        }
    }
}

