/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.patterns;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.patterns.NodeTest;
import com.sun.org.apache.xpath.internal.patterns.StepPattern;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vector, int n2) {
        for (int i2 = 0; i2 < this.m_patterns.length; ++i2) {
            this.m_patterns[i2].fixupVariables(vector, n2);
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.m_patterns[i2].canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
        if (null != stepPatternArray) {
            for (int i2 = 0; i2 < stepPatternArray.length; ++i2) {
                stepPatternArray[i2].exprSetParent(this);
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n2 = this.m_patterns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            XObject xObject2 = this.m_patterns[i2].execute(xPathContext);
            if (xObject2 == NodeTest.SCORE_NONE) continue;
            if (null == xObject) {
                xObject = xObject2;
                continue;
            }
            if (!(xObject2.num() > xObject.num())) continue;
            xObject = xObject2;
        }
        if (null == xObject) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitUnionPattern(expressionOwner, this);
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.m_patterns[i2].callVisitors(new UnionPathPartOwner(i2), xPathVisitor);
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        UnionPattern unionPattern = (UnionPattern)expression;
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            if (null == unionPattern.m_patterns || unionPattern.m_patterns.length != n2) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.m_patterns[i2].deepEquals(unionPattern.m_patterns[i2])) continue;
                return false;
            }
        } else if (unionPattern.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int n2) {
            this.m_index = n2;
        }

        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(UnionPattern.this);
            ((UnionPattern)UnionPattern.this).m_patterns[this.m_index] = (StepPattern)expression;
        }
    }
}

