/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.jaxp.JAXPValidatorComponent;
import com.sun.org.apache.xerces.internal.jaxp.validation.InsulatedValidatorComponent;
import com.sun.org.apache.xerces.internal.jaxp.validation.XercesSchema;
import com.sun.org.apache.xerces.internal.parsers.XIncludeParserConfiguration;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;

public class JAXPConfiguration
extends XIncludeParserConfiguration {
    private final Schema fSchema;

    public JAXPConfiguration(Schema schema) {
        this.fSchema = schema;
    }

    protected void configurePipeline() {
        super.configurePipeline();
        if (this.fSchema != null) {
            if (JAXPConfiguration.isXNICapabaleSchema(this.fSchema)) {
                InsulatedValidatorComponent insulatedValidatorComponent = ((XercesSchema)this.fSchema).newXNIValidator();
                this.addComponent(insulatedValidatorComponent);
                this.fLastComponent.setDocumentHandler(insulatedValidatorComponent.getValidator());
                insulatedValidatorComponent.getValidator().setDocumentSource(this.fLastComponent);
                this.fLastComponent = insulatedValidatorComponent.getValidator();
                insulatedValidatorComponent.getValidator().setDocumentHandler(this.fDocumentHandler);
            } else {
                JAXPValidatorComponent jAXPValidatorComponent = null;
                ValidatorHandler validatorHandler = this.fSchema.newValidatorHandler();
                jAXPValidatorComponent = new JAXPValidatorComponent(validatorHandler);
                this.addComponent(jAXPValidatorComponent);
                this.fLastComponent.setDocumentHandler(jAXPValidatorComponent);
                jAXPValidatorComponent.setDocumentSource(this.fLastComponent);
                this.fLastComponent = jAXPValidatorComponent;
                jAXPValidatorComponent.setDocumentHandler(this.fDocumentHandler);
            }
        }
    }

    private static boolean isXNICapabaleSchema(Schema schema) {
        if (!(schema instanceof XercesSchema)) {
            return false;
        }
        try {
            String string = System.getProperty(JAXPConfiguration.class.getName() + ".noSchemaOptimization");
            if (string == null) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public boolean getFeatureDefaultValue(String string) {
        int n2 = this.fComponents.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XMLComponent xMLComponent = (XMLComponent)this.fComponents.get(i2);
            Boolean bl2 = xMLComponent.getFeatureDefault(string);
            if (bl2 == null) continue;
            return bl2;
        }
        return false;
    }
}

