/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation.xs;

import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaLoader;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ReadonlyGrammarPool;
import com.sun.org.apache.xerces.internal.jaxp.validation.Util;
import com.sun.org.apache.xerces.internal.jaxp.validation.xs.SchemaImpl;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class SchemaFactoryImpl
extends SchemaFactory {
    private final XMLSchemaLoader loader = new XMLSchemaLoader();
    private static XSMessageFormatter messageFormatter = new XSMessageFormatter();
    private ErrorHandler errorHandler;
    private LSResourceResolver resourceResolver;
    private SAXParseException lastException;
    private final SecurityManager secureProcessing = new SecurityManager();
    private boolean enableSP;

    public SchemaFactoryImpl() {
        this.loader.setErrorHandler(new ErrorHandlerWrapper(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
                if (SchemaFactoryImpl.this.errorHandler != null) {
                    SchemaFactoryImpl.this.errorHandler.warning(sAXParseException);
                }
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                SchemaFactoryImpl.this.lastException = sAXParseException;
                if (SchemaFactoryImpl.this.errorHandler == null) {
                    throw sAXParseException;
                }
                SchemaFactoryImpl.this.errorHandler.error(sAXParseException);
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                SchemaFactoryImpl.this.lastException = sAXParseException;
                if (SchemaFactoryImpl.this.errorHandler == null) {
                    throw sAXParseException;
                }
                SchemaFactoryImpl.this.errorHandler.fatalError(sAXParseException);
            }
        }));
    }

    public boolean isSchemaLanguageSupported(String string) {
        if (string == null) {
            throw new NullPointerException(messageFormatter.formatMessage(Locale.getDefault(), "SchemaLanguageSupportedErrorWhenNull", new Object[]{this.getClass().getName()}));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(messageFormatter.formatMessage(Locale.getDefault(), "SchemaLanguageSupportedErrorWhenLength", new Object[]{this.getClass().getName()}));
        }
        return string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://relaxng.org/ns/structure/1.0");
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resourceResolver = lSResourceResolver;
        this.loader.setEntityResolver(new DOMEntityResolverWrapper(lSResourceResolver));
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Schema newSchema(Source[] sourceArray) throws SAXException {
        this.lastException = null;
        XMLGrammarPoolImpl xMLGrammarPoolImpl = new XMLGrammarPoolImpl();
        this.loader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPoolImpl);
        this.loader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        if (this.enableSP) {
            this.loader.setProperty("http://apache.org/xml/properties/security-manager", this.secureProcessing);
        } else {
            this.loader.setProperty("http://apache.org/xml/properties/security-manager", null);
        }
        for (int i2 = 0; i2 < sourceArray.length; ++i2) {
            try {
                this.loader.loadGrammar(sourceArray[i2]);
                continue;
            }
            catch (XNIException xNIException) {
                throw Util.toSAXException(xNIException);
            }
            catch (IOException iOException) {
                SAXParseException sAXParseException = new SAXParseException(iOException.getMessage(), null, iOException);
                this.errorHandler.error(sAXParseException);
                throw sAXParseException;
            }
        }
        if (this.lastException != null) {
            throw this.lastException;
        }
        return new SchemaImpl(new ReadonlyGrammarPool(xMLGrammarPoolImpl), true);
    }

    public Schema newSchema() throws SAXException {
        return new SchemaImpl(new XMLGrammarPoolImpl(){

            public boolean equals(XMLGrammarDescription xMLGrammarDescription, XMLGrammarDescription xMLGrammarDescription2) {
                String string = xMLGrammarDescription.getExpandedSystemId();
                String string2 = xMLGrammarDescription2.getExpandedSystemId();
                if (string != null && string2 != null) {
                    return string.equals(string2);
                }
                return string == null && string2 == null;
            }

            public int hashCode(XMLGrammarDescription xMLGrammarDescription) {
                String string = xMLGrammarDescription.getExpandedSystemId();
                if (string != null) {
                    return string.hashCode();
                }
                return 0;
            }
        }, false);
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "nullparameter", new Object[]{"setFeature(String,boolean)"}));
        }
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "feature-not-supported", new Object[]{string}));
        }
        this.enableSP = bl2;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            throw new NullPointerException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "nullparameter", new Object[]{"getFeature(String)"}));
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.enableSP;
        }
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "feature-not-supported", new Object[]{string}));
    }
}

