/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaException;
import com.sun.org.apache.xerces.internal.impl.xs.XSConstraints;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.xni.QName;
import java.util.Vector;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private static final short STATE_CHILD = 1;
    private XSElementDecl[] fAllElements;
    private boolean[] fIsOptionalElement;
    private boolean fHasOptionalContent = false;
    private int fNumElements = 0;

    public XSAllCM(boolean bl2, int n2) {
        this.fHasOptionalContent = bl2;
        this.fAllElements = new XSElementDecl[n2];
        this.fIsOptionalElement = new boolean[n2];
    }

    public void addElement(XSElementDecl xSElementDecl, boolean bl2) {
        this.fAllElements[this.fNumElements] = xSElementDecl;
        this.fIsOptionalElement[this.fNumElements] = bl2;
        ++this.fNumElements;
    }

    public int[] startContentModel() {
        int[] nArray = new int[this.fNumElements + 1];
        for (int i2 = 0; i2 <= this.fNumElements; ++i2) {
            nArray[i2] = 0;
        }
        return nArray;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fNumElements && (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[i2])) == null; ++i2) {
        }
        return xSElementDecl;
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (nArray[0] < 0) {
            nArray[0] = -2;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = 1;
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (nArray[i2 + 1] != 0 || (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[i2])) == null) continue;
            nArray[i2 + 1] = 1;
            return xSElementDecl;
        }
        nArray[0] = -1;
        return this.findMatchingDecl(qName, substitutionGroupHandler);
    }

    public boolean endContentModel(int[] nArray) {
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            return false;
        }
        if (this.fHasOptionalContent && n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (this.fIsOptionalElement[i2] || nArray[i2 + 1] != 0) continue;
            return false;
        }
        return true;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            for (int i3 = i2 + 1; i3 < this.fNumElements; ++i3) {
                if (!XSConstraints.overlapUPA(this.fAllElements[i2], this.fAllElements[i3], substitutionGroupHandler)) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[i2].toString(), this.fAllElements[i3].toString()});
            }
        }
        return false;
    }

    public Vector whatCanGoHere(int[] nArray) {
        Vector<XSElementDecl> vector = new Vector<XSElementDecl>();
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (nArray[i2 + 1] != 0) continue;
            vector.addElement(this.fAllElements[i2]);
        }
        return vector;
    }
}

