/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSDeclarationPool;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSModelGroupImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.CMNodeFactory;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSAllCM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSDFACM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private CMNodeFactory fNodeFactory;

    public CMBuilder(CMNodeFactory cMNodeFactory) {
        this.fNodeFactory = cMNodeFactory;
    }

    public void setDeclPool(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl xSComplexTypeDecl) {
        short s2 = xSComplexTypeDecl.getContentType();
        if (s2 == 1 || s2 == 0) {
            return null;
        }
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (xSParticleDecl == null) {
            return fEmptyCM;
        }
        XSCMValidator xSCMValidator = null;
        xSCMValidator = xSParticleDecl.fType == 3 && ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor == 103 ? this.createAllCM(xSParticleDecl) : this.createDFACM(xSParticleDecl);
        this.fNodeFactory.resetNodeCount();
        if (xSCMValidator == null) {
            xSCMValidator = fEmptyCM;
        }
        return xSCMValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        XSAllCM xSAllCM = new XSAllCM(xSParticleDecl.fMinOccurs == 0, xSModelGroupImpl.fParticleCount);
        for (int i2 = 0; i2 < xSModelGroupImpl.fParticleCount; ++i2) {
            xSAllCM.addElement((XSElementDecl)xSModelGroupImpl.fParticles[i2].fValue, xSModelGroupImpl.fParticles[i2].fMinOccurs == 0);
        }
        return xSAllCM;
    }

    XSCMValidator createDFACM(XSParticleDecl xSParticleDecl) {
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode = this.buildSyntaxTree(xSParticleDecl);
        if (cMNode == null) {
            return null;
        }
        return new XSDFACM(cMNode, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl xSParticleDecl) {
        int n2 = xSParticleDecl.fMaxOccurs;
        int n3 = xSParticleDecl.fMinOccurs;
        short s2 = xSParticleDecl.fType;
        CMNode cMNode = null;
        if (s2 == 2 || s2 == 1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.expandContentModel(cMNode, n3, n2);
        } else if (s2 == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            CMNode cMNode2 = null;
            boolean bl2 = false;
            for (int i2 = 0; i2 < xSModelGroupImpl.fParticleCount; ++i2) {
                cMNode2 = this.buildSyntaxTree(xSModelGroupImpl.fParticles[i2]);
                if (cMNode2 == null) continue;
                if (cMNode == null) {
                    cMNode = cMNode2;
                    continue;
                }
                cMNode = this.fNodeFactory.getCMBinOpNode(xSModelGroupImpl.fCompositor, cMNode, cMNode2);
                bl2 = true;
            }
            if (cMNode != null) {
                if (xSModelGroupImpl.fCompositor == 101 && !bl2 && xSModelGroupImpl.fParticleCount > 1) {
                    cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                }
                cMNode = this.expandContentModel(cMNode, n3, n2);
            }
        }
        return cMNode;
    }

    private CMNode expandContentModel(CMNode cMNode, int n2, int n3) {
        CMNode cMNode2 = null;
        if (n2 == 1 && n3 == 1) {
            cMNode2 = cMNode;
        } else if (n2 == 0 && n3 == 1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(5, cMNode);
        } else if (n2 == 0 && n3 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(4, cMNode);
        } else if (n2 == 1 && n3 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
        } else if (n3 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
            cMNode2 = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n2 - 1, true), cMNode2);
        } else {
            if (n2 > 0) {
                cMNode2 = this.multiNodes(cMNode, n2, false);
            }
            if (n3 > n2) {
                cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                cMNode2 = cMNode2 == null ? this.multiNodes(cMNode, n3 - n2, false) : this.fNodeFactory.getCMBinOpNode(102, cMNode2, this.multiNodes(cMNode, n3 - n2, true));
            }
        }
        return cMNode2;
    }

    private CMNode multiNodes(CMNode cMNode, int n2, boolean bl2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return bl2 ? this.copyNode(cMNode) : cMNode;
        }
        int n3 = n2 / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n3, bl2), this.multiNodes(cMNode, n2 - n3, true));
    }

    private CMNode copyNode(CMNode cMNode) {
        int n2 = cMNode.type();
        if (n2 == 101 || n2 == 102) {
            XSCMBinOp xSCMBinOp = (XSCMBinOp)cMNode;
            cMNode = this.fNodeFactory.getCMBinOpNode(n2, this.copyNode(xSCMBinOp.getLeft()), this.copyNode(xSCMBinOp.getRight()));
        } else if (n2 == 4 || n2 == 6 || n2 == 5) {
            XSCMUniOp xSCMUniOp = (XSCMUniOp)cMNode;
            cMNode = this.fNodeFactory.getCMUniOpNode(n2, this.copyNode(xSCMUniOp.getChild()));
        } else if (n2 == 1 || n2 == 2) {
            XSCMLeaf xSCMLeaf = (XSCMLeaf)cMNode;
            cMNode = this.fNodeFactory.getCMLeafNode(xSCMLeaf.type(), xSCMLeaf.getLeaf(), xSCMLeaf.getParticleId(), this.fLeafCount++);
        }
        return cMNode;
    }
}

