/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.statics;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.DescendingVisitor;
import com.sun.org.apache.bcel.internal.classfile.EmptyVisitor;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.PassVerifier;
import com.sun.org.apache.bcel.internal.verifier.VerificationResult;
import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.VerifierFactory;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.ClassConstraintException;
import com.sun.org.apache.bcel.internal.verifier.exc.LocalVariableInfoInconsistentException;
import com.sun.org.apache.bcel.internal.verifier.statics.LocalVariablesInfo;
import com.sun.org.apache.bcel.internal.verifier.statics.StringRepresentation;
import java.util.HashMap;
import java.util.HashSet;

public final class Pass2Verifier
extends PassVerifier
implements Constants {
    private LocalVariablesInfo[] localVariablesInfos;
    private Verifier myOwner;

    public Pass2Verifier(Verifier verifier) {
        this.myOwner = verifier;
    }

    public LocalVariablesInfo getLocalVariablesInfo(int n2) {
        if (this.verify() != VerificationResult.VR_OK) {
            return null;
        }
        if (n2 < 0 || n2 >= this.localVariablesInfos.length) {
            throw new AssertionViolatedException("Method number out of range.");
        }
        return this.localVariablesInfos[n2];
    }

    public VerificationResult do_verify() {
        VerificationResult verificationResult = this.myOwner.doPass1();
        if (verificationResult.equals(VerificationResult.VR_OK)) {
            this.localVariablesInfos = new LocalVariablesInfo[Repository.lookupClass(this.myOwner.getClassName()).getMethods().length];
            VerificationResult verificationResult2 = VerificationResult.VR_OK;
            try {
                this.constant_pool_entries_satisfy_static_constraints();
                this.field_and_method_refs_are_valid();
                this.every_class_has_an_accessible_superclass();
                this.final_methods_are_not_overridden();
            }
            catch (ClassConstraintException classConstraintException) {
                verificationResult2 = new VerificationResult(2, classConstraintException.getMessage());
            }
            return verificationResult2;
        }
        return VerificationResult.VR_NOTYET;
    }

    private void every_class_has_an_accessible_superclass() {
        HashSet<String> hashSet = new HashSet<String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n2 = -1;
        while (n2 != 0) {
            n2 = javaClass.getSuperclassNameIndex();
            if (n2 == 0) {
                if (javaClass == Repository.lookupClass(Type.OBJECT.getClassName())) continue;
                throw new ClassConstraintException("Superclass of '" + javaClass.getClassName() + "' missing but not " + Type.OBJECT.getClassName() + " itself!");
            }
            String string = javaClass.getSuperclassName();
            if (!hashSet.add(string)) {
                throw new ClassConstraintException("Circular superclass hierarchy detected.");
            }
            Verifier verifier = VerifierFactory.getVerifier(string);
            VerificationResult verificationResult = verifier.doPass1();
            if (verificationResult != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Could not load in ancestor class '" + string + "'.");
            }
            javaClass = Repository.lookupClass(string);
            if (!javaClass.isFinal()) continue;
            throw new ClassConstraintException("Ancestor class '" + string + "' has the FINAL access modifier and must therefore not be subclassed.");
        }
    }

    private void final_methods_are_not_overridden() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        int n2 = -1;
        while (n2 != 0) {
            n2 = javaClass.getSuperclassNameIndex();
            ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
            Method[] methodArray = javaClass.getMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                String string = methodArray[i2].getName() + methodArray[i2].getSignature();
                if (hashMap.containsKey(string)) {
                    if (methodArray[i2].isFinal()) {
                        throw new ClassConstraintException("Method '" + string + "' in class '" + hashMap.get(string) + "' overrides the final (not-overridable) definition in class '" + javaClass.getClassName() + "'.");
                    }
                    if (methodArray[i2].isStatic()) continue;
                    hashMap.put(string, javaClass.getClassName());
                    continue;
                }
                if (methodArray[i2].isStatic()) continue;
                hashMap.put(string, javaClass.getClassName());
            }
            javaClass = Repository.lookupClass(javaClass.getSuperclassName());
        }
    }

    private void constant_pool_entries_satisfy_static_constraints() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        new CPESSC_Visitor(javaClass);
    }

    private void field_and_method_refs_are_valid() {
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        DescendingVisitor descendingVisitor = new DescendingVisitor(javaClass, new FAMRAV_Visitor(javaClass));
        descendingVisitor.visit();
    }

    private static final boolean validClassName(String string) {
        return true;
    }

    private static boolean validMethodName(String string, boolean bl2) {
        if (Pass2Verifier.validJavaLangMethodName(string)) {
            return true;
        }
        if (bl2) {
            return string.equals("<init>") || string.equals("<clinit>");
        }
        return string.equals("<init>");
    }

    private static boolean validClassMethodName(String string) {
        return Pass2Verifier.validMethodName(string, false);
    }

    private static boolean validJavaLangMethodName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean validInterfaceMethodName(String string) {
        if (string.startsWith("<")) {
            return false;
        }
        return Pass2Verifier.validJavaLangMethodName(string);
    }

    private static boolean validJavaIdentifier(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean validFieldName(String string) {
        return Pass2Verifier.validJavaIdentifier(string);
    }

    private static String tostring(Node node) {
        return new StringRepresentation(node).toString();
    }

    private class CPESSC_Visitor
    extends EmptyVisitor
    implements Visitor {
        private Class CONST_Class;
        private Class CONST_Fieldref;
        private Class CONST_Methodref;
        private Class CONST_InterfaceMethodref;
        private Class CONST_String;
        private Class CONST_Integer;
        private Class CONST_Float;
        private Class CONST_Long;
        private Class CONST_Double;
        private Class CONST_NameAndType;
        private Class CONST_Utf8;
        private final JavaClass jc;
        private final ConstantPool cp;
        private final int cplen;
        private DescendingVisitor carrier;
        private HashSet field_names = new HashSet();
        private HashSet field_names_and_desc = new HashSet();
        private HashSet method_names_and_desc = new HashSet();

        private CPESSC_Visitor(JavaClass javaClass) {
            this.jc = javaClass;
            this.cp = javaClass.getConstantPool();
            this.cplen = this.cp.getLength();
            this.CONST_Class = ConstantClass.class;
            this.CONST_Fieldref = ConstantFieldref.class;
            this.CONST_Methodref = ConstantMethodref.class;
            this.CONST_InterfaceMethodref = ConstantInterfaceMethodref.class;
            this.CONST_String = ConstantString.class;
            this.CONST_Integer = ConstantInteger.class;
            this.CONST_Float = ConstantFloat.class;
            this.CONST_Long = ConstantLong.class;
            this.CONST_Double = ConstantDouble.class;
            this.CONST_NameAndType = ConstantNameAndType.class;
            this.CONST_Utf8 = ConstantUtf8.class;
            this.carrier = new DescendingVisitor(javaClass, this);
            this.carrier.visit();
        }

        private void checkIndex(Node node, int n2, Class clazz) {
            if (n2 < 0 || n2 >= this.cplen) {
                throw new ClassConstraintException("Invalid index '" + n2 + "' used by '" + Pass2Verifier.tostring(node) + "'.");
            }
            Constant constant = this.cp.getConstant(n2);
            if (!clazz.isInstance(constant)) {
                String string = clazz.toString().substring(clazz.toString().lastIndexOf(".") + 1);
                throw new ClassCastException("Illegal constant '" + Pass2Verifier.tostring(constant) + "' at index '" + n2 + "'. '" + Pass2Verifier.tostring(node) + "' expects a '" + clazz + "'.");
            }
        }

        public void visitJavaClass(JavaClass javaClass) {
            Attribute[] attributeArray = javaClass.getAttributes();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = new InnerClassDetector(this.jc).innerClassReferenced();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (!(attributeArray[i2] instanceof SourceFile || attributeArray[i2] instanceof Deprecated || attributeArray[i2] instanceof InnerClasses || attributeArray[i2] instanceof Synthetic)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' as an attribute of the ClassFile structure '" + Pass2Verifier.tostring(javaClass) + "' is unknown and will therefore be ignored.");
                }
                if (attributeArray[i2] instanceof SourceFile) {
                    if (!bl2) {
                        bl2 = true;
                    } else {
                        throw new ClassConstraintException("A ClassFile structure (like '" + Pass2Verifier.tostring(javaClass) + "') may have no more than one SourceFile attribute.");
                    }
                }
                if (!(attributeArray[i2] instanceof InnerClasses)) continue;
                if (!bl3) {
                    bl3 = true;
                } else if (bl4) {
                    throw new ClassConstraintException("A Classfile structure (like '" + Pass2Verifier.tostring(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). More than one InnerClasses attribute was found.");
                }
                if (bl4) continue;
                Pass2Verifier.this.addMessage("No referenced Inner Class found, but InnerClasses attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' found. Strongly suggest removal of that attribute.");
            }
            if (bl4 && !bl3) {
                Pass2Verifier.this.addMessage("A Classfile structure (like '" + Pass2Verifier.tostring(javaClass) + "') must have exactly one InnerClasses attribute if at least one Inner Class is referenced (which is the case). No InnerClasses attribute was found.");
            }
        }

        public void visitConstantClass(ConstantClass constantClass) {
            if (constantClass.getTag() != 7) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantClass) + "'.");
            }
            this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            this.checkIndex(constantFieldref, constantFieldref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantFieldref, constantFieldref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            this.checkIndex(constantMethodref, constantMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantMethodref, constantMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getClassIndex(), this.CONST_Class);
            this.checkIndex(constantInterfaceMethodref, constantInterfaceMethodref.getNameAndTypeIndex(), this.CONST_NameAndType);
        }

        public void visitConstantString(ConstantString constantString) {
            if (constantString.getTag() != 8) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantString) + "'.");
            }
            this.checkIndex(constantString, constantString.getStringIndex(), this.CONST_Utf8);
        }

        public void visitConstantInteger(ConstantInteger constantInteger) {
            if (constantInteger.getTag() != 3) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantInteger) + "'.");
            }
        }

        public void visitConstantFloat(ConstantFloat constantFloat) {
            if (constantFloat.getTag() != 4) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantFloat) + "'.");
            }
        }

        public void visitConstantLong(ConstantLong constantLong) {
            if (constantLong.getTag() != 5) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantLong) + "'.");
            }
        }

        public void visitConstantDouble(ConstantDouble constantDouble) {
            if (constantDouble.getTag() != 6) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantDouble) + "'.");
            }
        }

        public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
            if (constantNameAndType.getTag() != 12) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantNameAndType) + "'.");
            }
            this.checkIndex(constantNameAndType, constantNameAndType.getNameIndex(), this.CONST_Utf8);
            this.checkIndex(constantNameAndType, constantNameAndType.getSignatureIndex(), this.CONST_Utf8);
        }

        public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
            if (constantUtf8.getTag() != 1) {
                throw new ClassConstraintException("Wrong constant tag in '" + Pass2Verifier.tostring(constantUtf8) + "'.");
            }
        }

        public void visitField(Field field) {
            Object object;
            if (this.jc.isClass()) {
                int n2 = 0;
                if (field.isPrivate()) {
                    ++n2;
                }
                if (field.isProtected()) {
                    ++n2;
                }
                if (field.isPublic()) {
                    ++n2;
                }
                if (n2 > 1) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (field.isFinal() && field.isVolatile()) {
                    throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' must only have at most one of its ACC_FINAL, ACC_VOLATILE modifiers set.");
                }
            } else {
                if (!field.isPublic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!field.isStatic()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (!field.isFinal()) {
                    throw new ClassConstraintException("Interface field '" + Pass2Verifier.tostring(field) + "' must have the ACC_FINAL modifier set but hasn't!");
                }
            }
            if ((field.getAccessFlags() & 0xFFFFFF20) > 0) {
                Pass2Verifier.this.addMessage("Field '" + Pass2Verifier.tostring(field) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_VOLATILE, ACC_TRANSIENT set (ignored).");
            }
            this.checkIndex(field, field.getNameIndex(), this.CONST_Utf8);
            String string = field.getName();
            if (!Pass2Verifier.validFieldName(string)) {
                throw new ClassConstraintException("Field '" + Pass2Verifier.tostring(field) + "' has illegal name '" + field.getName() + "'.");
            }
            this.checkIndex(field, field.getSignatureIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes();
            try {
                object = Type.getType(string2);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string2 + "' used by '" + Pass2Verifier.tostring(field) + "'.");
            }
            object = string + string2;
            if (this.field_names_and_desc.contains(object)) {
                throw new ClassConstraintException("No two fields (like '" + Pass2Verifier.tostring(field) + "') are allowed have same names and descriptors!");
            }
            if (this.field_names.contains(string)) {
                Pass2Verifier.this.addMessage("More than one field of name '" + string + "' detected (but with different type descriptors). This is very unusual.");
            }
            this.field_names_and_desc.add(object);
            this.field_names.add(string);
            Attribute[] attributeArray = field.getAttributes();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (!(attributeArray[i2] instanceof ConstantValue || attributeArray[i2] instanceof Synthetic || attributeArray[i2] instanceof Deprecated)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' as an attribute of Field '" + Pass2Verifier.tostring(field) + "' is unknown and will therefore be ignored.");
                }
                if (attributeArray[i2] instanceof ConstantValue) continue;
                Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' as an attribute of Field '" + Pass2Verifier.tostring(field) + "' is not a ConstantValue and is therefore only of use for debuggers and such.");
            }
        }

        public void visitMethod(Method method) {
            String string;
            int n2;
            Verifier verifier;
            Attribute[] attributeArray;
            Type[] typeArray;
            Type type;
            this.checkIndex(method, method.getNameIndex(), this.CONST_Utf8);
            String string2 = method.getName();
            if (!Pass2Verifier.validMethodName(string2, true)) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has illegal name '" + string2 + "'.");
            }
            this.checkIndex(method, method.getSignatureIndex(), this.CONST_Utf8);
            String string3 = ((ConstantUtf8)this.cp.getConstant(method.getSignatureIndex())).getBytes();
            try {
                type = Type.getReturnType(string3);
                typeArray = Type.getArgumentTypes(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by Method '" + Pass2Verifier.tostring(method) + "'.");
            }
            Type type2 = type;
            if (type2 instanceof ArrayType) {
                type2 = ((ArrayType)type2).getBasicType();
            }
            if (type2 instanceof ObjectType && (attributeArray = (verifier = VerifierFactory.getVerifier(((ObjectType)type2).getClassName())).doPass1()) != VerificationResult.VR_OK) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has a return type that does not pass verification pass 1: '" + attributeArray + "'.");
            }
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                VerificationResult verificationResult;
                type2 = typeArray[n2];
                if (type2 instanceof ArrayType) {
                    type2 = ((ArrayType)type2).getBasicType();
                }
                if (!(type2 instanceof ObjectType) || (verificationResult = (attributeArray = VerifierFactory.getVerifier(((ObjectType)type2).getClassName())).doPass1()) == VerificationResult.VR_OK) continue;
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has an argument type that does not pass verification pass 1: '" + verificationResult + "'.");
            }
            if (string2.equals("<clinit>") && typeArray.length != 0) {
                throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' has illegal name '" + string2 + "'. It's name resembles the class or interface initialization method which it isn't because of its arguments (==descriptor).");
            }
            if (this.jc.isClass()) {
                n2 = 0;
                if (method.isPrivate()) {
                    ++n2;
                }
                if (method.isProtected()) {
                    ++n2;
                }
                if (method.isPublic()) {
                    ++n2;
                }
                if (n2 > 1) {
                    throw new ClassConstraintException("Method '" + Pass2Verifier.tostring(method) + "' must only have at most one of its ACC_PRIVATE, ACC_PROTECTED, ACC_PUBLIC modifiers set.");
                }
                if (method.isAbstract()) {
                    if (method.isFinal()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_FINAL modifier set.");
                    }
                    if (method.isNative()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_NATIVE modifier set.");
                    }
                    if (method.isPrivate()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_PRIVATE modifier set.");
                    }
                    if (method.isStatic()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_STATIC modifier set.");
                    }
                    if (method.isStrictfp()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_STRICT modifier set.");
                    }
                    if (method.isSynchronized()) {
                        throw new ClassConstraintException("Abstract method '" + Pass2Verifier.tostring(method) + "' must not have the ACC_SYNCHRONIZED modifier set.");
                    }
                }
            } else if (!string2.equals("<clinit>")) {
                if (!method.isPublic()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must have the ACC_PUBLIC modifier set but hasn't!");
                }
                if (!method.isAbstract()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must have the ACC_STATIC modifier set but hasn't!");
                }
                if (method.isPrivate() || method.isProtected() || method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isStrictfp()) {
                    throw new ClassConstraintException("Interface method '" + Pass2Verifier.tostring(method) + "' must not have any of the ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT modifiers set.");
                }
            }
            if (string2.equals("<init>") && (method.isStatic() || method.isFinal() || method.isSynchronized() || method.isNative() || method.isAbstract())) {
                throw new ClassConstraintException("Instance initialization method '" + Pass2Verifier.tostring(method) + "' must not have any of the ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT modifiers set.");
            }
            if (string2.equals("<clinit>")) {
                if ((method.getAccessFlags() & 0xFFFFF7FF) > 0) {
                    Pass2Verifier.this.addMessage("Class or interface initialization method '" + Pass2Verifier.tostring(method) + "' has superfluous access modifier(s) set: everything but ACC_STRICT is ignored.");
                }
                if (method.isAbstract()) {
                    throw new ClassConstraintException("Class or interface initialization method '" + Pass2Verifier.tostring(method) + "' must not be abstract. This contradicts the Java Language Specification, Second Edition (which omits this constraint) but is common practice of existing verifiers.");
                }
            }
            if ((method.getAccessFlags() & 0xFFFFF2C0) > 0) {
                Pass2Verifier.this.addMessage("Method '" + Pass2Verifier.tostring(method) + "' has access flag(s) other than ACC_PUBLIC, ACC_PRIVATE, ACC_PROTECTED, ACC_STATIC, ACC_FINAL, ACC_SYNCHRONIZED, ACC_NATIVE, ACC_ABSTRACT, ACC_STRICT set (ignored).");
            }
            if (this.method_names_and_desc.contains(string = string2 + string3)) {
                throw new ClassConstraintException("No two methods (like '" + Pass2Verifier.tostring(method) + "') are allowed have same names and desciptors!");
            }
            this.method_names_and_desc.add(string);
            attributeArray = method.getAttributes();
            int n3 = 0;
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (!(attributeArray[i2] instanceof Code || attributeArray[i2] instanceof ExceptionTable || attributeArray[i2] instanceof Synthetic || attributeArray[i2] instanceof Deprecated)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' as an attribute of Method '" + Pass2Verifier.tostring(method) + "' is unknown and will therefore be ignored.");
                }
                if (!(attributeArray[i2] instanceof Code) && !(attributeArray[i2] instanceof ExceptionTable)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(attributeArray[i2]) + "' as an attribute of Method '" + Pass2Verifier.tostring(method) + "' is neither Code nor Exceptions and is therefore only of use for debuggers and such.");
                }
                if (attributeArray[i2] instanceof Code && (method.isNative() || method.isAbstract())) {
                    throw new ClassConstraintException("Native or abstract methods like '" + Pass2Verifier.tostring(method) + "' must not have a Code attribute like '" + Pass2Verifier.tostring(attributeArray[i2]) + "'.");
                }
                if (!(attributeArray[i2] instanceof Code)) continue;
                ++n3;
            }
            if (!method.isNative() && !method.isAbstract() && n3 != 1) {
                throw new ClassConstraintException("Non-native, non-abstract methods like '" + Pass2Verifier.tostring(method) + "' must have exactly one Code attribute (found: " + n3 + ").");
            }
        }

        public void visitSourceFile(SourceFile sourceFile) {
            this.checkIndex(sourceFile, sourceFile.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(sourceFile.getNameIndex())).getBytes();
            if (!string.equals("SourceFile")) {
                throw new ClassConstraintException("The SourceFile attribute '" + Pass2Verifier.tostring(sourceFile) + "' is not correctly named 'SourceFile' but '" + string + "'.");
            }
            this.checkIndex(sourceFile, sourceFile.getSourceFileIndex(), this.CONST_Utf8);
            String string2 = ((ConstantUtf8)this.cp.getConstant(sourceFile.getSourceFileIndex())).getBytes();
            String string3 = string2.toLowerCase();
            if (string2.indexOf(47) != -1 || string2.indexOf(92) != -1 || string2.indexOf(58) != -1 || string3.lastIndexOf(".java") == -1) {
                Pass2Verifier.this.addMessage("SourceFile attribute '" + Pass2Verifier.tostring(sourceFile) + "' has a funny name: remember not to confuse certain parsers working on javap's output. Also, this name ('" + string2 + "') is considered an unqualified (simple) file name only.");
            }
        }

        public void visitDeprecated(Deprecated deprecated) {
            this.checkIndex(deprecated, deprecated.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(deprecated.getNameIndex())).getBytes();
            if (!string.equals("Deprecated")) {
                throw new ClassConstraintException("The Deprecated attribute '" + Pass2Verifier.tostring(deprecated) + "' is not correctly named 'Deprecated' but '" + string + "'.");
            }
        }

        public void visitSynthetic(Synthetic synthetic) {
            this.checkIndex(synthetic, synthetic.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(synthetic.getNameIndex())).getBytes();
            if (!string.equals("Synthetic")) {
                throw new ClassConstraintException("The Synthetic attribute '" + Pass2Verifier.tostring(synthetic) + "' is not correctly named 'Synthetic' but '" + string + "'.");
            }
        }

        public void visitInnerClasses(InnerClasses innerClasses) {
            this.checkIndex(innerClasses, innerClasses.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(innerClasses.getNameIndex())).getBytes();
            if (!string.equals("InnerClasses")) {
                throw new ClassConstraintException("The InnerClasses attribute '" + Pass2Verifier.tostring(innerClasses) + "' is not correctly named 'InnerClasses' but '" + string + "'.");
            }
            InnerClass[] innerClassArray = innerClasses.getInnerClasses();
            for (int i2 = 0; i2 < innerClassArray.length; ++i2) {
                int n2;
                this.checkIndex(innerClasses, innerClassArray[i2].getInnerClassIndex(), this.CONST_Class);
                int n3 = innerClassArray[i2].getOuterClassIndex();
                if (n3 != 0) {
                    this.checkIndex(innerClasses, n3, this.CONST_Class);
                }
                if ((n2 = innerClassArray[i2].getInnerNameIndex()) != 0) {
                    this.checkIndex(innerClasses, n2, this.CONST_Utf8);
                }
                int n4 = innerClassArray[i2].getInnerAccessFlags();
                if ((n4 &= 0xFFFFF9E0) == 0) continue;
                Pass2Verifier.this.addMessage("Unknown access flag for inner class '" + Pass2Verifier.tostring(innerClassArray[i2]) + "' set (InnerClasses attribute '" + Pass2Verifier.tostring(innerClasses) + "').");
            }
        }

        public void visitConstantValue(ConstantValue constantValue) {
            this.checkIndex(constantValue, constantValue.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(constantValue.getNameIndex())).getBytes();
            if (!string.equals("ConstantValue")) {
                throw new ClassConstraintException("The ConstantValue attribute '" + Pass2Verifier.tostring(constantValue) + "' is not correctly named 'ConstantValue' but '" + string + "'.");
            }
            Object object = this.carrier.predecessor();
            if (object instanceof Field) {
                Field field = (Field)object;
                Type type = Type.getType(((ConstantUtf8)this.cp.getConstant(field.getSignatureIndex())).getBytes());
                int n2 = constantValue.getConstantValueIndex();
                if (n2 < 0 || n2 >= this.cplen) {
                    throw new ClassConstraintException("Invalid index '" + n2 + "' used by '" + Pass2Verifier.tostring(constantValue) + "'.");
                }
                Constant constant = this.cp.getConstant(n2);
                if (this.CONST_Long.isInstance(constant) && type.equals(Type.LONG)) {
                    return;
                }
                if (this.CONST_Float.isInstance(constant) && type.equals(Type.FLOAT)) {
                    return;
                }
                if (this.CONST_Double.isInstance(constant) && type.equals(Type.DOUBLE)) {
                    return;
                }
                if (this.CONST_Integer.isInstance(constant) && (type.equals(Type.INT) || type.equals(Type.SHORT) || type.equals(Type.CHAR) || type.equals(Type.BYTE) || type.equals(Type.BOOLEAN))) {
                    return;
                }
                if (this.CONST_String.isInstance(constant) && type.equals(Type.STRING)) {
                    return;
                }
                throw new ClassConstraintException("Illegal type of ConstantValue '" + constantValue + "' embedding Constant '" + constant + "'. It is referenced by field '" + Pass2Verifier.tostring(field) + "' expecting a different type: '" + type + "'.");
            }
        }

        public void visitCode(Code code) {
            int n2;
            Cloneable cloneable;
            Object object;
            Object object2;
            Object object3;
            int n3;
            this.checkIndex(code, code.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(code.getNameIndex())).getBytes();
            if (!string.equals("Code")) {
                throw new ClassConstraintException("The Code attribute '" + Pass2Verifier.tostring(code) + "' is not correctly named 'Code' but '" + string + "'.");
            }
            Method method = null;
            if (!(this.carrier.predecessor() instanceof Method)) {
                Pass2Verifier.this.addMessage("Code attribute '" + Pass2Verifier.tostring(code) + "' is not declared in a method_info structure but in '" + this.carrier.predecessor() + "'. Ignored.");
                return;
            }
            method = (Method)this.carrier.predecessor();
            if (code.getCode().length == 0) {
                throw new ClassConstraintException("Code array of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') must not be empty.");
            }
            CodeException[] codeExceptionArray = code.getExceptionTable();
            for (n3 = 0; n3 < codeExceptionArray.length; ++n3) {
                int n4 = codeExceptionArray[n3].getCatchType();
                if (n4 == 0) continue;
                this.checkIndex(code, n4, this.CONST_Class);
                ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n4);
                this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
                object3 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes().replace('/', '.');
                Verifier verifier = VerifierFactory.getVerifier((String)object3);
                object2 = verifier.doPass1();
                if (object2 != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n3]) + "' that references '" + (String)object3 + "' as an Exception but it does not pass verification pass 1: " + object2);
                }
                object = Repository.lookupClass((String)object3);
                cloneable = Repository.lookupClass(Type.THROWABLE.getClassName());
                JavaClass javaClass = Repository.lookupClass(Type.OBJECT.getClassName());
                while (object != javaClass && object != cloneable) {
                    verifier = VerifierFactory.getVerifier(((JavaClass)object).getSuperclassName());
                    object2 = verifier.doPass1();
                    if (object2 != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n3]) + "' that references '" + (String)object3 + "' as an Exception but '" + ((JavaClass)object).getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + object2);
                    }
                    object = Repository.lookupClass(((JavaClass)object).getSuperclassName());
                }
                if (object == cloneable) continue;
                throw new ClassConstraintException("Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') has an exception_table entry '" + Pass2Verifier.tostring(codeExceptionArray[n3]) + "' that references '" + (String)object3 + "' as an Exception but it is not a subclass of '" + ((JavaClass)cloneable).getClassName() + "'.");
            }
            n3 = -1;
            Method[] methodArray = Repository.lookupClass(Pass2Verifier.this.myOwner.getClassName()).getMethods();
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                if (method != methodArray[n2]) continue;
                n3 = n2;
                break;
            }
            if (n3 < 0) {
                throw new AssertionViolatedException("Could not find a known BCEL Method object in the corresponding BCEL JavaClass object.");
            }
            ((Pass2Verifier)Pass2Verifier.this).localVariablesInfos[n3] = new LocalVariablesInfo(code.getMaxLocals());
            n2 = 0;
            object3 = code.getAttributes();
            for (int i2 = 0; i2 < ((Attribute[])object3).length; ++i2) {
                if (!(object3[i2] instanceof LineNumberTable) && !(object3[i2] instanceof LocalVariableTable)) {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(object3[i2]) + "' as an attribute of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') is unknown and will therefore be ignored.");
                } else {
                    Pass2Verifier.this.addMessage("Attribute '" + Pass2Verifier.tostring(object3[i2]) + "' as an attribute of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + method + "') will effectively be ignored and is only useful for debuggers and such.");
                }
                if (!(object3[i2] instanceof LocalVariableTable)) continue;
                object2 = (LocalVariableTable)object3[i2];
                this.checkIndex((Node)object2, ((Attribute)object2).getNameIndex(), this.CONST_Utf8);
                object = ((ConstantUtf8)this.cp.getConstant(((Attribute)object2).getNameIndex())).getBytes();
                if (!((String)object).equals("LocalVariableTable")) {
                    throw new ClassConstraintException("The LocalVariableTable attribute '" + Pass2Verifier.tostring((Node)object2) + "' is not correctly named 'LocalVariableTable' but '" + (String)object + "'.");
                }
                cloneable = code;
                int n5 = ((Code)cloneable).getMaxLocals();
                LocalVariable[] localVariableArray = ((LocalVariableTable)object2).getLocalVariableTable();
                for (int i3 = 0; i3 < localVariableArray.length; ++i3) {
                    Type type;
                    this.checkIndex((Node)object2, localVariableArray[i3].getNameIndex(), this.CONST_Utf8);
                    String string2 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[i3].getNameIndex())).getBytes();
                    if (!Pass2Verifier.validJavaIdentifier(string2)) {
                        throw new ClassConstraintException("LocalVariableTable '" + Pass2Verifier.tostring((Node)object2) + "' references a local variable by the name '" + string2 + "' which is not a legal Java simple name.");
                    }
                    this.checkIndex((Node)object2, localVariableArray[i3].getSignatureIndex(), this.CONST_Utf8);
                    String string3 = ((ConstantUtf8)this.cp.getConstant(localVariableArray[i3].getSignatureIndex())).getBytes();
                    try {
                        type = Type.getType(string3);
                    }
                    catch (ClassFormatError classFormatError) {
                        throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by LocalVariable '" + Pass2Verifier.tostring(localVariableArray[i3]) + "' referenced by '" + Pass2Verifier.tostring((Node)object2) + "'.");
                    }
                    int n6 = localVariableArray[i3].getIndex();
                    if ((type == Type.LONG || type == Type.DOUBLE ? n6 + 1 : n6) >= ((Code)cloneable).getMaxLocals()) {
                        throw new ClassConstraintException("LocalVariableTable attribute '" + Pass2Verifier.tostring((Node)object2) + "' references a LocalVariable '" + Pass2Verifier.tostring(localVariableArray[i3]) + "' with an index that exceeds the surrounding Code attribute's max_locals value of '" + ((Code)cloneable).getMaxLocals() + "'.");
                    }
                    try {
                        Pass2Verifier.this.localVariablesInfos[n3].add(n6, string2, localVariableArray[i3].getStartPC(), localVariableArray[i3].getLength(), type);
                        continue;
                    }
                    catch (LocalVariableInfoInconsistentException localVariableInfoInconsistentException) {
                        throw new ClassConstraintException("Conflicting information in LocalVariableTable '" + Pass2Verifier.tostring((Node)object2) + "' found in Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + Pass2Verifier.tostring(method) + "'). " + localVariableInfoInconsistentException.getMessage());
                    }
                }
                if (++n2 <= code.getMaxLocals()) continue;
                throw new ClassConstraintException("Number of LocalVariableTable attributes of Code attribute '" + Pass2Verifier.tostring(code) + "' (method '" + Pass2Verifier.tostring(method) + "') exceeds number of local variable slots '" + code.getMaxLocals() + "' ('There may be no more than one LocalVariableTable attribute per local variable in the Code attribute.').");
            }
        }

        public void visitExceptionTable(ExceptionTable exceptionTable) {
            this.checkIndex(exceptionTable, exceptionTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(exceptionTable.getNameIndex())).getBytes();
            if (!string.equals("Exceptions")) {
                throw new ClassConstraintException("The Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' is not correctly named 'Exceptions' but '" + string + "'.");
            }
            int[] nArray = exceptionTable.getExceptionIndexTable();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.checkIndex(exceptionTable, nArray[i2], this.CONST_Class);
                ConstantClass constantClass = (ConstantClass)this.cp.getConstant(nArray[i2]);
                this.checkIndex(constantClass, constantClass.getNameIndex(), this.CONST_Utf8);
                String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes().replace('/', '.');
                Verifier verifier = VerifierFactory.getVerifier(string2);
                VerificationResult verificationResult = verifier.doPass1();
                if (verificationResult != VerificationResult.VR_OK) {
                    throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but it does not pass verification pass 1: " + verificationResult);
                }
                JavaClass javaClass = Repository.lookupClass(string2);
                JavaClass javaClass2 = Repository.lookupClass(Type.THROWABLE.getClassName());
                JavaClass javaClass3 = Repository.lookupClass(Type.OBJECT.getClassName());
                while (javaClass != javaClass3 && javaClass != javaClass2) {
                    verifier = VerifierFactory.getVerifier(javaClass.getSuperclassName());
                    verificationResult = verifier.doPass1();
                    if (verificationResult != VerificationResult.VR_OK) {
                        throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but '" + javaClass.getSuperclassName() + "' in the ancestor hierachy does not pass verification pass 1: " + verificationResult);
                    }
                    javaClass = Repository.lookupClass(javaClass.getSuperclassName());
                }
                if (javaClass == javaClass2) continue;
                throw new ClassConstraintException("Exceptions attribute '" + Pass2Verifier.tostring(exceptionTable) + "' references '" + string2 + "' as an Exception but it is not a subclass of '" + javaClass2.getClassName() + "'.");
            }
        }

        public void visitLineNumberTable(LineNumberTable lineNumberTable) {
            this.checkIndex(lineNumberTable, lineNumberTable.getNameIndex(), this.CONST_Utf8);
            String string = ((ConstantUtf8)this.cp.getConstant(lineNumberTable.getNameIndex())).getBytes();
            if (!string.equals("LineNumberTable")) {
                throw new ClassConstraintException("The LineNumberTable attribute '" + Pass2Verifier.tostring(lineNumberTable) + "' is not correctly named 'LineNumberTable' but '" + string + "'.");
            }
        }

        public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        }

        public void visitUnknown(Unknown unknown) {
            this.checkIndex(unknown, unknown.getNameIndex(), this.CONST_Utf8);
            Pass2Verifier.this.addMessage("Unknown attribute '" + Pass2Verifier.tostring(unknown) + "'. This attribute is not known in any context!");
        }

        public void visitLocalVariable(LocalVariable localVariable) {
        }

        public void visitCodeException(CodeException codeException) {
        }

        public void visitConstantPool(ConstantPool constantPool) {
        }

        public void visitInnerClass(InnerClass innerClass) {
        }

        public void visitLineNumber(LineNumber lineNumber) {
        }
    }

    private class FAMRAV_Visitor
    extends EmptyVisitor
    implements Visitor {
        private final JavaClass jc;
        private final ConstantPool cp;

        private FAMRAV_Visitor(JavaClass javaClass) {
            this.jc = javaClass;
            this.cp = javaClass.getConstantPool();
        }

        public void visitConstantFieldref(ConstantFieldref constantFieldref) {
            if (constantFieldref.getTag() != 9) {
                throw new ClassConstraintException("ConstantFieldref '" + Pass2Verifier.tostring(constantFieldref) + "' has wrong tag!");
            }
            int n2 = constantFieldref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validFieldName(string)) {
                throw new ClassConstraintException("Invalid field name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            int n3 = constantFieldref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getType(string3);
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantFieldref) + "'.");
            }
        }

        public void visitConstantMethodref(ConstantMethodref constantMethodref) {
            if (constantMethodref.getTag() != 10) {
                throw new ClassConstraintException("ConstantMethodref '" + Pass2Verifier.tostring(constantMethodref) + "' has wrong tag!");
            }
            int n2 = constantMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassMethodName(string)) {
                throw new ClassConstraintException("Invalid (non-interface) method name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            int n3 = constantMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                Type[] typeArray = Type.getArgumentTypes(string3);
                if (string.equals("<init>") && type != Type.VOID) {
                    throw new ClassConstraintException("Instance initialization method must have VOID return type.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantMethodref) + "'.");
            }
        }

        public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
            if (constantInterfaceMethodref.getTag() != 11) {
                throw new ClassConstraintException("ConstantInterfaceMethodref '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "' has wrong tag!");
            }
            int n2 = constantInterfaceMethodref.getNameAndTypeIndex();
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.cp.getConstant(n2);
            String string = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getNameIndex())).getBytes();
            if (!Pass2Verifier.validInterfaceMethodName(string)) {
                throw new ClassConstraintException("Invalid (interface) method name '" + string + "' referenced by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            int n3 = constantInterfaceMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.cp.getConstant(n3);
            String string2 = ((ConstantUtf8)this.cp.getConstant(constantClass.getNameIndex())).getBytes();
            if (!Pass2Verifier.validClassName(string2)) {
                throw new ClassConstraintException("Illegal class name '" + string2 + "' used by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
            String string3 = ((ConstantUtf8)this.cp.getConstant(constantNameAndType.getSignatureIndex())).getBytes();
            try {
                Type type = Type.getReturnType(string3);
                Type[] typeArray = Type.getArgumentTypes(string3);
                if (string.equals("<clinit>") && type != Type.VOID) {
                    Pass2Verifier.this.addMessage("Class or interface initialization method '<clinit>' usually has VOID return type instead of '" + type + "'. Note this is really not a requirement of The Java Virtual Machine Specification, Second Edition.");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new ClassConstraintException("Illegal descriptor (==signature) '" + string3 + "' used by '" + Pass2Verifier.tostring(constantInterfaceMethodref) + "'.");
            }
        }
    }

    private class InnerClassDetector
    extends EmptyVisitor {
        private boolean hasInnerClass = false;
        private JavaClass jc;
        private ConstantPool cp;

        private InnerClassDetector() {
        }

        public InnerClassDetector(JavaClass javaClass) {
            this.jc = javaClass;
            this.cp = this.jc.getConstantPool();
            new DescendingVisitor(this.jc, this).visit();
        }

        public boolean innerClassReferenced() {
            return this.hasInnerClass;
        }

        public void visitConstantClass(ConstantClass constantClass) {
            String string;
            Constant constant = this.cp.getConstant(constantClass.getNameIndex());
            if (constant instanceof ConstantUtf8 && (string = ((ConstantUtf8)constant).getBytes()).startsWith(this.jc.getClassName().replace('.', '/') + "$")) {
                this.hasInnerClass = true;
            }
        }
    }
}

