/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    private byte type;
    private int index = -1;
    private ConstantPool constant_pool;

    StackMapType(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(dataInputStream.readByte(), -1, constantPool);
        if (this.hasIndex()) {
            this.setIndex(dataInputStream.readShort());
        }
        this.setConstantPool(constantPool);
    }

    public StackMapType(byte by, int n2, ConstantPool constantPool) {
        this.setType(by);
        this.setIndex(n2);
        this.setConstantPool(constantPool);
    }

    public void setType(byte by) {
        if (by < 0 || by > 8) {
            throw new RuntimeException("Illegal type for StackMapType: " + by);
        }
        this.type = by;
    }

    public byte getType() {
        return this.type;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        if (this.hasIndex()) {
            dataOutputStream.writeShort(this.getIndex());
        }
    }

    public final boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private String printIndex() {
        if (this.type == 7) {
            return ", class=" + this.constant_pool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    public final String toString() {
        return "(type=" + Constants.ITEM_NAMES[this.type] + this.printIndex() + ")";
    }

    public StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }
}

