/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.ClassPath;
import com.sun.org.apache.bcel.internal.util.ClassQueue;
import com.sun.org.apache.bcel.internal.util.ClassVector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public abstract class Repository {
    private static ClassPath class_path = new ClassPath();
    private static HashMap classes;
    private static JavaClass OBJECT;

    public static JavaClass lookupClass(String string) {
        if (string == null || string.equals("")) {
            throw new RuntimeException("Invalid class name");
        }
        JavaClass javaClass = (JavaClass)classes.get(string = string.replace('/', '.'));
        if (javaClass == null) {
            try {
                InputStream inputStream = class_path.getInputStream(string);
                javaClass = new ClassParser(inputStream, string).parse();
                string = javaClass.getClassName();
            }
            catch (IOException iOException) {
                return null;
            }
            classes.put(string, javaClass);
        }
        return javaClass;
    }

    public static ClassPath.ClassFile lookupClassFile(String string) {
        try {
            return class_path.getClassFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void clearCache() {
        classes = new HashMap();
        OBJECT = Repository.lookupClass("java.lang.Object");
        if (OBJECT == null) {
            System.err.println("Warning: java.lang.Object not found on CLASSPATH!");
        } else {
            classes.put("java.lang.Object", OBJECT);
        }
    }

    public static JavaClass addClass(JavaClass javaClass) {
        String string = javaClass.getClassName();
        JavaClass javaClass2 = (JavaClass)classes.get(string);
        if (javaClass2 == null) {
            javaClass2 = javaClass;
            classes.put(string, javaClass2);
        }
        return javaClass2;
    }

    public static void removeClass(String string) {
        classes.remove(string);
    }

    public static void removeClass(JavaClass javaClass) {
        Repository.removeClass(javaClass.getClassName());
    }

    private static final JavaClass getSuperClass(JavaClass javaClass) {
        if (javaClass == OBJECT) {
            return null;
        }
        return Repository.lookupClass(javaClass.getSuperclassName());
    }

    public static JavaClass[] getSuperClasses(JavaClass javaClass) {
        ClassVector classVector = new ClassVector();
        javaClass = Repository.getSuperClass(javaClass);
        while (javaClass != null) {
            classVector.addElement(javaClass);
            javaClass = Repository.getSuperClass(javaClass);
        }
        return classVector.toArray();
    }

    public static JavaClass[] getSuperClasses(String string) {
        JavaClass javaClass = Repository.lookupClass(string);
        return javaClass == null ? null : Repository.getSuperClasses(javaClass);
    }

    public static JavaClass[] getInterfaces(JavaClass javaClass) {
        ClassVector classVector = new ClassVector();
        ClassQueue classQueue = new ClassQueue();
        classQueue.enqueue(javaClass);
        while (!classQueue.empty()) {
            javaClass = classQueue.dequeue();
            String string = javaClass.getSuperclassName();
            String[] stringArray = javaClass.getInterfaceNames();
            if (javaClass.isInterface()) {
                classVector.addElement(javaClass);
            } else if (!string.equals("java.lang.Object")) {
                classQueue.enqueue(Repository.lookupClass(string));
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                classQueue.enqueue(Repository.lookupClass(stringArray[i2]));
            }
        }
        return classVector.toArray();
    }

    public static JavaClass[] getInterfaces(String string) {
        return Repository.getInterfaces(Repository.lookupClass(string));
    }

    public static boolean instanceOf(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == javaClass2) {
            return true;
        }
        JavaClass[] javaClassArray = Repository.getSuperClasses(javaClass);
        for (int i2 = 0; i2 < javaClassArray.length; ++i2) {
            if (javaClassArray[i2] != javaClass2) continue;
            return true;
        }
        if (javaClass2.isInterface()) {
            return Repository.implementationOf(javaClass, javaClass2);
        }
        return false;
    }

    public static boolean instanceOf(String string, String string2) {
        return Repository.instanceOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean instanceOf(JavaClass javaClass, String string) {
        return Repository.instanceOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean instanceOf(String string, JavaClass javaClass) {
        return Repository.instanceOf(Repository.lookupClass(string), javaClass);
    }

    public static boolean implementationOf(JavaClass javaClass, JavaClass javaClass2) {
        if (javaClass == javaClass2) {
            return true;
        }
        JavaClass[] javaClassArray = Repository.getInterfaces(javaClass);
        for (int i2 = 0; i2 < javaClassArray.length; ++i2) {
            if (javaClassArray[i2] != javaClass2) continue;
            return true;
        }
        return false;
    }

    public static boolean implementationOf(String string, String string2) {
        return Repository.implementationOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean implementationOf(JavaClass javaClass, String string) {
        return Repository.implementationOf(javaClass, Repository.lookupClass(string));
    }

    public static boolean implementationOf(String string, JavaClass javaClass) {
        return Repository.implementationOf(Repository.lookupClass(string), javaClass);
    }

    static {
        Repository.clearCache();
    }
}

