/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractPlayer;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.LineUnavailableException;

class MixerSynth
extends AbstractPlayer
implements Synthesizer {
    static final MixerSynthInfo info = new MixerSynthInfo();
    private static final boolean TRACE_MESSAGES = false;

    MixerSynth() throws MidiUnavailableException {
        super(info);
    }

    public long getLatency() {
        return this.nGetLatency();
    }

    protected boolean hasReceivers() {
        return true;
    }

    protected Receiver createReceiver() {
        return new SynthReceiver();
    }

    private boolean parse(int n2, int n3, int n4, int n5) {
        if ((n2 & 0xF) != 0 || n2 < 128 || n2 > 224) {
            return false;
        }
        switch (n2) {
            case 128: {
                this.channels[n3].noteOff(n4, n5);
                break;
            }
            case 144: {
                this.channels[n3].noteOn(n4, n5);
                break;
            }
            case 160: {
                this.channels[n3].setPolyPressure(n4, n5);
                break;
            }
            case 176: {
                this.channels[n3].controlChange(n4, n5);
                break;
            }
            case 192: {
                this.channels[n3].programChange(n4);
                break;
            }
            case 208: {
                this.channels[n3].setChannelPressure(n4);
                break;
            }
            case 224: {
                this.channels[n3].setPitchBend((n5 & 0x7F) << 7 | n4 & 0x7F);
            }
        }
        return true;
    }

    protected long getTimeStamp() {
        return -1L;
    }

    protected void implOpen() throws MidiUnavailableException {
        try {
            mixer.open(this);
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new MidiUnavailableException(lineUnavailableException.getMessage());
        }
        this.id = this.nCreateSynthesizer();
        if (this.id == 0L) {
            throw new MidiUnavailableException("Failed to initialize synthesizer");
        }
        this.openInternalSynth();
        this.connectToInternalSynth();
        if (!this.nStartSynthesizer(this.id)) {
            this.id = 0L;
            throw new MidiUnavailableException("Failed to start synthesizer");
        }
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2].setId(this.id);
        }
    }

    protected void implClose() {
        super.implClose();
        mixer.close(this);
    }

    private native long nCreateSynthesizer();

    private native boolean nStartSynthesizer(long var1);

    private native long nGetLatency();

    private static class MixerSynthInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Synthesizer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software wavetable synthesizer and receiver";
        private static final String version = "Version 1.0";

        private MixerSynthInfo() {
            super(name, vendor, description, version);
        }
    }

    class SynthReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        SynthReceiver() {
        }

        protected void implSend(MidiMessage midiMessage, long l2) {
            if (MixerSynth.this.id == 0L) {
                throw new IllegalStateException("Synthesizer is not open.");
            }
            if (!(midiMessage instanceof ShortMessage)) {
                return;
            }
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            MixerSynth.this.parse(shortMessage.getCommand(), shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2());
        }

        void sendPackedMidiMessage(int n2, long l2) {
            if (MixerSynth.this.id == 0L) {
                return;
            }
            MixerSynth.this.parse(n2 & 0xF0, n2 & 0xF, (n2 & 0x7F00) >> 8, (n2 & 0x7F0000) >> 16);
        }
    }
}

