/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Vector;

class WaitQ
extends Vector {
    boolean isBeingDestroyed = false;

    WaitQ(int n2, int n3) {
        super(n2, n3);
    }

    public synchronized void addWaiting(SnmpInformRequest snmpInformRequest) {
        int n2;
        long l2 = snmpInformRequest.getAbsMaxTimeToWait();
        for (n2 = this.size(); n2 > 0 && l2 >= this.getRequestAt(n2 - 1).getAbsMaxTimeToWait(); --n2) {
        }
        if (n2 == this.size()) {
            this.addElement(snmpInformRequest);
            this.notifyClients();
        } else {
            this.insertElementAt(snmpInformRequest, n2);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long l2 = 0L;
            if (!this.isEmpty()) {
                long l3 = System.currentTimeMillis();
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
                l2 = snmpInformRequest.getAbsMaxTimeToWait() - l3;
                if (l2 <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(l2);
        }
        return false;
    }

    public synchronized SnmpInformRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.lastElement();
            --this.elementCount;
            return snmpInformRequest;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void waitOnThisQueue(long l2) {
        if (l2 == 0L && !this.isEmpty() && SnmpQManager.isDebugOn()) {
            SnmpQManager.debug("waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:" + "Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpInformRequest getRequestAt(int n2) {
        return (SnmpInformRequest)this.elementAt(n2);
    }

    public synchronized SnmpInformRequest removeRequest(long l2) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SnmpInformRequest snmpInformRequest = this.getRequestAt(i2);
            if (l2 != (long)snmpInformRequest.getRequestId()) continue;
            this.removeElementAt(i2);
            return snmpInformRequest;
        }
        return null;
    }
}

