/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.ArrayQueue;
import com.sun.jmx.remote.internal.ListenerInfo;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ArrayNotificationBuffer
implements NotificationBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 1000;
    public static final String BUFFER_SIZE_PROPERTY = "jmx.remote.x.buffer.size";
    private boolean disposed = false;
    private static final HashMap mbsToBuffer = new HashMap(1);
    private final Collection sharers = new HashSet(1);
    private final NotificationListener queryBufferListener = new BufferListener();
    private final NotificationListener creationBufferListener = new BufferListener();
    private static final QueryExp broadcasterQuery = new BroadcasterQuery();
    private static final NotificationFilter creationFilter;
    private final NotificationListener creationListener = new NotificationListener(){

        public void handleNotification(Notification notification, Object object) {
            logger.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notification);
        }
    };
    private static final ClassLogger logger;
    private static final ObjectName delegateName;
    private final MBeanServer mBeanServer;
    private final ArrayQueue queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private boolean destroyed;
    static final String broadcasterClass;

    public static synchronized NotificationBuffer getNotificationBuffer(MBeanServer mBeanServer, Map map) {
        int n2 = 1000;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(ArrayNotificationBuffer.BUFFER_SIZE_PROPERTY);
                }
            });
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (RuntimeException runtimeException) {
            logger.warning("ServerNotifForwarder", "Can't use System property jmx.remote.x.buffer.size: " + runtimeException);
            logger.debug("ServerNotifForwarder", runtimeException);
        }
        int n3 = n2;
        try {
            n3 = (int)EnvHelp.getIntegerAttribute(map, BUFFER_SIZE_PROPERTY, n2, 0L, Integer.MAX_VALUE);
        }
        catch (RuntimeException runtimeException) {
            logger.warning("ServerNotifForwarder", "Can't determine queuesize (using default): " + runtimeException);
            logger.debug("ServerNotifForwarder", runtimeException);
        }
        ArrayNotificationBuffer arrayNotificationBuffer = (ArrayNotificationBuffer)mbsToBuffer.get(mBeanServer);
        if (arrayNotificationBuffer == null) {
            arrayNotificationBuffer = new ArrayNotificationBuffer(mBeanServer, n3);
            mbsToBuffer.put(mBeanServer, arrayNotificationBuffer);
        }
        ArrayNotificationBuffer arrayNotificationBuffer2 = arrayNotificationBuffer;
        arrayNotificationBuffer2.getClass();
        return arrayNotificationBuffer2.new ShareBuffer(n3);
    }

    public static synchronized void removeNotificationBuffer(MBeanServer mBeanServer) {
        mbsToBuffer.remove(mBeanServer);
    }

    synchronized void addSharer(ShareBuffer shareBuffer) {
        if (shareBuffer.getSize() > this.queueSize) {
            this.resize(shareBuffer.getSize());
        }
        this.sharers.add(shareBuffer);
    }

    synchronized void removeSharer(ShareBuffer shareBuffer) {
        this.sharers.remove(shareBuffer);
        if (this.sharers.isEmpty()) {
            this.dispose();
        } else {
            int n2 = 0;
            for (ShareBuffer shareBuffer2 : this.sharers) {
                int n3 = shareBuffer2.getSize();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (n2 < this.queueSize) {
                this.resize(n2);
            }
        }
    }

    private void resize(int n2) {
        if (n2 == this.queueSize) {
            return;
        }
        while (this.queue.size() > n2) {
            this.dropNotification();
        }
        this.queue.resize(n2);
        this.queueSize = n2;
    }

    private ArrayNotificationBuffer(MBeanServer mBeanServer, int n2) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "queueSize=" + n2);
        }
        if (mBeanServer == null || n2 < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mBeanServer;
        this.queueSize = n2;
        this.queue = new ArrayQueue(n2);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        this.createListeners();
        logger.trace("Constructor", "ends");
    }

    private synchronized boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        logger.trace("dispose", "starts");
        ArrayNotificationBuffer arrayNotificationBuffer = this;
        synchronized (arrayNotificationBuffer) {
            ArrayNotificationBuffer.removeNotificationBuffer(this.mBeanServer);
            this.disposed = true;
            this.notifyAll();
        }
        this.destroyListeners();
        logger.trace("dispose", "ends");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(Set set, long l2, long l3, int n2) throws InterruptedException {
        TargetedNotification[] targetedNotificationArray;
        logger.trace("fetchNotifications", "starts");
        if (l2 < 0L || this.isDisposed()) {
            ArrayNotificationBuffer arrayNotificationBuffer = this;
            synchronized (arrayNotificationBuffer) {
                return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
            }
        }
        if (set == null || l2 < 0L || l3 < 0L || n2 < 0) {
            logger.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        if (logger.debugOn()) {
            logger.trace("fetchNotifications", "listener-length=" + set.size() + "; startSeq=" + l2 + "; timeout=" + l3 + "; max=" + n2);
        }
        if (l2 > this.nextSequenceNumber()) {
            String string = "Start sequence number too big: " + l2 + " > " + this.nextSequenceNumber();
            logger.trace("fetchNotifications", string);
            throw new IllegalArgumentException(string);
        }
        long l4 = System.currentTimeMillis() + l3;
        if (l4 < 0L) {
            l4 = Long.MAX_VALUE;
        }
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "endTime=" + l4);
        }
        long l5 = -1L;
        long l6 = l2;
        ArrayList arrayList = new ArrayList();
        while (true) {
            NamedNotification namedNotification;
            logger.debug("fetchNotifications", "main loop starts");
            targetedNotificationArray = this;
            synchronized (targetedNotificationArray) {
                if (l5 < 0L) {
                    l5 = this.earliestSequenceNumber();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "earliestSeq=" + l5);
                    }
                    if (l6 < l5) {
                        l6 = l5;
                        logger.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    l5 = this.earliestSequenceNumber();
                }
                if (l6 < l5) {
                    logger.trace("fetchNotifications", "nextSeq=" + l6 + " < " + "earliestSeq=" + l5 + " so may have lost notifs");
                    break;
                }
                if (l6 < this.nextSequenceNumber()) {
                    namedNotification = this.notificationAt(l6);
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "candidate: " + namedNotification);
                        logger.debug("fetchNotifications", "nextSeq now " + l6);
                    }
                } else {
                    if (arrayList.size() > 0) {
                        logger.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long l7 = l4 - System.currentTimeMillis();
                    if (l7 <= 0L) {
                        logger.debug("fetchNotifications", "timeout");
                        break;
                    }
                    if (this.isDisposed()) {
                        if (logger.debugOn()) {
                            logger.debug("fetchNotifications", "dispose callled, no wait");
                        }
                        return new NotificationResult(this.earliestSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "wait(" + l7 + ")");
                    }
                    this.wait(l7);
                    continue;
                }
            }
            targetedNotificationArray = namedNotification.getObjectName();
            Notification notification = namedNotification.getNotification();
            ArrayList<TargetedNotification> arrayList2 = new ArrayList<TargetedNotification>();
            logger.debug("fetchNotifications", "applying filters to candidate");
            Set set2 = set;
            synchronized (set2) {
                for (ListenerInfo listenerInfo : set) {
                    ObjectName objectName = listenerInfo.getObjectName();
                    NotificationFilter notificationFilter = listenerInfo.getNotificationFilter();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "pattern=<" + objectName + ">; filter=" + notificationFilter);
                    }
                    if (!objectName.apply((ObjectName)targetedNotificationArray)) continue;
                    logger.debug("fetchNotifications", "pattern matches");
                    if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
                    logger.debug("fetchNotifications", "filter matches");
                    Integer n3 = listenerInfo.getListenerID();
                    TargetedNotification targetedNotification = new TargetedNotification(notification, n3);
                    arrayList2.add(targetedNotification);
                }
            }
            if (arrayList2.size() > 0) {
                if (n2 <= 0) {
                    logger.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --n2;
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "add: " + arrayList2);
                }
                arrayList.addAll(arrayList2);
            }
            ++l6;
        }
        int n4 = arrayList.size();
        targetedNotificationArray = new TargetedNotification[n4];
        arrayList.toArray(targetedNotificationArray);
        NotificationResult notificationResult = new NotificationResult(l5, l6, targetedNotificationArray);
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", notificationResult.toString());
        }
        logger.trace("fetchNotifications", "ends");
        return notificationResult;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification namedNotification) {
        if (logger.traceOn()) {
            logger.trace("addNotification", namedNotification.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            if (!logger.debugOn()) continue;
            logger.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(namedNotification);
        ++this.nextSequenceNumber;
        if (logger.debugOn()) {
            logger.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        }
        this.notifyAll();
    }

    private void dropNotification() {
        this.queue.remove(0);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long l2) {
        long l3 = l2 - this.earliestSequenceNumber;
        if (l3 < 0L || l3 > Integer.MAX_VALUE) {
            String string = "Bad sequence number: " + l2 + " (earliest " + this.earliestSequenceNumber + ")";
            logger.trace("notificationAt", string);
            throw new IllegalArgumentException(string);
        }
        return (NamedNotification)this.queue.get((int)l3);
    }

    private synchronized void createListeners() {
        Set set;
        logger.debug("createListeners", "starts");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(delegateName, ArrayNotificationBuffer.this.creationListener, creationFilter, null);
                    return null;
                }
            });
            logger.debug("createListeners", "added creationListener");
        }
        catch (Exception exception) {
            Exception exception2 = ArrayNotificationBuffer.extractException(exception);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Can't add listener to MBean server delegate: " + exception2);
            EnvHelp.initCause(illegalArgumentException, exception2);
            logger.fine("createListeners", "Can't add listener to MBean server delegate: " + exception2);
            logger.debug("createListeners", exception2);
            throw illegalArgumentException;
        }
        try {
            set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            logger.fine("createListeners", "Failed to query names: " + runtimeException);
            logger.debug("createListeners", runtimeException);
            throw runtimeException;
        }
        for (ObjectName objectName : set) {
            this.addBufferListener(objectName, this.queryBufferListener);
        }
        logger.debug("createListeners", "ends");
    }

    private void addBufferListener(final ObjectName objectName, final NotificationListener notificationListener) {
        if (logger.debugOn()) {
            logger.debug("addBufferListener", "" + objectName);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(objectName, notificationListener, null, (Object)objectName);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            logger.trace("addBufferListener", ArrayNotificationBuffer.extractException(exception));
        }
    }

    private synchronized void createdNotification(MBeanServerNotification mBeanServerNotification) {
        if (this.destroyed) {
            logger.trace("createNotification", "NotificationBuffer was destroyed");
            return;
        }
        if (!mBeanServerNotification.getType().equals("JMX.mbean.registered")) {
            logger.warning("createNotification", "bad type: " + mBeanServerNotification.getType());
            return;
        }
        final ObjectName objectName = mBeanServerNotification.getMBeanName();
        if (logger.debugOn()) {
            logger.debug("createdNotification", "for: " + objectName);
        }
        try {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ArrayNotificationBuffer.this.mBeanServer.isInstanceOf(objectName, broadcasterClass));
                }
            });
            if (!bl2.booleanValue()) {
                logger.debug("createdNotification", "not a NotificationBroadcaster");
                return;
            }
        }
        catch (Exception exception) {
            logger.trace("createdNotification", ArrayNotificationBuffer.extractException(exception));
            return;
        }
        this.addBufferListener(objectName, this.creationBufferListener);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(objectName, ArrayNotificationBuffer.this.queryBufferListener);
                    return null;
                }
            });
            logger.trace("createdNotification", "remove queryBufferListener worked!");
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = ArrayNotificationBuffer.extractException(privilegedActionException);
            if (exception instanceof ListenerNotFoundException) {
                logger.debug("createdNotification", "remove queryBufferListener got ListenerNotFoundException as expected");
            }
            logger.trace("createdNotification", exception);
        }
    }

    private synchronized void destroyListeners() {
        logger.debug("destroyListeners", "starts");
        this.destroyed = true;
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
            }
        });
        for (final ObjectName objectName : set) {
            if (logger.debugOn()) {
                logger.debug("destroyListeners", "remove listener from " + objectName);
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean bl2 = i2 == 0;
                final NotificationListener notificationListener = bl2 ? this.creationBufferListener : this.queryBufferListener;
                String string = bl2 ? "creationBufferListener" : "queryBufferListener";
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                            ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(objectName, notificationListener);
                            return null;
                        }
                    });
                    if (!logger.debugOn()) continue;
                    logger.debug("destroyListeners", "removed " + string);
                    continue;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = ArrayNotificationBuffer.extractException(privilegedActionException);
                    if (exception instanceof ListenerNotFoundException) {
                        if (!logger.debugOn()) continue;
                        logger.debug("destroyListeners", "ListenerNotFoundException for " + string + " (normal)");
                        continue;
                    }
                    logger.trace("destroyListeners", exception);
                }
            }
        }
        logger.debug("destroyListeners", "ends");
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    static {
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("JMX.mbean.registered");
        creationFilter = notificationFilterSupport;
        logger = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        try {
            delegateName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            RuntimeException runtimeException = new RuntimeException("Can't create delegate name: " + malformedObjectNameException);
            EnvHelp.initCause(runtimeException, malformedObjectNameException);
            logger.error("<init>", "Can't create delegate name: " + malformedObjectNameException);
            logger.debug("<init>", malformedObjectNameException);
            throw runtimeException;
        }
        broadcasterClass = NotificationBroadcaster.class.getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private BroadcasterQuery() {
        }

        public boolean apply(final ObjectName objectName) {
            final MBeanServer mBeanServer = QueryEval.getMBeanServer();
            try {
                Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstanceNotFoundException {
                        return new Boolean(mBeanServer.isInstanceOf(objectName, broadcasterClass));
                    }
                });
                if (logger.debugOn()) {
                    logger.debug("BroadcasterQuery", objectName + " -> " + bl2);
                }
                return bl2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                logger.debug("BroadcasterQuery", ArrayNotificationBuffer.extractException(privilegedActionException));
                return false;
            }
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            if (logger.debugOn()) {
                logger.debug("BufferListener.handleNotification", "notif=" + notification + "; handback=" + object);
            }
            ObjectName objectName = (ObjectName)object;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(objectName, notification));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName objectName, Notification notification) {
            this.sender = objectName;
            this.notification = notification;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int n2) {
            this.size = n2;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        public NotificationResult fetchNotifications(Set set, long l2, long l3, int n2) throws InterruptedException {
            ArrayNotificationBuffer arrayNotificationBuffer = ArrayNotificationBuffer.this;
            return arrayNotificationBuffer.fetchNotifications(set, l2, l3, n2);
        }

        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

