/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.types.basic;

import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.SymbolLookup;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.VtblAccess;

public abstract class BasicVtblAccess
implements VtblAccess {
    protected SymbolLookup symbolLookup;
    protected String[] dllNames;
    private Map typeToVtblMap = new HashMap();

    public BasicVtblAccess(SymbolLookup symbolLookup, String[] dllNames) {
        this.symbolLookup = symbolLookup;
        this.dllNames = dllNames;
    }

    public Address getVtblForType(Type type) {
        if (type == null) {
            return null;
        }
        Address addr = (Address)this.typeToVtblMap.get(type);
        if (addr != null) {
            return addr;
        }
        String vtblSymbol = this.vtblSymbolForType(type);
        if (vtblSymbol == null) {
            return null;
        }
        for (int i = 0; i < this.dllNames.length; ++i) {
            addr = this.symbolLookup.lookup(this.dllNames[i], vtblSymbol);
            if (addr == null) continue;
            this.typeToVtblMap.put(type, addr);
            return addr;
        }
        return null;
    }

    public void clearCaches() {
        this.typeToVtblMap.clear();
    }

    protected abstract String vtblSymbolForType(Type var1);
}

