/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.GnomeVfsWrapper;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.VFolderEditor;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;

public class UnixInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "unix.installedDesktopShortcut";
    private static final String INSTALLED_DIRECTORY_KEY = "unix.installedDirectoryFile";
    private static final String INSTALLED_GNOME_START_MENU_KEY = "unix.gnome.installedStartMenuShortcut";
    private static final String INSTALLED_UNINSTALL_KEY = "unix.gnome.installedUninstallShortcut";
    private static final String INSTALLED_RC_KEY = "unix.gnome.installedRCShortcut";
    private boolean replace = false;

    public String getAssociationPrintCommand(String string) {
        return null;
    }

    public String getAssociationOpenCommand(String string) {
        return Config.getJavawsCommand() + " " + string + " -open";
    }

    public void registerAssociationInternal(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Globals.isSystemCache()) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    public void unregisterAssociationInternal(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Globals.isSystemCache()) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        block18: {
            Trace.println((String)"install called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
            File file = null;
            ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
            boolean bl = shortcutDesc == null ? true : shortcutDesc.getDesktop();
            boolean bl2 = shortcutDesc == null ? true : shortcutDesc.getMenu();
            boolean bl3 = false;
            boolean bl4 = true;
            if (Globals.isSystemCache()) {
                bl = false;
                bl2 = false;
                bl3 = true;
            }
            try {
                String[] stringArray;
                if (!bl2 && !bl) break block18;
                try {
                    file = Cache.getCachedLaunchedFile(launchDesc.getCanonicalHome());
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
                if (file == null) {
                    bl4 = false;
                }
                if (bl && bl4) {
                    stringArray = this.createDesktopShortcut(launchDesc, file);
                    if (stringArray != null) {
                        localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, (String)stringArray);
                    } else {
                        bl4 = false;
                    }
                }
                if (bl2 && bl4) {
                    stringArray = this.createStartMenuShortcut(launchDesc, file, bl3);
                    if (stringArray[0] != null) {
                        localApplicationProperties.put(INSTALLED_GNOME_START_MENU_KEY, stringArray[0]);
                        if (stringArray[1] != null) {
                            localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, stringArray[1]);
                        }
                        if (stringArray[2] != null) {
                            localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, stringArray[2]);
                        }
                        if (stringArray[3] != null) {
                            localApplicationProperties.put(INSTALLED_RC_KEY, stringArray[3]);
                        }
                    } else {
                        bl4 = false;
                        this.uninstall(launchDesc, localApplicationProperties, bl);
                    }
                }
                if (bl4) {
                    localApplicationProperties.setLocallyInstalled(true);
                    UnixInstallHandler.save(localApplicationProperties);
                } else {
                    this.installFailed(launchDesc);
                }
            }
            finally {
                this.replace = false;
            }
        }
    }

    public String getDefaultIconPath() {
        return Config.getJavaHome() + File.separator + "lib" + File.separator + "javaws" + File.separator + "Java1.5.ico";
    }

    private String getIcon(LaunchDesc launchDesc) {
        String string = IcoEncoder.getIconPath(launchDesc);
        if (string == null) {
            string = this.getDefaultIconPath();
        }
        return string;
    }

    private String getRCIcon(RContentDesc rContentDesc, LaunchDesc launchDesc) {
        URL uRL = rContentDesc.getIcon();
        String string = null;
        if (uRL != null) {
            string = IcoEncoder.getIconPath(uRL, null);
        }
        if (string == null) {
            string = this.getIcon(launchDesc);
        }
        return string;
    }

    private String[] createStartMenuShortcut(LaunchDesc launchDesc, File file, boolean bl) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String[] stringArray = new String[5];
        String string = informationDesc.getTitle();
        String string2 = this.getIcon(launchDesc);
        String string3 = null;
        String string4 = "";
        String string5 = this.getDesktopEntryPath(bl);
        String string6 = this.getDirectoryEntryPath(bl);
        if (!bl) {
            if (informationDesc.supportsOfflineOperation() && shortcutDesc != null && !shortcutDesc.getOnline()) {
                string4 = "-offline";
            }
            Trace.println((String)("iconPath: " + string2), (TraceLevel)TraceLevel.BASIC);
            stringArray[0] = this.createDesktopFile(launchDesc, string, string2, string5, file.getAbsolutePath(), string4);
            stringArray[1] = this.createDirectoryFile(launchDesc, string2, string6);
            stringArray[2] = this.addUninstallShortcut() ? this.createDesktopFile(launchDesc, ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (String)string), string2, string5, file.getAbsolutePath(), "-uninstall") : null;
            string3 = this.getFolderName(launchDesc);
            Trace.println((String)("folderName: " + string3), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("directoryFileName: " + stringArray[1]), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("desktopFileName: " + stringArray[0]), (TraceLevel)TraceLevel.BASIC);
            VFolderEditor.updateVFolderInfo(string3, stringArray[1], stringArray[0], bl, false);
            RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
            String string7 = this.getFolderName(launchDesc);
            if (rContentDescArray != null) {
                StringBuffer stringBuffer = new StringBuffer(512 * rContentDescArray.length);
                for (int i = 0; i < rContentDescArray.length; ++i) {
                    String string8;
                    URL uRL = rContentDescArray[i].getHref();
                    if (uRL != null && uRL.toString().endsWith(".jnlp") || (string8 = this.createRCDesktopFile(rContentDescArray[i], string7, this.getRCIcon(rContentDescArray[i], launchDesc), string5)) == null) continue;
                    stringBuffer.append(string8);
                    VFolderEditor.updateVFolderInfo(string3, stringArray[1], string8, bl, false);
                    stringBuffer.append(File.pathSeparator);
                }
                stringArray[3] = stringBuffer.toString();
            } else {
                stringArray[3] = null;
            }
            if (stringArray[2] != null) {
                Trace.println((String)("UNINSTALL desktopFileName: " + stringArray[2]), (TraceLevel)TraceLevel.BASIC);
                VFolderEditor.updateVFolderInfo(string3, stringArray[1], stringArray[2], bl, false);
            }
        }
        return stringArray;
    }

    private String getFolderName(LaunchDesc launchDesc) {
        String string = null;
        if (launchDesc.getInformation().getShortcut() != null) {
            string = launchDesc.getInformation().getShortcut().getSubmenu();
        }
        if (string == null) {
            string = launchDesc.getInformation().getTitle();
        }
        return string;
    }

    private String createDesktopShortcut(LaunchDesc launchDesc, File file) {
        InformationDesc informationDesc = launchDesc.getInformation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        String string = informationDesc.getTitle();
        String string2 = this.getIcon(launchDesc);
        String string3 = "";
        Trace.println((String)("iconPath: " + string2), (TraceLevel)TraceLevel.TEMP);
        if (informationDesc.supportsOfflineOperation() && shortcutDesc != null && !shortcutDesc.getOnline()) {
            string3 = "-offline";
        }
        return this.createDesktopFile(launchDesc, string, string2, this.getGnomeDesktopPath(), file.getAbsolutePath(), string3);
    }

    private String getGnomeDesktopPath() {
        return System.getProperty("user.home") + File.separator + ".gnome-desktop";
    }

    private String getDesktopEntryPath(boolean bl) {
        if (bl) {
            return File.separator + "usr" + File.separator + "share" + File.separator + "applications";
        }
        return System.getProperty("user.home") + File.separator + ".gnome2" + File.separator + "vfolders" + File.separator + "applications";
    }

    private String getDirectoryEntryPath(boolean bl) {
        if (bl) {
            return File.separator + "usr" + File.separator + "share" + File.separator + "gnome" + File.separator + "vfolders";
        }
        return System.getProperty("user.home") + File.separator + ".gnome2" + File.separator + "vfolders" + File.separator + "applications";
    }

    private String getRCCommand(URL uRL) {
        String string;
        File file = Cache.getCachedFile(uRL);
        String string2 = "";
        if (uRL.toString().endsWith(".jnlp")) {
            return Config.getJavawsCommand() + " " + uRL.toString();
        }
        if (file != null) {
            string = file.getAbsolutePath();
            String string3 = string.substring(string.lastIndexOf("."), string.length());
            if (this.isAssociationSupported()) {
                Action action;
                AssociationService associationService = new AssociationService();
                Association association = associationService.getFileExtensionAssociation(string3);
                if (association != null && (action = association.getActionByVerb("open")) != null) {
                    String string4 = action.getCommand();
                    StringTokenizer stringTokenizer = new StringTokenizer(string4);
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    string2 = string4;
                }
                this.associationCompleted();
            }
            if (string2 == "") {
                string2 = Config.getProperty((String)"deployment.browser.path");
            }
        } else {
            string = uRL.toString();
            string2 = Config.getProperty((String)"deployment.browser.path");
        }
        return string2 + " " + string;
    }

    private String createRCDesktopFile(RContentDesc rContentDesc, String string, String string2, String string3) {
        URL uRL = rContentDesc.getHref();
        String string4 = rContentDesc.getTitle();
        String string5 = "[Desktop Entry]\nEncoding=UTF-8\nVersion=1.0\nType=Application\nExec=" + this.getRCCommand(uRL) + "\n" + "Icon=" + string2 + "\n" + "Terminal=false\n" + "Name=" + string4 + "\n" + "Comment=" + rContentDesc.getDescription() + "\n" + "Categories=Application;" + string + "\n";
        new File(string3).mkdirs();
        String string6 = string3 + File.separator + string4 + ".desktop";
        File file = new File(string6);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(string5);
            printWriter.close();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
        return string6;
    }

    private String createDesktopFile(LaunchDesc launchDesc, String string, String string2, String string3, String string4, String string5) {
        InformationDesc informationDesc = launchDesc.getInformation();
        String string6 = this.getFolderName(launchDesc);
        if (string5 == null) {
            string5 = "";
        } else if (string5.length() > 0 && !string5.endsWith(" ")) {
            string5 = string5 + " ";
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(string3).append(File.separator).append(string).append(".desktop");
        Trace.println((String)("desktopFilePath: " + stringBuffer), (TraceLevel)TraceLevel.BASIC);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            if (!this.replace) {
                this.replace = UnixInstallHandler.shouldInstallOverExisting(launchDesc);
                if (this.replace) {
                    return file.getAbsolutePath();
                }
            }
        } else {
            file.getParentFile().mkdirs();
        }
        StringBuffer stringBuffer2 = new StringBuffer(4096);
        stringBuffer2.append("[Desktop Entry]\n");
        stringBuffer2.append("Encoding=UTF-8\n");
        stringBuffer2.append("Version=1.0\n");
        stringBuffer2.append("Type=Application\n");
        stringBuffer2.append("Exec=").append(Config.getJavawsCommand()).append(" ").append(string5).append(string4).append("\n");
        stringBuffer2.append("Icon=").append(string2).append("\n");
        stringBuffer2.append("Terminal=false\n");
        stringBuffer2.append("Name=").append(string).append("\n");
        stringBuffer2.append("Comment=").append(informationDesc.getDescription(1)).append("\n");
        stringBuffer2.append("Categories=Application;").append(string6).append("\n");
        try {
            Trace.println((String)("fileContents: " + stringBuffer2), (TraceLevel)TraceLevel.BASIC);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(stringBuffer2.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
        return file.getAbsolutePath();
    }

    private String createDirectoryFile(LaunchDesc launchDesc, String string, String string2) {
        InformationDesc informationDesc = launchDesc.getInformation();
        String string3 = this.getFolderName(launchDesc);
        String string4 = string2 + File.separator + string3 + ".directory";
        Trace.println((String)("directoryFilePath: " + string4), (TraceLevel)TraceLevel.BASIC);
        File file = new File(string4);
        String string5 = "[Desktop Entry]\nName=" + string3 + "\n" + "Comment=" + informationDesc.getDescription(1) + "\n" + "Icon=" + string + "\n" + "Type=Directory;\n";
        Trace.println((String)("fileContents: " + string5), (TraceLevel)TraceLevel.BASIC);
        try {
            new File(string2).mkdirs();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.print(string5);
            printWriter.close();
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
            return null;
        }
        return string4;
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                DialogFactory.showErrorDialog((String)ResourceManager.getString((String)"install.installFailed", (String)launchDesc.getInformation().getTitle().trim()), (String)ResourceManager.getString((String)"install.installFailedTitle"));
            }
        };
        UnixInstallHandler.invokeRunnable(runnable);
    }

    public void uninstall(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        String string;
        boolean bl2 = false;
        if (Globals.isSystemCache()) {
            bl = false;
            bl2 = true;
        }
        Trace.println((String)"uninstall called in UnixInstallHandler", (TraceLevel)TraceLevel.BASIC);
        if (bl && (string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            new File(string).delete();
            Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_GNOME_START_MENU_KEY)) != null) {
            new File(string).delete();
            Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_GNOME_START_MENU_KEY, null);
        }
        if ((string = localApplicationProperties.get(INSTALLED_UNINSTALL_KEY)) != null) {
            new File(string).delete();
            Trace.println((String)("file removed: " + string), (TraceLevel)TraceLevel.BASIC);
            localApplicationProperties.put(INSTALLED_UNINSTALL_KEY, null);
        }
        String string2 = localApplicationProperties.get(INSTALLED_DIRECTORY_KEY);
        string = localApplicationProperties.get(INSTALLED_RC_KEY);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                new File(string3).delete();
                Trace.println((String)("file removed: " + string3), (TraceLevel)TraceLevel.BASIC);
                if (string2 == null) continue;
                String string4 = string3.substring(0, string3.length() - 8);
                VFolderEditor.updateVFolderInfo(this.getFolderName(launchDesc), string2, string4, bl2, true);
            }
            localApplicationProperties.put(INSTALLED_RC_KEY, null);
        }
        if (string2 != null) {
            VFolderEditor.updateVFolderInfo(this.getFolderName(launchDesc), string2, launchDesc.getInformation().getTitle(), bl2, true);
            if (!new File(string2).exists()) {
                localApplicationProperties.put(INSTALLED_DIRECTORY_KEY, null);
            }
        }
        localApplicationProperties.setLocallyInstalled(false);
        UnixInstallHandler.save(localApplicationProperties);
    }

    public boolean isLocalInstallSupported() {
        return Config.getInstance().isLocalInstallSupported();
    }

    public boolean isAssociationSupported() {
        return GnomeVfsWrapper.openGNOMELibrary() && GnomeVfsWrapper.initGNOMELibrary();
    }

    public void associationCompleted() {
        if (Config.getOSName() == "SunOS") {
            GnomeVfsWrapper.closeGNOMELibrary();
        }
    }
}

