/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeploySSLCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SSLRootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Trace;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class X509DeployTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertStore rootStore = null;
    private static CertStore sslRootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserSSLRootStore = null;
    private static boolean isBrowserSSLRootStoreLoaded = false;

    public static void reset() {
        rootStore = RootCertStore.getInstance();
        sslRootStore = new SSLRootCertStore();
        permanentStore = new DeploySSLCertStore();
        sessionStore = new SessionCertStore();
        deniedStore = new DeniedCertStore();
        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
            Service service = ServiceManager.getService();
            browserSSLRootStore = service.getBrowserSSLRootCertStore();
            isBrowserSSLRootStoreLoaded = false;
        }
    }

    public X509DeployTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagerArray[0];
    }

    public synchronized void checkClientTrusted(final X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n = 1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!(rootStore.verify(x509CertificateArray[i]) || sslRootStore.verify(x509CertificateArray[i]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[i]))) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    try {
                        final boolean bl3 = bl;
                        final boolean bl4 = bl2;
                        n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return DeploySysRun.execute(new DeploySysAction(){

                                    public Object execute() throws Exception {
                                        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(x509CertificateArray, 0, x509CertificateArray.length, bl3, bl4);
                                        trustDeciderDialog.setHttpsDialog(true);
                                        return new Integer(trustDeciderDialog.DoModal());
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception exception) {
                        Trace.ignoredException(exception);
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                    n = 0;
                }
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Java couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(final X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.trustManager == null) {
            throw new IllegalStateException("TrustManager should not be null");
        }
        int n = 1;
        try {
            rootStore.load();
            sslRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (browserSSLRootStore != null && !isBrowserSSLRootStoreLoaded) {
                browserSSLRootStore.load();
                isBrowserSSLRootStoreLoaded = true;
            }
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!(rootStore.verify(x509CertificateArray[i]) || sslRootStore.verify(x509CertificateArray[i]) || browserSSLRootStore != null && browserSSLRootStore.verify(x509CertificateArray[i]))) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    try {
                        final boolean bl3 = bl;
                        final boolean bl4 = bl2;
                        n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return DeploySysRun.execute(new DeploySysAction(){

                                    public Object execute() throws Exception {
                                        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(x509CertificateArray, 0, x509CertificateArray.length, bl3, bl4);
                                        trustDeciderDialog.setHttpsDialog(true);
                                        return new Integer(trustDeciderDialog.DoModal());
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception exception) {
                        Trace.ignoredException(exception);
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                    n = 0;
                }
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Java couldn't trust Server");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    static {
        X509DeployTrustManager.reset();
    }
}

