/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ValueContainer;

public class LocalVariableImpl
extends MirrorImpl
implements LocalVariable,
ValueContainer {
    private final Method method;
    private final int slot;
    private final Location scopeStart;
    private final Location scopeEnd;
    private final String name;
    private final String signature;
    private String genericSignature = null;

    LocalVariableImpl(VirtualMachine virtualMachine, Method method, int n, Location location, Location location2, String string, String string2, String string3) {
        super(virtualMachine);
        this.method = method;
        this.slot = n;
        this.scopeStart = location;
        this.scopeEnd = location2;
        this.name = string;
        this.signature = string2;
        this.genericSignature = string3 != null && string3.length() > 0 ? string3 : null;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LocalVariableImpl) {
            LocalVariableImpl localVariableImpl = (LocalVariableImpl)object;
            return this.slot() == localVariableImpl.slot() && this.scopeStart != null && ((Object)this.scopeStart).equals(localVariableImpl.scopeStart) && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return (((Object)this.scopeStart).hashCode() << 4) + this.slot();
    }

    public int compareTo(LocalVariable localVariable) {
        LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
        int n = this.scopeStart.compareTo(localVariableImpl.scopeStart);
        if (n == 0) {
            n = this.slot() - localVariableImpl.slot();
        }
        return n;
    }

    public String name() {
        return this.name;
    }

    public String typeName() {
        JNITypeParser jNITypeParser = new JNITypeParser(this.signature);
        return jNITypeParser.typeName();
    }

    public Type type() throws ClassNotLoadedException {
        return this.findType(this.signature());
    }

    public Type findType(String string) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.method.declaringType();
        return referenceTypeImpl.findType(string);
    }

    public String signature() {
        return this.signature;
    }

    public String genericSignature() {
        return this.genericSignature;
    }

    public boolean isVisible(StackFrame stackFrame) {
        this.validateMirror(stackFrame);
        Method method = stackFrame.location().method();
        if (!((Object)method).equals(this.method)) {
            throw new IllegalArgumentException("frame method different than variable's method");
        }
        if (method.isNative()) {
            return false;
        }
        return this.scopeStart.compareTo(stackFrame.location()) <= 0 && this.scopeEnd.compareTo(stackFrame.location()) >= 0;
    }

    public boolean isArgument() {
        try {
            MethodImpl methodImpl = (MethodImpl)this.scopeStart.method();
            return this.slot < methodImpl.argSlotCount();
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InternalException();
        }
    }

    int slot() {
        return this.slot;
    }

    boolean hides(LocalVariable localVariable) {
        LocalVariableImpl localVariableImpl = (LocalVariableImpl)localVariable;
        if (!((Object)this.method).equals(localVariableImpl.method) || !this.name.equals(localVariableImpl.name)) {
            return false;
        }
        return this.scopeStart.compareTo(localVariableImpl.scopeStart) > 0;
    }

    public String toString() {
        return this.name() + " in " + this.method.toString() + "@" + this.scopeStart.toString();
    }
}

