/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWriter
extends ClassFile {
    protected static final Context.Key<ClassWriter> classWriterKey = new Context.Key();
    private final Symtab syms;
    private final Options options;
    public File outDir = null;
    private boolean verbose;
    private boolean scramble;
    private boolean scrambleAll;
    private boolean retrofit;
    private boolean emitSourceFile;
    private boolean genCrt;
    boolean allowVariance;
    boolean debugstackmap;
    private Target target;
    private Source source;
    private Types types;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    ByteBuffer sigbuf = new ByteBuffer();
    Pool pool;
    Set<Symbol.ClassSymbol> innerClasses;
    ListBuffer<Symbol.ClassSymbol> innerClassesQueue;
    private final Log log;
    private final Name.Table names;
    private final boolean dumpClassModifiers;
    private final boolean dumpFieldModifiers;
    private final boolean dumpInnerClassModifiers;
    private final boolean dumpMethodModifiers;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    AttributeWriter awriter = new AttributeWriter();

    public static ClassWriter instance(Context context) {
        ClassWriter classWriter = context.get(classWriterKey);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    private ClassWriter(Context context) {
        String string;
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
        this.verbose = this.options.get("-verbose") != null;
        this.scramble = this.options.get("-scramble") != null;
        this.scrambleAll = this.options.get("-scrambleAll") != null;
        this.retrofit = this.options.get("-retrofit") != null;
        this.genCrt = this.options.get("-Xjcov") != null;
        Source source = Source.instance(context);
        this.debugstackmap = this.options.get("debugstackmap") != null;
        this.emitSourceFile = this.options.get("-g:") == null || this.options.get("-g:source") != null;
        String string2 = (String)this.options.get("-d");
        if (string2 != null) {
            this.outDir = new File(string2);
        }
        this.dumpClassModifiers = (string = (String)this.options.get("dumpmodifiers")) != null && string.indexOf(99) != -1;
        this.dumpFieldModifiers = string != null && string.indexOf(102) != -1;
        this.dumpInnerClassModifiers = string != null && string.indexOf(105) != -1;
        this.dumpMethodModifiers = string != null && string.indexOf(109) != -1;
    }

    public static String flagNames(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        long l2 = l & 0xFFFL;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                stringBuffer.append(" " + flagName[n]);
            }
            l2 >>= 1;
            ++n;
        }
        return stringBuffer.toString();
    }

    void putChar(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 & 0xFF);
    }

    void putInt(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 24 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byteBuffer.elems[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 3] = (byte)(n2 & 0xFF);
    }

    void assembleSig(Type type) {
        block0 : switch (type.tag) {
            case 1: {
                this.sigbuf.appendByte(66);
                break;
            }
            case 3: {
                this.sigbuf.appendByte(83);
                break;
            }
            case 2: {
                this.sigbuf.appendByte(67);
                break;
            }
            case 4: {
                this.sigbuf.appendByte(73);
                break;
            }
            case 5: {
                this.sigbuf.appendByte(74);
                break;
            }
            case 6: {
                this.sigbuf.appendByte(70);
                break;
            }
            case 7: {
                this.sigbuf.appendByte(68);
                break;
            }
            case 8: {
                this.sigbuf.appendByte(90);
                break;
            }
            case 9: {
                this.sigbuf.appendByte(86);
                break;
            }
            case 10: {
                this.sigbuf.appendByte(76);
                this.assembleClassSig(type);
                this.sigbuf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                this.sigbuf.appendByte(91);
                this.assembleSig(arrayType.elemtype);
                break;
            }
            case 12: {
                Type.MethodType methodType = (Type.MethodType)type;
                this.sigbuf.appendByte(40);
                this.assembleSig(methodType.argtypes);
                this.sigbuf.appendByte(41);
                this.assembleSig(methodType.restype);
                if (!this.hasTypeVar(methodType.thrown)) break;
                List<Type> list = methodType.thrown;
                while (list.nonEmpty()) {
                    this.sigbuf.appendByte(94);
                    this.assembleSig((Type)list.head);
                    list = list.tail;
                }
                break;
            }
            case 15: {
                Type.ArgumentType argumentType = (Type.ArgumentType)type;
                switch (argumentType.kind) {
                    case SUPER: {
                        this.sigbuf.appendByte(45);
                        this.assembleSig(argumentType.type);
                        break block0;
                    }
                    case EXTENDS: {
                        this.sigbuf.appendByte(43);
                        this.assembleSig(argumentType.type);
                        break block0;
                    }
                    case UNBOUND: {
                        this.sigbuf.appendByte(42);
                        break block0;
                    }
                }
                throw new AssertionError((Object)argumentType.kind);
            }
            case 14: {
                this.sigbuf.appendByte(84);
                this.sigbuf.appendName(type.tsym.name);
                this.sigbuf.appendByte(59);
                break;
            }
            case 16: {
                Type.ForAll forAll = (Type.ForAll)type;
                this.assembleParamsSig(forAll.tvars);
                this.assembleSig(forAll.qtype);
                break;
            }
            case 22: 
            case 23: {
                this.assembleSig(this.types.erasure(((UninitializedType)type).qtype));
                break;
            }
            default: {
                throw new AssertionError((Object)("typeSig " + type.tag));
            }
        }
    }

    boolean hasTypeVar(List<Type> list) {
        while (list.nonEmpty()) {
            if (((Type)list.head).tag == 14) {
                return true;
            }
            list = list.tail;
        }
        return false;
    }

    void assembleClassSig(Type type) {
        Type.ClassType classType = (Type.ClassType)type;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
        this.enterInner(classSymbol);
        Type type2 = classType.outer();
        if (type2.allparams().nonEmpty()) {
            boolean bl = classSymbol.owner.kind == 16 || classSymbol.name == this.names.empty;
            this.assembleClassSig(bl ? this.types.erasure(type2) : type2);
            this.sigbuf.appendByte(46);
            assert (classSymbol.flatname.startsWith(classSymbol.owner.enclClass().flatname));
            this.sigbuf.appendName(bl ? classSymbol.flatname.subName(classSymbol.owner.enclClass().flatname.len + 1, classSymbol.flatname.len) : classSymbol.name);
        } else {
            this.sigbuf.appendBytes(ClassWriter.externalize(classSymbol.flatname));
        }
        if (classType.typarams().nonEmpty()) {
            this.sigbuf.appendByte(60);
            this.assembleSig(classType.typarams());
            this.sigbuf.appendByte(62);
        }
    }

    void assembleSig(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            this.assembleSig((Type)list2.head);
            list2 = list2.tail;
        }
    }

    void assembleParamsSig(List<Type> list) {
        this.sigbuf.appendByte(60);
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            Type.TypeVar typeVar = (Type.TypeVar)list2.head;
            this.sigbuf.appendName(typeVar.tsym.name);
            List<Type> list3 = this.types.getBounds(typeVar);
            if ((((Type)list3.head).tsym.flags() & 0x200L) != 0L) {
                this.sigbuf.appendByte(58);
            }
            List<Type> list4 = list3;
            while (list4.nonEmpty()) {
                this.sigbuf.appendByte(58);
                this.assembleSig((Type)list4.head);
                list4 = list4.tail;
            }
            list2 = list2.tail;
        }
        this.sigbuf.appendByte(62);
    }

    Name typeSig(Type type) {
        assert (this.sigbuf.length == 0);
        this.assembleSig(type);
        Name name = this.sigbuf.toName(this.names);
        this.sigbuf.reset();
        return name;
    }

    public Name xClassName(Type type) {
        if (type.tag == 10) {
            return this.names.fromUtf(ClassWriter.externalize(type.tsym.flatName()));
        }
        if (type.tag == 11) {
            return this.typeSig(this.types.erasure(type));
        }
        throw new AssertionError((Object)"xClassName");
    }

    void writePool(Pool pool) throws PoolOverflow, StringOverflow {
        int n = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        for (int i = 1; i < pool.pp; ++i) {
            Object object;
            Object object2 = pool.pool[i];
            assert (object2 != null);
            if (object2 instanceof Pool.Method) {
                object2 = ((Pool.Method)object2).m;
            } else if (object2 instanceof Pool.Variable) {
                object2 = ((Pool.Variable)object2).v;
            }
            if (object2 instanceof Symbol.MethodSymbol) {
                object = (Symbol.MethodSymbol)object2;
                this.poolbuf.appendByte((((Symbol.MethodSymbol)object).owner.flags() & 0x200L) != 0L ? 11 : 10);
                this.poolbuf.appendChar(pool.put(((Symbol.MethodSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Symbol.VarSymbol) {
                object = (Symbol.VarSymbol)object2;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(((Symbol.VarSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Name) {
                this.poolbuf.appendByte(1);
                object = ((Name)object2).toUtf();
                this.poolbuf.appendChar(((Object)object).length);
                this.poolbuf.appendBytes((byte[])object, 0, ((Object)object).length);
                if (((Object)object).length <= 65535) continue;
                throw new StringOverflow(object2.toString());
            }
            if (object2 instanceof Symbol.ClassSymbol) {
                object = (Symbol.ClassSymbol)object2;
                if (((Symbol.ClassSymbol)object).owner.kind == 2) {
                    pool.put(((Symbol.ClassSymbol)object).owner);
                }
                this.poolbuf.appendByte(7);
                if (((Symbol.ClassSymbol)object).type.tag == 11) {
                    this.poolbuf.appendChar(pool.put(this.typeSig(((Symbol.ClassSymbol)object).type)));
                    continue;
                }
                this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(((Symbol.ClassSymbol)object).flatname))));
                this.enterInner((Symbol.ClassSymbol)object);
                continue;
            }
            if (object2 instanceof ClassFile.NameAndType) {
                object = (ClassFile.NameAndType)object2;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(((ClassFile.NameAndType)object).name));
                this.poolbuf.appendChar(pool.put(this.typeSig(((ClassFile.NameAndType)object).type)));
                continue;
            }
            if (object2 instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)object2);
                continue;
            }
            if (object2 instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)object2);
                ++i;
                continue;
            }
            if (object2 instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)object2).floatValue());
                continue;
            }
            if (object2 instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)object2);
                ++i;
                continue;
            }
            if (object2 instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(this.names.fromString((String)object2)));
                continue;
            }
            if (object2 instanceof Type) {
                object = (Type)object2;
                if (((Type)object).tag == 10) {
                    this.enterInner((Symbol.ClassSymbol)((Type)object).tsym);
                }
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName((Type)object)));
                continue;
            }
            assert (false) : "writePool " + object2;
        }
        if (pool.pp > 65535) {
            throw new PoolOverflow();
        }
        this.putChar(this.poolbuf, n, pool.pp);
    }

    Name fieldName(Symbol symbol) {
        if (this.scramble && (symbol.flags() & 2L) != 0L || this.scrambleAll && (symbol.flags() & 5L) == 0L) {
            return this.names.fromString("_$" + symbol.name.index);
        }
        return symbol.name;
    }

    ClassFile.NameAndType nameType(Symbol symbol) {
        return new ClassFile.NameAndType(this.fieldName(symbol), this.retrofit ? symbol.erasure(this.types) : symbol.externalType(this.types));
    }

    int writeAttr(Name name) {
        this.databuf.appendChar(this.pool.put(name));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int n, int n2) {
        this.putChar(this.databuf, n - 2, n2);
    }

    int writeEnclosingMethodAttribute(Symbol.ClassSymbol classSymbol) {
        if (!this.target.hasEnclosingMethodAttribute() || classSymbol.owner.kind != 16 && classSymbol.name != this.names.empty) {
            return 0;
        }
        int n = this.writeAttr(this.names.EnclosingMethod);
        Symbol.ClassSymbol classSymbol2 = classSymbol.owner.enclClass();
        Symbol.MethodSymbol methodSymbol = classSymbol.owner.type == null || classSymbol.owner.kind != 16 ? null : (Symbol.MethodSymbol)classSymbol.owner;
        this.databuf.appendChar(this.pool.put(classSymbol2));
        this.databuf.appendChar(methodSymbol == null ? 0 : this.pool.put(this.nameType(classSymbol.owner)));
        this.endAttr(n);
        return 1;
    }

    int writeFlagAttrs(long l) {
        int n;
        int n2 = 0;
        if ((l & 0x20000L) != 0L) {
            n = this.writeAttr(this.names.Deprecated);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            n = this.writeAttr(this.names.Enum);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            n = this.writeAttr(this.names.Synthetic);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x80000000L) != 0L && !this.target.useBridgeFlag()) {
            n = this.writeAttr(this.names.Bridge);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x400000000L) != 0L && !this.target.useVarargsFlag()) {
            n = this.writeAttr(this.names.Varargs);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            n = this.writeAttr(this.names.Annotation);
            this.endAttr(n);
            ++n2;
        }
        return n2;
    }

    int writeMemberAttrs(Symbol symbol) {
        int n = this.writeFlagAttrs(symbol.flags());
        long l = symbol.flags();
        if (this.source.allowGenerics() && (l & 0x80001000L) != 4096L && (l & 0x20000000L) == 0L && (!this.types.isSameType(symbol.type, symbol.erasure(this.types)) || this.hasTypeVar(symbol.type.thrown()))) {
            int n2 = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(symbol.type)));
            this.endAttr(n2);
            ++n;
        }
        return n += this.writeJavaAnnotations(symbol.attributes());
    }

    int writeParameterAttrs(Symbol.MethodSymbol methodSymbol) {
        ListBuffer<Attribute.Compound> listBuffer;
        boolean bl = false;
        boolean bl2 = false;
        if (methodSymbol.params != null) {
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                for (Attribute.Compound object : varSymbol.attributes()) {
                    switch (this.getRetention(object.type.tsym)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            bl2 = true;
                            break;
                        }
                        case RUNTIME: {
                            bl = true;
                            break;
                        }
                    }
                }
            }
        }
        int n = 0;
        if (bl) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleParameterAnnotations);
            this.databuf.appendByte(methodSymbol.params.length());
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                listBuffer = new ListBuffer<Attribute.Compound>();
                for (Attribute.Compound compound : varSymbol.attributes()) {
                    if (this.getRetention(compound.type.tsym) != RetentionPolicy.RUNTIME) continue;
                    listBuffer.append(compound);
                }
                this.databuf.appendChar(listBuffer.length());
                for (Attribute.Compound compound : listBuffer) {
                    this.writeCompoundAttribute(compound);
                }
            }
            this.endAttr(n2);
            ++n;
        }
        if (bl2) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleParameterAnnotations);
            this.databuf.appendByte(methodSymbol.params.length());
            for (Symbol.VarSymbol varSymbol : methodSymbol.params) {
                listBuffer = new ListBuffer();
                for (Attribute.Compound compound : varSymbol.attributes()) {
                    if (this.getRetention(compound.type.tsym) != RetentionPolicy.CLASS) continue;
                    listBuffer.append(compound);
                }
                this.databuf.appendChar(listBuffer.length());
                for (Attribute.Compound compound : listBuffer) {
                    this.writeCompoundAttribute(compound);
                }
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    int writeJavaAnnotations(List<Attribute.Compound> list) {
        if (list.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.Compound> listBuffer2 = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound compound : list) {
            switch (this.getRetention(compound.type.tsym)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    listBuffer2.append(compound);
                    break;
                }
                case RUNTIME: {
                    listBuffer.append(compound);
                    break;
                }
            }
        }
        int n = 0;
        if (listBuffer.length() != 0) {
            int n2 = this.writeAttr(this.names.RuntimeVisibleAnnotations);
            this.databuf.appendChar(listBuffer.length());
            for (Attribute.Compound compound : listBuffer) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n2);
            ++n;
        }
        if (listBuffer2.length() != 0) {
            int n3 = this.writeAttr(this.names.RuntimeInvisibleAnnotations);
            this.databuf.appendChar(listBuffer2.length());
            for (Attribute.Compound compound : listBuffer2) {
                this.writeCompoundAttribute(compound);
            }
            this.endAttr(n3);
            ++n;
        }
        return n;
    }

    RetentionPolicy getRetention(Symbol.TypeSymbol typeSymbol) {
        Attribute attribute;
        RetentionPolicy retentionPolicy = RetentionPolicy.CLASS;
        Attribute.Compound compound = typeSymbol.attribute(this.syms.retentionType.tsym);
        if (compound != null && (attribute = compound.member(this.names.value)) != null && attribute instanceof Attribute.Enum) {
            Name name = ((Attribute.Enum)attribute).value.name;
            if (name == this.names.SOURCE) {
                retentionPolicy = RetentionPolicy.SOURCE;
            } else if (name == this.names.CLASS) {
                retentionPolicy = RetentionPolicy.CLASS;
            } else if (name == this.names.RUNTIME) {
                retentionPolicy = RetentionPolicy.RUNTIME;
            }
        }
        return retentionPolicy;
    }

    void writeCompoundAttribute(Attribute.Compound compound) {
        this.databuf.appendChar(this.pool.put(this.typeSig(compound.type)));
        this.databuf.appendChar(compound.values.length());
        for (Pair<Symbol.MethodSymbol, Attribute> pair : compound.values) {
            this.databuf.appendChar(this.pool.put(((Symbol.MethodSymbol)pair.fst).name));
            ((Attribute)pair.snd).accept(this.awriter);
        }
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        assert ((classSymbol.flags() & 0x1000000L) == 0L);
        if (classSymbol.type.tag != 10) {
            return;
        }
        if (!(this.pool == null || classSymbol.owner.kind == 1 || this.innerClasses != null && this.innerClasses.contains(classSymbol))) {
            if (classSymbol.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)classSymbol.owner);
            }
            this.pool.put(classSymbol);
            this.pool.put(classSymbol.name);
            if (this.innerClasses == null) {
                this.innerClasses = new HashSet<Symbol.ClassSymbol>();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(this.names.InnerClasses);
            }
            this.innerClasses.add(classSymbol);
            this.innerClassesQueue.append(classSymbol);
        }
    }

    void writeInnerClasses() {
        int n = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List<Symbol.ClassSymbol> list = this.innerClassesQueue.toList();
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)list.head;
            char c = (char)this.adjustFlags(classSymbol.flags_field);
            if (this.dumpInnerClassModifiers) {
                this.log.errWriter.println("INNERCLASS  " + classSymbol.name);
                this.log.errWriter.println("---" + ClassWriter.flagNames(c));
            }
            this.databuf.appendChar(this.pool.get(classSymbol));
            this.databuf.appendChar(classSymbol.owner.kind == 2 ? this.pool.get(classSymbol.owner) : 0);
            this.databuf.appendChar(classSymbol.name.len != 0 ? this.pool.get(classSymbol.name) : 0);
            this.databuf.appendChar(c);
            list = list.tail;
        }
        this.endAttr(n);
    }

    void writeField(Symbol.VarSymbol varSymbol) {
        int n = this.adjustFlags(varSymbol.flags());
        this.databuf.appendChar(n);
        if (this.dumpFieldModifiers) {
            this.log.errWriter.println("FIELD  " + this.fieldName(varSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(varSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(varSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(varSymbol.erasure(this.types))));
        int n2 = this.beginAttrs();
        int n3 = 0;
        if (varSymbol.constValue != null) {
            int n4 = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.pool.put(varSymbol.constValue));
            this.endAttr(n4);
            ++n3;
        }
        this.endAttrs(n2, n3 += this.writeMemberAttrs(varSymbol));
    }

    void writeMethod(Symbol.MethodSymbol methodSymbol) {
        int n;
        List<Type> list;
        int n2 = this.adjustFlags(methodSymbol.flags());
        this.databuf.appendChar(n2);
        if (this.dumpMethodModifiers) {
            this.log.errWriter.println("METHOD  " + this.fieldName(methodSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(methodSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(methodSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(methodSymbol.externalType(this.types))));
        int n3 = this.beginAttrs();
        int n4 = 0;
        if (methodSymbol.code != null) {
            int n5 = this.writeAttr(this.names.Code);
            this.writeCode(methodSymbol.code);
            methodSymbol.code = null;
            this.endAttr(n5);
            ++n4;
        }
        if ((list = methodSymbol.erasure(this.types).thrown()).nonEmpty()) {
            n = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(list.length());
            List<Type> list2 = list;
            while (list2.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
                list2 = list2.tail;
            }
            this.endAttr(n);
            ++n4;
        }
        if (methodSymbol.defaultValue != null) {
            n = this.writeAttr(this.names.AnnotationDefault);
            methodSymbol.defaultValue.accept(this.awriter);
            this.endAttr(n);
            ++n4;
        }
        n4 += this.writeMemberAttrs(methodSymbol);
        this.endAttrs(n3, n4 += this.writeParameterAttrs(methodSymbol));
    }

    void writeCode(Code code) {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        int n4;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        boolean bl = code.cp > 65535;
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> list = code.catchInfo.toList();
        while (list.nonEmpty()) {
            for (n4 = 0; n4 < ((char[])list.head).length; ++n4) {
                this.databuf.appendChar(((char[])list.head)[n4]);
            }
            list = list.tail;
        }
        int n5 = this.beginAttrs();
        n4 = 0;
        if (code.lineInfo.nonEmpty()) {
            n3 = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> list2 = code.lineInfo.reverse();
            while (list2.nonEmpty()) {
                for (n2 = 0; n2 < ((char[])list2.head).length; ++n2) {
                    this.databuf.appendChar(((char[])list2.head)[n2]);
                }
                list2 = list2.tail;
            }
            this.endAttr(n3);
            ++n4;
        }
        if (this.genCrt && code.crt != null) {
            CRTable cRTable = code.crt;
            int n6 = this.writeAttr(this.names.CharacterRangeTable);
            n2 = this.beginAttrs();
            n = cRTable.writeCRT(this.databuf);
            this.endAttrs(n2, n);
            this.endAttr(n6);
            ++n4;
        }
        n3 = 0;
        if (code.varBufferSize > 0) {
            int n7 = this.writeAttr(this.names.LocalVariableTable);
            this.databuf.appendChar(code.varBufferSize);
            for (n2 = 0; n2 < code.varBufferSize; ++n2) {
                Code.LocalVar localVar = code.varBuffer[n2];
                assert (localVar.start_pc >= '\u0000');
                assert (localVar.start_pc <= code.cp);
                this.databuf.appendChar(localVar.start_pc);
                assert (localVar.length >= '\u0000');
                assert (localVar.start_pc + localVar.length <= code.cp);
                this.databuf.appendChar(localVar.length);
                object2 = localVar.sym;
                this.databuf.appendChar(this.pool.put(((Symbol.VarSymbol)object2).name));
                object = ((Symbol)object2).erasure(this.types);
                if (!this.types.isSameType(((Symbol.VarSymbol)object2).type, (Type)object)) {
                    ++n3;
                }
                this.databuf.appendChar(this.pool.put(this.typeSig((Type)object)));
                this.databuf.appendChar(localVar.reg);
            }
            this.endAttr(n7);
            ++n4;
        }
        if (n3 > 0) {
            int n8 = this.writeAttr(this.names.LocalVariableTypeTable);
            this.databuf.appendChar(n3);
            n2 = 0;
            for (n = 0; n < code.varBufferSize; ++n) {
                object2 = code.varBuffer[n];
                object = ((Code.LocalVar)object2).sym;
                if (this.types.isSameType(((Symbol.VarSymbol)object).type, ((Symbol)object).erasure(this.types))) continue;
                ++n2;
                this.databuf.appendChar(((Code.LocalVar)object2).start_pc);
                this.databuf.appendChar(((Code.LocalVar)object2).length);
                this.databuf.appendChar(this.pool.put(((Symbol.VarSymbol)object).name));
                this.databuf.appendChar(this.pool.put(this.typeSig(((Symbol.VarSymbol)object).type)));
                this.databuf.appendChar(((Code.LocalVar)object2).reg);
            }
            assert (n2 == n3);
            this.endAttr(n8);
            ++n4;
        }
        if (code.stackMapBufferSize > 0) {
            if (this.debugstackmap) {
                System.out.println("Stack map for " + code.meth);
            }
            int n9 = this.writeAttr(this.names.StackMap);
            n2 = code.stackMapBufferSize;
            if (this.debugstackmap) {
                System.out.println(" nframes = " + n2);
            }
            if (bl) {
                this.databuf.appendInt(n2);
            } else {
                this.databuf.appendChar(n2);
            }
            for (n = 0; n < n2; ++n) {
                int n10;
                int n11;
                if (this.debugstackmap) {
                    System.out.print("  " + n + ":");
                }
                object2 = code.stackMapBuffer[n];
                if (this.debugstackmap) {
                    System.out.print(" pc=" + ((Code.StackMapFrame)object2).pc);
                }
                if (bl) {
                    this.databuf.appendInt(((Code.StackMapFrame)object2).pc);
                } else {
                    this.databuf.appendChar(((Code.StackMapFrame)object2).pc);
                }
                int n12 = 0;
                for (n11 = 0; n11 < ((Code.StackMapFrame)object2).locals.length; n11 += this.target.generateEmptyAfterBig() ? 1 : Code.width(((Code.StackMapFrame)object2).locals[n11])) {
                    ++n12;
                }
                if (this.debugstackmap) {
                    System.out.print(" nlocals=" + n12);
                }
                if (code.max_locals > 65535) {
                    this.databuf.appendInt(n12);
                } else {
                    this.databuf.appendChar(n12);
                }
                for (n11 = 0; n11 < ((Code.StackMapFrame)object2).locals.length; n11 += this.target.generateEmptyAfterBig() ? 1 : Code.width(((Code.StackMapFrame)object2).locals[n11])) {
                    if (this.debugstackmap) {
                        System.out.print(" local[" + n11 + "]=");
                    }
                    this.emitStackMapType(((Code.StackMapFrame)object2).locals[n11], bl);
                }
                n11 = 0;
                for (n10 = 0; n10 < ((Code.StackMapFrame)object2).stack.length; n10 += this.target.generateEmptyAfterBig() ? 1 : Code.width(((Code.StackMapFrame)object2).stack[n10])) {
                    ++n11;
                }
                if (this.debugstackmap) {
                    System.out.print(" nstack=" + n11);
                }
                if (code.max_stack > 65535) {
                    this.databuf.appendInt(n11);
                } else {
                    this.databuf.appendChar(n11);
                }
                for (n10 = 0; n10 < ((Code.StackMapFrame)object2).stack.length; n10 += this.target.generateEmptyAfterBig() ? 1 : Code.width(((Code.StackMapFrame)object2).stack[n10])) {
                    if (this.debugstackmap) {
                        System.out.print(" stack[" + n10 + "]=");
                    }
                    this.emitStackMapType(((Code.StackMapFrame)object2).stack[n10], bl);
                }
                if (!this.debugstackmap) continue;
                System.out.println();
            }
            this.endAttr(n9);
            ++n4;
        }
        this.endAttrs(n5, n4);
    }

    void emitStackMapType(Type type, boolean bl) {
        if (type == null) {
            if (this.debugstackmap) {
                System.out.print("empty");
            }
            this.databuf.appendByte(0);
        } else {
            switch (type.tag) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    if (this.debugstackmap) {
                        System.out.print("int");
                    }
                    this.databuf.appendByte(1);
                    break;
                }
                case 6: {
                    if (this.debugstackmap) {
                        System.out.print("float");
                    }
                    this.databuf.appendByte(2);
                    break;
                }
                case 7: {
                    if (this.debugstackmap) {
                        System.out.print("double");
                    }
                    this.databuf.appendByte(3);
                    break;
                }
                case 5: {
                    if (this.debugstackmap) {
                        System.out.print("long");
                    }
                    this.databuf.appendByte(4);
                    break;
                }
                case 17: {
                    if (this.debugstackmap) {
                        System.out.print("null");
                    }
                    this.databuf.appendByte(5);
                    break;
                }
                case 10: 
                case 11: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + type + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(type));
                    break;
                }
                case 14: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + this.types.erasure((Type)type).tsym + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(this.types.erasure((Type)type).tsym));
                    break;
                }
                case 22: {
                    if (this.debugstackmap) {
                        System.out.print("uninit_this");
                    }
                    this.databuf.appendByte(6);
                    break;
                }
                case 23: {
                    UninitializedType uninitializedType = (UninitializedType)type;
                    this.databuf.appendByte(8);
                    if (this.debugstackmap) {
                        System.out.print("uninit_object@" + uninitializedType.offset);
                    }
                    if (bl) {
                        this.databuf.appendInt(uninitializedType.offset);
                        break;
                    }
                    this.databuf.appendChar(uninitializedType.offset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    void writeFields(Scope.Entry entry) {
        List<Symbol.VarSymbol> list = List.make();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 4) {
                list = list.prepend((Symbol.VarSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)list.head);
            list = list.tail;
        }
    }

    void writeMethods(Scope.Entry entry) {
        List<Symbol.MethodSymbol> list = List.make();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 16 && (entry2.sym.flags() & 0x2000000000L) == 0L) {
                list = list.prepend((Symbol.MethodSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)list.head);
            list = list.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClass(Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        File file = this.outputFile(classSymbol, ".class");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.writeClassFile(fileOutputStream, classSymbol);
            if (this.verbose) {
                this.log.errWriter.println(Log.getLocalizedString("verbose.wrote.file", file.getPath()));
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
                file.delete();
                fileOutputStream = null;
            }
        }
    }

    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        Object object;
        assert ((classSymbol.flags() & 0x1000000L) == 0L);
        this.databuf.reset();
        this.poolbuf.reset();
        this.sigbuf.reset();
        this.pool = classSymbol.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type type = this.types.supertype(classSymbol.type);
        List<Type> list = this.types.interfaces(classSymbol.type);
        List<Type> list2 = classSymbol.type.typarams();
        int n = this.adjustFlags(classSymbol.flags());
        if ((n & 4) != 0) {
            n |= 1;
        }
        if (((n = n & 0x6E11 & 0xFFFFF7FF) & 0x200) == 0) {
            n |= 0x20;
        }
        if (this.dumpClassModifiers) {
            this.log.errWriter.println();
            this.log.errWriter.println("CLASSFILE  " + classSymbol.fullName());
            this.log.errWriter.println("---" + ClassWriter.flagNames(n));
        }
        this.databuf.appendChar(n);
        this.databuf.appendChar(this.pool.put(classSymbol));
        this.databuf.appendChar(type.tag == 10 ? this.pool.put(type.tsym) : 0);
        this.databuf.appendChar(list.length());
        List<Type> list3 = list;
        while (list3.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)list3.head).tsym));
            list3 = list3.tail;
        }
        int n2 = 0;
        int n3 = 0;
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            switch (entry.sym.kind) {
                case 4: {
                    ++n2;
                    break;
                }
                case 16: {
                    if ((entry.sym.flags() & 0x2000000000L) != 0L) break;
                    ++n3;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)entry.sym);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            entry = entry.sibling;
        }
        this.databuf.appendChar(n2);
        this.writeFields(classSymbol.members().elems);
        this.databuf.appendChar(n3);
        this.writeMethods(classSymbol.members().elems);
        int n4 = this.beginAttrs();
        int n5 = 0;
        boolean bl = list2.length() != 0 || type.typarams().length() != 0;
        List<Type> list4 = list;
        while (!bl && list4.nonEmpty()) {
            bl = ((Type)list4.head).typarams().length() != 0;
            list4 = list4.tail;
        }
        if (bl) {
            assert (this.source.allowGenerics());
            int n6 = this.writeAttr(this.names.Signature);
            if (list2.length() != 0) {
                this.assembleParamsSig(list2);
            }
            this.assembleSig(type);
            object = list;
            while (((List)object).nonEmpty()) {
                this.assembleSig((Type)((List)object).head);
                object = ((List)object).tail;
            }
            this.databuf.appendChar(this.pool.put(this.sigbuf.toName(this.names)));
            this.sigbuf.reset();
            this.endAttr(n6);
            ++n5;
        }
        if (classSymbol.sourcefile != null && this.emitSourceFile) {
            int n7 = this.writeAttr(this.names.SourceFile);
            object = classSymbol.sourcefile.toString();
            int n8 = ((String)object).lastIndexOf(File.separatorChar);
            int n9 = ((String)object).lastIndexOf(47);
            if (n9 > n8) {
                n8 = n9;
            }
            if (n8 >= 0) {
                object = ((String)object).substring(n8 + 1);
            }
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString((String)object)));
            this.endAttr(n7);
            ++n5;
        }
        if (this.genCrt) {
            int n10 = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(this.getLastModified(classSymbol.sourcefile)))));
            this.endAttr(n10);
            ++n5;
            n10 = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(n10);
            ++n5;
        }
        n5 += this.writeFlagAttrs(classSymbol.flags());
        n5 += this.writeJavaAnnotations(classSymbol.attributes());
        n5 += this.writeEnclosingMethodAttribute(classSymbol);
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(this.target.minorVersion);
        this.poolbuf.appendChar(this.target.majorVersion);
        this.writePool(classSymbol.pool);
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++n5;
        }
        this.endAttrs(n4, n5);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        outputStream.write(this.poolbuf.elems, 0, this.poolbuf.length);
        classSymbol.pool = null;
        this.pool = null;
    }

    int adjustFlags(long l) {
        int n = (int)l;
        if ((l & 0x1000L) != 0L && !this.target.useSyntheticFlag()) {
            n &= 0xFFFFEFFF;
        }
        if ((l & 0x4000L) != 0L && !this.target.useEnumFlag()) {
            n &= 0xFFFFBFFF;
        }
        if ((l & 0x2000L) != 0L && !this.target.useAnnotationFlag()) {
            n &= 0xFFFFDFFF;
        }
        if ((l & 0x80000000L) != 0L && this.target.useBridgeFlag()) {
            n |= 0x40;
        }
        if ((l & 0x400000000L) != 0L && this.target.useVarargsFlag()) {
            n |= 0x80;
        }
        return n;
    }

    long getLastModified(Name name) {
        long l = 0L;
        File file = new File(name.toString());
        try {
            l = file.lastModified();
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + securityException.getMessage()));
        }
        return l;
    }

    public File outputFile(Symbol.ClassSymbol classSymbol, String string) throws IOException {
        if (this.outDir == null) {
            String string2 = Convert.shortName(classSymbol.flatname) + string;
            if (classSymbol.sourcefile == null) {
                return new File(string2);
            }
            String string3 = new File(classSymbol.sourcefile.toString()).getParent();
            if (string3 == null) {
                return new File(string2);
            }
            return new File(string3, string2);
        }
        return this.outputFile(this.outDir, classSymbol.flatname.toString(), string);
    }

    File outputFile(File file, String string, String string2) throws IOException {
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 >= n) {
            if (!(file = new File(file, string.substring(n, n2))).exists()) {
                file.mkdir();
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return new File(file, string.substring(n) + string2);
    }

    class AttributeWriter
    implements Attribute.Visitor {
        AttributeWriter() {
        }

        public void visitConstant(Attribute.Constant constant) {
            Object object = constant.value;
            switch (constant.type.tag) {
                case 1: {
                    ClassWriter.this.databuf.appendByte(66);
                    break;
                }
                case 2: {
                    ClassWriter.this.databuf.appendByte(67);
                    break;
                }
                case 3: {
                    ClassWriter.this.databuf.appendByte(83);
                    break;
                }
                case 4: {
                    ClassWriter.this.databuf.appendByte(73);
                    break;
                }
                case 5: {
                    ClassWriter.this.databuf.appendByte(74);
                    break;
                }
                case 6: {
                    ClassWriter.this.databuf.appendByte(70);
                    break;
                }
                case 7: {
                    ClassWriter.this.databuf.appendByte(68);
                    break;
                }
                case 8: {
                    ClassWriter.this.databuf.appendByte(90);
                    break;
                }
                case 10: {
                    assert (object instanceof String);
                    ClassWriter.this.databuf.appendByte(115);
                    object = ClassWriter.this.names.fromString(object.toString());
                    break;
                }
                default: {
                    throw new AssertionError(constant.type);
                }
            }
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(object));
        }

        public void visitEnum(Attribute.Enum enum_) {
            ClassWriter.this.databuf.appendByte(101);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(enum_.value.type)));
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(enum_.value.name));
        }

        public void visitClass(Attribute.Class clazz) {
            ClassWriter.this.databuf.appendByte(99);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(clazz.type)));
        }

        public void visitCompound(Attribute.Compound compound) {
            ClassWriter.this.databuf.appendByte(64);
            ClassWriter.this.writeCompoundAttribute(compound);
        }

        public void visitError(Attribute.Error error) {
            throw new AssertionError(error);
        }

        public void visitArray(Attribute.Array array) {
            ClassWriter.this.databuf.appendByte(91);
            ClassWriter.this.databuf.appendChar(array.values.length);
            for (Attribute attribute : array.values) {
                attribute.accept(this);
            }
        }
    }

    public static class PoolOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RetentionPolicy {
        SOURCE,
        CLASS,
        RUNTIME;

    }

    public static class StringOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String value;

        public StringOverflow(String string) {
            this.value = string;
        }
    }
}

