/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkClasspathFontPeerMetrics;
import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GtkTextComponentPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.awt.peer.TextAreaPeer;

public class GtkTextAreaPeer
extends GtkTextComponentPeer
implements TextAreaPeer {
    native void create(int var1, int var2, int var3);

    native void gtkSetFont(String var1, int var2, int var3);

    void create() {
        Font f = this.awtComponent.getFont();
        if (f == null) {
            f = new Font("Fixed", 0, 12);
            this.awtComponent.setFont(f);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        TextArea ta = (TextArea)this.awtComponent;
        int rows = ta.getRows();
        int cols = ta.getColumns();
        int width = cols * fm.getMaxAdvance();
        int height = rows * (fm.getMaxDescent() + fm.getMaxAscent());
        this.create(width, height, ta.getScrollbarVisibility());
    }

    public GtkTextAreaPeer(TextArea ta) {
        super(ta);
    }

    public native void insert(String var1, int var2);

    public native void replaceRange(String var1, int var2, int var3);

    public Dimension getMinimumSize(int rows, int cols) {
        return this.minimumSize(rows, cols);
    }

    public Dimension getPreferredSize(int rows, int cols) {
        return this.preferredSize(rows, cols);
    }

    native int getHScrollbarHeight();

    native int getVScrollbarWidth();

    public Dimension minimumSize(int rows, int cols) {
        Font f;
        TextArea ta = (TextArea)this.awtComponent;
        boolean hScrollbarHeight = false;
        boolean vScrollbarWidth = false;
        int height = 0;
        int width = 0;
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 2) {
            height = this.getHScrollbarHeight();
        }
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 1) {
            width = this.getVScrollbarWidth();
        }
        if ((f = this.awtComponent.getFont()) == null) {
            return new Dimension(width, height);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        return new Dimension(width += cols * fm.getMaxAdvance(), height += rows * (fm.getMaxDescent() + fm.getMaxAscent()));
    }

    public Dimension preferredSize(int rows, int cols) {
        Font f;
        TextArea ta = (TextArea)this.awtComponent;
        boolean hScrollbarHeight = false;
        boolean vScrollbarWidth = false;
        int height = 0;
        int width = 0;
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 2) {
            height = this.getHScrollbarHeight();
        }
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 1) {
            width = this.getVScrollbarWidth();
        }
        if ((f = this.awtComponent.getFont()) == null) {
            return new Dimension(width, height);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        return new Dimension(width += cols * fm.getMaxAdvance(), height += rows * (fm.getMaxDescent() + fm.getMaxAscent()));
    }

    public void replaceText(String str, int start, int end) {
        this.replaceRange(str, start, end);
    }

    public void insertText(String str, int pos) {
        this.insert(str, pos);
    }

    public void setFont(Font f) {
        this.gtkSetFont(f.getName(), f.getStyle(), f.getSize());
    }
}

