/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_callbacks.h"
#include "glade_gui.h"
#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "entry.h"
#include "goto.h"
#include "misc.h"
#include "menu.h"
#include "reg.h"
#include "pasteboard.h"
#include "widgets.h"
#include "xfstab.h"

#include "widgets.i"

#define D(x)

extern char *pastepath;
extern GtkTreeRowReference *pasteref;
extern char *auto_CC_name[];
extern char *auto_DD_name[];
extern autotype_t autotype[];
extern autotype_t autotype_dir[];

void hide_bars(GtkTreeView * treeview)
{
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkWidget *v;
    GtkWidget *w;
    int i;
    for(i = 0; bars[i]; i++)
    {
	v = lookup_widget(tree_details->window, bars[i]);
	w = lookup_widget(tree_details->window, bar_buttons[i]);
	if(tree_details->preferences & bar_prefs[i])
	{
	    if(GTK_WIDGET_VISIBLE(w))
		gtk_widget_hide(w);
	    if(!GTK_WIDGET_VISIBLE(v))
		gtk_widget_show(v);
	}
	else
	{
	    if(GTK_WIDGET_VISIBLE(v))
		gtk_widget_hide(v);
	    if(!GTK_WIDGET_VISIBLE(w))
		gtk_widget_show(w);
	}

    }

    w = lookup_widget(tree_details->window, "show_titles");
    gtk_tree_view_set_headers_visible(treeview, tree_details->preferences & SHOW_TITLES);
    if(tree_details->preferences & SHOW_TITLES)
    {
	if(GTK_WIDGET_VISIBLE(w))
	    gtk_widget_hide(w);
    }
    else
    {
	if(!GTK_WIDGET_VISIBLE(w))
	    gtk_widget_show(w);
    }
}

gboolean set_load_wait(tree_details_t ** tree_details_p)
{
    int i;
    if(!(*tree_details_p)->window){
#ifdef DEBUG
	printf("DBG(widgets.c): !(*tree_details_p)->window\n"); 
#endif
	return FALSE;
    }
    if((*tree_details_p)->loading){
#ifdef DEBUG
	printf("DBG(widgets.c): (*tree_details_p)->loading\n"); 
#endif
	return FALSE;
    }
    for(i = 0; focus_names[i]; i++)
    {
	GtkWidget *w = lookup_widget((*tree_details_p)->window, focus_names[i]);
	if(gtk_widget_is_focus(w))
	{
#ifdef DEBUG
	    printf("DBG(widgets.c): incorrect focus=%s\n",focus_names[i]); 
#endif
	    return FALSE;
	}
    }
    /* FIXME: removing this if makes menu elements go white when selected */
    if(!((*tree_details_p)->preferences & ENABLE_MONITOR))
	for(i = 0; main_menu_names[i] != NULL; i++)
	{
	    GtkWidget *w = lookup_widget((GtkWidget *) (*tree_details_p)->window, main_menu_names[i]);
	    if(w)
		gtk_widget_set_sensitive(w, FALSE);
	    else
		printf("DBG:incorrect widget name %s\n", main_menu_names[i]);
	}
    for(i = 0; main_widget_names[i] != NULL; i++)
    {
	GtkWidget *w = lookup_widget((GtkWidget *) (*tree_details_p)->window, main_widget_names[i]);
	if(w)
	    gtk_widget_set_sensitive(w, FALSE);
	else
	    printf("DBG:incorrect widget name %s\n", main_widget_names[i]);
    }
    (*tree_details_p)->loading = TRUE;
    return TRUE;
}

gboolean unset_load_wait(tree_details_t ** tree_details_p)
{
    int i;
    if(!(*tree_details_p)->window)
	return FALSE;
    /*if (!tree_details->loading) return FALSE; */
    for(i = 0; main_menu_names[i] != NULL; i++)
    {
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) (*tree_details_p)->window, main_menu_names[i]), TRUE);
    }
    for(i = 0; main_widget_names[i] != NULL; i++)
    {
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) (*tree_details_p)->window, main_widget_names[i]), TRUE);
    }
    (*tree_details_p)->loading = FALSE;
    D("menu widgets on\n");
    turn_on_goto((*tree_details_p)->treeview);
    D("goto widgets on\n");
    turn_on((*tree_details_p)->treeview);
    D("other widgets on\n");
    return TRUE;
}

void set_widget_initial_goto_state(GtkTreeView * treeview)
{
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    int i;
    D("set_widget_initial_goto_state\n");
    for(i = 0; goto_names[i] != NULL; i++)
    {
	GtkWidget *w = lookup_widget((GtkWidget *) tree_details->window, goto_names[i]);
	gtk_widget_set_sensitive(w, FALSE);
    }
}


void set_widget_initial_state(GtkTreeView * treeview)
{
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    int i, j;
    char **names[] = {
	samba_names,
	selected_dir_names,
	selected_file_names,
	selected_names,
	zoom_names,
	need_select_names,
	NULL
    };
    D("set_widget_initial_state\n");
    for (i=0;auto_CC_name[i];i++) 
	    hideit(tree_details->window,auto_CC_name[i]);
    for (i=0;auto_DD_name[i];i++) 
	    hideit(tree_details->window,auto_DD_name[i]);
    /*hideit(tree_details->window, "autotype_DD");*/
    hideit(tree_details->window, "autotype_RR");
    hideit(tree_details->window, "autotype_Mrun");
    hideit(tree_details->window, "mountM");
    hideit(tree_details->window, "unmountM");

    for(j = 0; names[j] != NULL; j++)
    {
	for(i = 0; names[j][i] != NULL; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, names[j][i]), FALSE);
    }
    for(j = 0; not_yet_available[j] != NULL; j++)
    {
	GtkWidget *w = lookup_widget((GtkWidget *) tree_details->window,
				     not_yet_available[j]);
	if(GTK_WIDGET_VISIBLE(w))
	    gtk_widget_hide(w);
    }

}


void turn_on_goto(GtkTreeView * treeview)
{
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    /* turn widgets on/off */
    set_widget_initial_goto_state(treeview);
    if(go_back_ok(treeview)){
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"button172"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"back2"), 
			TRUE);
    }
    D("go_back_ok done \n");
    if(go_forward_ok(treeview)){
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"button173"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"forward2"), 
			TRUE);
    }
    D("go_for_ok done \n");
    if(go_up_ok(treeview)){
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"go_up_button"), 
			TRUE);
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
				tree_details->window, 
				"up2"), 
			TRUE);
    }
    D("go_up_ok done \n") return;
}


static void turn_it_on(GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    int i;
    GtkTreeView *treeview = (GtkTreeView *) data;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    tree_entry_t *en;

    /* condition for only one item selected: */
    if(pasteref)
    {
	gtk_tree_row_reference_free(pasteref);
	pasteref = NULL;
    }
    pastepath = NULL;

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!en || !en->path || IS_DUMMY_TYPE(en->type))
	return;

    for(i = 0; zoom_names[i]; i++)
	gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, zoom_names[i]), TRUE);

    if ((IS_ROOT_TYPE(en->type) && (!IS_LOCAL_TYPE(en->type)&&!IS_BOOKMARK_TYPE(en->type))) ||
       (IS_NETWORK_TYPE(en->type) && 
	!IS_XF_NETWS(en->subtype) && 
	!IS_XF_NETSHARE(en->subtype) && 
	!IS_NETDIR(en->subtype) && 
	!IS_NETFILE(en->subtype)
       )||
       IS_XF_FND(en->type) 
       ){
	    return;
    }

    tree_details->selectionOK++;


    if(tree_details->selectionOK == 1)
    {
	if(IS_DIR(en->type) ||
	   (IS_APP_TYPE(en->type) && !IS_ROOT_TYPE(en->type)) ||
	   IS_NETDIR(en->subtype) ||
	   IS_XF_NETSHARE(en->subtype))
	{
	    for(i = 0; selected_dir_names[i]; i++)
		gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, selected_dir_names[i]), TRUE);
	    pastepath = en->path;
	    pasteref = gtk_tree_row_reference_new(treemodel, path);
	}
	else if(IS_BOOKMARK_TYPE(en->type) && IS_ROOT_TYPE(en->type))
	{
	    pasteref = gtk_tree_row_reference_new(treemodel, path);
	    pastepath = "ROOT_BOOKMARKS";
	}
	if(IS_FILE(en->type))
	{
	    char *s1, *s2, *p = strrchr(en->path, '.');

	    for(i = 0; selected_file_names[i]; i++)
	    {
		if(!IS_BROKEN_LNK(en->type))
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, selected_file_names[i]), TRUE);
	    }

	    if(p && strcmp(p, ".cyt") == 0)
	    {
		s1 = "unscramble2";
		s2 = "scramble2";
	    }
	    else
	    {
		s1 = "scramble2";
		s2 = "unscramble2";
	    }
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, s1), IS_BROKEN_LNK(en->type) ? FALSE : TRUE);
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, s2), FALSE);
	}
	for(i = 0; need_select_names[i]; i++)
	    gtk_widget_set_sensitive(
			lookup_widget((GtkWidget *) tree_details->window, 
			    need_select_names[i]), 
			TRUE);
    }
    else
    {
	for(i = 0; selected_dir_names[i]; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, selected_dir_names[i]), FALSE);
	for(i = 0; need_select_names[i]; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, need_select_names[i]), FALSE);
	for(i = 0; selected_file_names[i]; i++)
	{
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, selected_file_names[i]), FALSE);
	}

    }


    if(!IS_PATH(en->type) &&
       !IS_XF_NETWS(en->subtype) &&
       !IS_XF_NETSHARE(en->subtype) &&
       !IS_NETDIR(en->subtype) &&
       !IS_NETFILE(en->subtype)
      )	return;
    for(i = 0; selected_names[i]; i++)
	gtk_widget_set_sensitive(
			lookup_widget((GtkWidget *) tree_details->window, 
			selected_names[i]), 
			TRUE);

}

void turn_on_pasteboard(GtkTreeView * treeview)
{
    int i;
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    if(!valid_pasteboard())
    {
	for(i = 0; valid_pasteboard_names[i]; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, valid_pasteboard_names[i]), FALSE);
    }
    else
    {
	for(i = 0; valid_pasteboard_names[i]; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, valid_pasteboard_names[i]), TRUE);
    }
    if(!pastepath || !valid_pasteboard())
    {
	for(i = 0; i < 2; i++)
	    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) tree_details->window, valid_pasteboard_names[i]), FALSE);

    }
    return;
}

void turn_on(GtkTreeView * in_treeview)
{
    GtkTreeView * treeview = get_selected_treeview((GtkWidget *) in_treeview);
    tree_details_t *tree_details = (tree_details_t *) get_tree_details(treeview);
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    /*GtkTreeModel *treemodel=gtk_tree_view_get_model(treeview); */
    tree_entry_t *en;
    gchar *cmd=NULL,*text=NULL;

    /* turn widgets on/off */
    set_widget_initial_state(treeview);
    tree_details->selectionOK = 0;
    pastepath = NULL;

    gtk_tree_selection_selected_foreach(selection, 
		    turn_it_on, (gpointer) treeview);



    if(tree_details->selectionOK == 0)
    {
	GtkTreeIter iter;
    	int i;

	if(get_selectpath_iter(treeview, &iter, &en))
	{
	    D("get_selectpath_iter done \n")
	    if(IS_DIR(en->type))
	    {
		D("IS_DIR  done \n")
	       	for(i = 0; need_select_names[i]; i++)
		    gtk_widget_set_sensitive(lookup_widget((GtkWidget *) 
					    tree_details->window, 
					    need_select_names[i]), TRUE);
	    }
	}
    } 
    if(tree_details->selectionOK == 1){
	GtkTreeIter iter;
	reg_t *prg;
	int j;
	en=get_selected_entry(treeview, &iter);
	if (!en || IS_DUMMY_TYPE(en->type)) return; 
	
	if (IS_FSTAB_TYPE(en->type) && IS_XF_FSTAB(en->type))
	{
	  int i=is_mounted(en->path);
	  if (i>=0){
	      if (i) showit(tree_details->window, "unmountM");
	      else showit(tree_details->window, "mountM");
	  } else {
	      if (IS_MOUNTED(en->type)) 
		      showit(tree_details->window, "unmountM");
	      else showit(tree_details->window, "mountM");
	  }
	}

	if (IS_EXE(en->type) && !IS_DIR(en->type)){
          GtkWidget *label;
	  GtkWidget *a=lookup_widget(tree_details->window,"autotype_Mrun");
    	  label = gtk_bin_get_child(GTK_BIN(a));
	  g_free(text);	 
	  text=g_strconcat(_("Execute")," ",FILENAME(en),NULL);
	  gtk_label_set_text(GTK_LABEL(label),my_utf_string(text));
	  g_free(text);text=NULL;
	  showit(tree_details->window, "autotype_Mrun");		
	}	
	/*printf("DBG:tag=%s path=%s\n",en->tag,en->path);*/
	prg = reg_prog_by_file (en->path);
	if (prg) {/* look in registered programs  */
	  GtkWidget *label,*a=lookup_widget(tree_details->window,"autotype_RR");
    	  label = gtk_bin_get_child(GTK_BIN(a));
	  if (prg->arg) {
		  cmd=g_strconcat(prg->app," ",prg->arg,NULL);
	  }
	  else {
		  cmd=g_strconcat(prg->app,NULL);
	  }
	  text=g_strconcat(cmd," \'",FILENAME(en),"\'",NULL);
	  gtk_label_set_text((GtkLabel *)label,my_utf_string(text));
	  g_free(text);text=NULL;
	  showit(tree_details->window, "autotype_RR");	
	} 
	
	if (IS_DIR(en->type))
#if 0
	{/* autotar */
          GtkWidget *label;
	  GtkWidget *a=lookup_widget(tree_details->window,"autotype_DD");
    	  label = gtk_bin_get_child(GTK_BIN(a));
	  g_free(text);	 
	  text=g_strconcat(_("Create")," ",FILENAME(en),".tar.gz",NULL);
	  gtk_label_set_text(GTK_LABEL(label),my_utf_string(text));
	  g_free(text);
	  showit(tree_details->window, "autotype_DD");	
	}
#else	
		{/* autotypes_D */	      
      		   char *loc;
		   int i,j;
		   GtkWidget *label;
		   for (j=i=0;auto_DD_name[j]&&autotype_dir[i].label;i++){
		       GtkWidget *a=lookup_widget(tree_details->window,auto_DD_name[j]);
		       {
		           gchar *prg;
    		  	   label = gtk_bin_get_child(GTK_BIN(a));
		           text=g_strconcat(_(autotype_dir[i].label),
					   " \"", FILENAME(en),"\"",
					   NULL);
			   gtk_label_set_text((GtkLabel *)label,
					   my_utf_string(text));
			   g_free(text); text=NULL;
			   prg=g_strdup(autotype_dir[i].command);
			   if (strstr(prg," ")) prg=strtok(prg," ");
			   text=g_find_program_in_path(prg);
			   /*printf("DBG:looking for %s\n",prg);*/
		  	   if (text && !(cmd && strcmp(prg,cmd)==0)) {
				showit(tree_details->window, auto_DD_name[j]);
			   	/*printf("DBG:found %s\n",text);*/
			   }
			   	
			   g_free(text);text=NULL;
			   g_free(prg);prg=NULL;
			   j++; 
		       }
		   }

		}
#endif
	{/* autotypes */	      
      	   char *loc;
	   int i;
	   GtkWidget *label;
	   for (j=i=0;auto_CC_name[j]&&autotype[i].extension;i++){
	       GtkWidget *a=lookup_widget(tree_details->window,auto_CC_name[j]);
	       loc=strstr(en->path,autotype[i].extension);
	       if ((loc)&&(strcmp(loc,autotype[i].extension)==0)){
	           gchar *prg;
    	  	   label = gtk_bin_get_child(GTK_BIN(a));
	           text=g_strconcat(_(autotype[i].label),
				   " \"", FILENAME(en),"\"",
				   NULL);
		   gtk_label_set_text((GtkLabel *)label,my_utf_string(text));
		   g_free(text); text=NULL;
		   prg=g_strdup(autotype[i].command);
		   if (strstr(prg," ")) prg=strtok(prg," ");
		   text=g_find_program_in_path(prg);
	  	   if (text && !(cmd && strcmp(prg,cmd)==0)) {
			   /*printf("DBG:showing \'%s\' at %s cmd=%s\n", text,auto_CC_name[j],cmd);*/
			   showit(tree_details->window, auto_CC_name[j]);
		   } 
		   g_free(text);text=NULL;
		   g_free(prg);prg=NULL;
		   j++;
	       }
	   }
	}
        /* duplicate mime types */
	{
	  GtkWidget *label;
	  int i;
	  const char *prog;
	  for (i=0; j<10 && i<10;i++){
		  /*printf("DBG: duplicate slot %d\n",j);*/
	       	  GtkWidget *a=lookup_widget(tree_details->window,auto_CC_name[j]);
		  prog=reg_duplicate_app(en->path,i);
		  if (!prog) {
			  /*printf("DBG: no duplicate!\n");*/
			  break;
		  }
		  /*printf("DBG: duplicate FOUND!\n");*/
    	  	  label = gtk_bin_get_child(GTK_BIN(a));
	          text=g_strconcat(prog," \"", FILENAME(en),"\"",NULL);
		  gtk_label_set_text((GtkLabel *)label,my_utf_string(text));
			   
	  	  if (!(cmd && strcmp(prog,cmd)==0)) {
			   showit(tree_details->window, auto_CC_name[j]);
		  } 				   
		  j++;   
		  g_free(text);text=NULL;
	  } 
	}
   }
   g_free(cmd);cmd=NULL;		   
    D("turnon  done \n")
    turn_on_pasteboard(treeview);
}
