/*
 * reg.c
 *
 * Edscott Wilson Garcia 2001-2003 for xfce project.
 * Copyright (C) 1998, 1999 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <glib.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

#include <libxfce4util/util.h>

#include "constants.h"
#include "reg.h"

#define ENHANCED_CODE

#ifdef ENHANCED_CODE

static GHashTable *application_hash = NULL;
static GHashTable *repeat_app_hash = NULL;

static void clear_application(gpointer key, gpointer value, gpointer user_data)
{
    reg_t *reg;
    reg = (reg_t *)value;
    g_free(reg->app);
    g_free(reg->arg);
    g_free(reg); reg=NULL;
    g_free(key); key=NULL;
}

static void destroy_application_hash(GHashTable *hash){
    if (!hash) return;
    g_hash_table_foreach(hash, clear_application, NULL);
    g_hash_table_destroy(hash);
}

const char *reg_duplicate_app(char *path,int i){
	gchar *p,*s;
	reg_t *reg;
	static char q[256];
	
	if (strchr(path,'/')) p=strrchr(path,'/')+1;
	if (strchr(p,'.')) p=strchr(p,'.');
	s=g_strdup(p);
	if (strchr(s,'-')) s=strtok(s,"-");
	snprintf(q,255,"%s%d",s,i);
	g_free(s);s=NULL;
	/*printf("DBG: duplicate lookup for %s (%s)\n",q,path);*/
	reg = g_hash_table_lookup(repeat_app_hash,q);
	if (!reg) return NULL;
	if (reg->arg) snprintf(q,255,"%s %s",reg->app,reg->arg);
	else snprintf(q,255,"%s",reg->app);
	return q;
}


void reg_build_list(void){
 xmlChar *value;
 xmlNodePtr node;
 xmlDocPtr doc;
 gchar *mimefile=NULL;
 int i;
    
#ifdef DEBUG
            printf("DBG: reg_build_list\n");
#endif
 if (application_hash){
    destroy_application_hash(application_hash);
    application_hash=NULL;
 }
 if (repeat_app_hash){
    destroy_application_hash(repeat_app_hash);
    repeat_app_hash=NULL;
 }

 application_hash = g_hash_table_new(g_str_hash, g_str_equal);
 repeat_app_hash = g_hash_table_new(g_str_hash, g_str_equal);

 for (i=0;i<2;i++) {
	 
    if (i) {
   	mimefile=g_strconcat(PACKAGE_DATA_DIR,"/xffm/applications.xml",NULL);
    } else {
       if (!g_get_home_dir()) continue;
       	mimefile=g_strconcat(g_get_home_dir(),"/.xfce4/xffm/applications.xml",NULL);
    }
#ifdef DEBUG
            printf("DBG: mimefile=%s\n",mimefile);
#endif
    if (access(mimefile,R_OK)!=0){
	g_free(mimefile); mimefile=NULL;
#ifdef DEBUG
            printf("DBG: access(mimefile,R_OK)!=0\n");
#endif
	continue;
    }
    xmlKeepBlanksDefault(0);

    if((doc = xmlParseFile(mimefile)) == NULL)
    {
      	printf("xffm: invalid xml file %s.\n",mimefile);
	g_free(mimefile); mimefile=NULL;
	continue;
    }
	
    node = xmlDocGetRootElement(doc);
    if(!xmlStrEqual(node->name, (const xmlChar *)"mime_applications"))
    {
      	printf("xffm: invalid xml file %s.\n",mimefile);
	g_free(mimefile); mimefile=NULL;
        xmlFreeDoc(doc);
	continue;
    }
    /* Now parse the xml tree */
#ifdef DEBUG
            printf("DBG: parsing %s\n",mimefile);
#endif
    for(node = node->children; node; node = node->next)
    {
	if(xmlStrEqual(node->name, (const xmlChar *)"extension"))
	{
	    reg_t *reg;
	    reg=(reg_t *)malloc(sizeof(reg_t));
	    if (!reg) g_assert_not_reached();
	    	    
	    value = xmlGetProp(node, (const xmlChar *)"application");
	    if (!value) {
		    g_free(reg);reg=NULL;
		    continue;
	    }
	    reg->app = g_strdup(value);
	    
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"arguments");
	    
	    if (value){
	        reg->arg = g_strdup(value);
	        g_free(value); value=NULL;	
	    } else reg->arg = NULL;
	    
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"id");
	    if (!value) {
		    g_free(reg->arg);
		    g_free(reg->app);
		    g_free(reg);reg=NULL;
		    continue;
	    }
	    
#ifdef DEBUG
	    fprintf(stderr,"DBG:adding : %s %s for %s\n",reg->app,
			    (reg->arg)?reg->arg:" ",(char *)value);
#endif    
 	    /* valid? */
	    {
    	       char fname[_POSIX_PATH_MAX];
	       gchar *path=g_find_program_in_path(reg->app);
	       gchar *full_cmd;
    	       
               xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1,CURRENT_RUN_HISTORY, G_DIR_SEPARATOR); 
	       if (reg->arg && strlen(reg->arg)){
		       full_cmd=g_strconcat(reg->app," ",reg->arg,NULL);
	       } else {
		       full_cmd=g_strdup(reg->app);
	       }
		       
	       if (path){
	          /* skip if already registered in hash */
		  gboolean duplicated=FALSE;
	          if (g_hash_table_lookup(application_hash,(char *)value)){
		     int i;
		     char dupkey[256];
		     if (strlen((char *)value)<255 ) for (i=0;i<10;i++){ 
			     /* we have place for up to 10 extra menu entries */
			     sprintf(dupkey,"%s%d",(char *)value,i);
			     if (!g_hash_table_lookup(repeat_app_hash,dupkey)){
	             		g_hash_table_insert(repeat_app_hash,  (gpointer) g_strdup(dupkey),(gpointer) reg);
				duplicated=TRUE;
				/*printf("DBG: duplicate %s -> %s\n",dupkey,reg->app);*/
				break;
			     }
		     }
		     /* ok, since it wont go into duplicates, clean up */
		     if (!duplicated){
		       g_free(reg->arg);
		       g_free(reg->app);
		       g_free(reg);reg=NULL;
		     }
	     
		  }
		  else {
	             g_hash_table_insert(application_hash,  (gpointer) g_strdup(value),(gpointer) reg);
#ifdef DEBUG
                  printf("DBG: adding to hash %s->%s\n",(char *)value,reg->app);
	          if (g_hash_table_lookup(application_hash,(char *)value))
		    printf("DBG: found in hash\n");
	          else printf("DBG: NOT found in hash\n");

#endif
		  }
	          if (!is_in_history(fname,full_cmd)){
#ifdef DEBUG
                     printf("DBG: adding %s to history file\n",full_cmd);
#endif
		     save_to_history(fname,full_cmd);
	          }
	       }
	       else /* not a valid path: no use keeping reg around */ 
	       {
		    g_free(reg->arg);
		    g_free(reg->app);
		    g_free(reg);reg=NULL;
	       }
	       g_free(path);path=NULL;
	       g_free(full_cmd);full_cmd=NULL;
	    }
		    
	    g_free(value); value=NULL;
	}
    }
    xmlFreeDoc(doc); 
    g_free(mimefile);
 }	
}


#if 0
reg_t *reg_prog_by_suffix(char *in_sfx)
{
    reg_t *reg;
    char *sfx=g_strdup(in_sfx);
    if (strchr(sfx,'-') ) *(strchr(sfx,'-'))=0;
    
    reg = g_hash_table_lookup(application_hash, sfx);
    g_free(sfx); sfx=NULL;
    if (!reg) return NULL;
    return reg;
}

char *reg_app_by_suffix(char *sfx)
{
    reg_t *reg=reg_prog_by_suffix(sfx);
    if (reg) return reg->app;
    else return NULL;
}
#endif



reg_t *
reg_prog_by_file (char *file)
{
  reg_t *reg;
  char *sfx;
  if (!file) return NULL;
  if (strchr(file,'.') && strlen(strchr(file,'.')) > 1) {
	sfx = g_strdup(strchr(file,'.'));
  	if (strchr(sfx,'-')) *(strchr(sfx,'-'))=0;
  }
  else sfx = g_strdup(file);

#ifdef DEBUG
           /* printf("DBG: looking for %s with suffix %s\n",file,sfx);*/
	    
#endif

  reg = g_hash_table_lookup(application_hash, sfx);
  g_free(sfx); sfx=NULL;
  if (!reg) return NULL;
  return reg;
}

	
char *reg_app_by_file(char *file){
  reg_t *reg=reg_prog_by_file (file);
  if (!reg) return NULL;
  return reg->app;
}


static void reg_write(char *sfx,reg_t *reg){
    xmlNodePtr node,root;
    xmlDocPtr doc;
    xmlNodePtr child;
    char *mimefile=NULL;
    int i;

    if (!g_get_home_dir()) return;
    
    mimefile=g_strconcat(g_get_home_dir(),"/.xfce4/xffm/applications.xml",NULL);
    if (access(mimefile,F_OK)==0 && access(mimefile,W_OK)!=0){
	g_free(mimefile); mimefile=NULL;
	return;
    }
    
    /* read xml in */
    if (access(mimefile,R_OK)!=0){
       doc = xmlNewDoc("1.0");
       doc->children = xmlNewDocRawNode(doc, NULL, "mime_applications", NULL);

       root = (xmlNodePtr) doc->children;
       xmlDocSetRootElement(doc, root);
       node = xmlNewTextChild(root, NULL, "extension", NULL);
    } else {
       xmlChar *value;
       if((doc = xmlParseFile(mimefile)) == NULL)
       {
         printf("xffm: invalid xml file %s.\n",mimefile);
	 g_free(mimefile); mimefile=NULL;
	 return;
       }
       root = xmlDocGetRootElement(doc);
       if(!xmlStrEqual(root->name, (const xmlChar *)"mime_applications"))
       {
         printf("xffm: invalid xml file %s.\n",mimefile);
	 g_free(mimefile); mimefile=NULL;
         xmlFreeDoc(doc);
	 return;
       }
       for (node=root->children;node;node=node->next){
printf("DBG: %s == extension ?\n",node->name);
	       if(xmlStrEqual(node->name, (const xmlChar *)"extension")){
	          value = xmlGetProp(node, (const xmlChar *)"id");
		  if (value){
printf("DBG: %s == %s ?\n",value,sfx);
			  if (xmlStrEqual((const xmlChar *)sfx, (const xmlChar *)value)){
				  g_free(value);
				  break;
			  }
			  g_free(value);
		  }
	       }
       }
       if (!node) node = xmlNewTextChild(root, NULL, "extension", NULL);
    }   
    
    /* add additional register */
    xmlSetProp(node,"id", sfx);
    xmlSetProp(node,"application", reg->app);

    
    if (reg->arg && strlen(reg->arg)){
        xmlSetProp(node, "arguments", reg->arg);
    }

    /* write xml out */
    
    xmlSaveFormatFile(mimefile, doc, 1);

    xmlFreeDoc(doc);
    g_free(mimefile);
    return;
}

void reg_add_suffix(char *in_sfx, char *program, char *args)
{
    char *sfx=g_strdup(in_sfx);
    reg_t *reg;
    if (!program || !strlen(program)) return;
    if (strchr(sfx,'-') ) *(strchr(sfx,'-'))=0;
    reg = g_hash_table_lookup(application_hash, sfx);
    if (reg) {
	    g_free(reg->app);
 	    g_free(reg->arg);
    } else {
	    reg=(reg_t *)malloc(sizeof(reg_t));
	    if (!reg) g_assert_not_reached();
	    g_hash_table_insert(application_hash,  (gpointer) g_strdup(sfx),(gpointer) reg);
    }
    reg->app=g_strdup(program);
    reg->arg=g_strdup(args);
    reg_write(sfx,reg);
    g_free(sfx);sfx=NULL;
    return;
}

/* dummy functions to be removed for 4.1: */
int reg_save(void){
	return 1;
}

GList *reg_app_list(void){
	return NULL;
}


#else 

  /* pre-4.0 buggy code: this should be erased soon... */

static char regfile[_POSIX_PATH_MAX];
static GList *reg_list = NULL;

const char *reg_duplicate_app(char *path,int i){
	return NULL;
}

/*
 */
static int compare_sfx(char *sfx1, char *sfx2)
{
    int r;
    char *asfx1 = g_strdup(sfx1);
    char *asfx2 = g_strdup(sfx2);
    if(strchr(asfx1, '-'))
	asfx1 = strtok(asfx1, "-");
    if(strchr(asfx2, '-'))
	asfx2 = strtok(asfx2, "-");
    r = strcmp(asfx1, asfx2);
    g_free(asfx1);
    g_free(asfx2);
    asfx1=asfx2=NULL;
    return r;
}

static int compare_reg(reg * reg1, reg * reg2)
{
    return compare_sfx(reg1->sfx, reg2->sfx);
}

void reg_free_reg(reg_t * app)
{
    if(!app)
	return;
    if(app->app){
	g_free(app->app);
	app->app=NULL;
    }
    if(app->arg){
	g_free(app->arg);
	app->arg=NULL;
    }
    if(app->sfx){
	g_free(app->sfx);
	app->sfx=NULL;
    }
    g_free(app);
    app=NULL;
}

/*
 * on startup we build a complete list
 */
void reg_build_list(void)
{
#define BUFSIZE 1024
    FILE *fp;
    char buf[BUFSIZE], *p, *ep, *buf_end;
    char suffix[_POSIX_PATH_MAX];
    char cmd[PATH_MAX + 1];
    char arg[PATH_MAX + 1];
    reg_t *prg;
    int inner;
    int line;

    xfce_get_userfile_r(regfile, _POSIX_PATH_MAX-1, "xffm%cxffm.reg",
		    G_DIR_SEPARATOR);
    fp = fopen(regfile, "r");
    if(!fp)
    {
	printf("Warning, can't open %s\n", regfile);
	return;
    }
    buf_end = buf + BUFSIZE - 1;
    line = 0;
    while(fgets(buf, BUFSIZE, fp) != NULL)
    {
	line++;
	p = buf;
	while((*p == ' ') || (*p == '\t'))
	    p++;
	if(*p == '#')
	    continue;
	prg = g_malloc(sizeof(reg_t));
	if(!prg)
	    g_assert_not_reached();
	prg->app = prg->sfx = prg->arg = NULL;
	if(*p != '(')
	{
	    /* old style */
	    *arg = '\0';
	    sscanf(buf, "%s %[^ \n] %[^\n]", suffix, cmd, arg);
	    prg->sfx = g_strdup(suffix);
	    prg->app = g_strdup(cmd);
	    if(*arg)
		prg->arg = g_strdup(arg);
	    prg->len = strlen(suffix);
	    reg_list = g_list_append(reg_list, prg);
	}
	else
	{
	    /* new style:
	     * (suffix)(program)(arguments)
	     */
	    inner = 0;
	    p++;
	    ep = p;
	    while(*ep && (ep < buf_end))
	    {
		if(*ep == '(')
		    inner++;
		else if(*ep == ')')
		{
		    if(inner)
			inner--;
		    else
			break;
		}
		ep++;
	    }
	    if(*ep != ')')
	    {
		/* parse error */
		fprintf(stderr, "parse error at line %d\n", line);
		reg_free_reg(prg);
		continue;
	    }
	    *ep = '\0';
	    prg->sfx = g_strdup(p);
	    prg->len = strlen(prg->sfx);

	    /* find program */
	    p = ep + 1;
	    while(*p && (p < buf_end))
	    {
		if(*p == '(')
		    break;
		p++;
	    }
	    if(*p != '(')
	    {
		/* parse error */
		fprintf(stderr, "parse error at line %d\n", line);
		reg_free_reg(prg);
		continue;
	    }
	    inner = 0;
	    p++;
	    ep = p;
	    while(*ep && (ep < buf_end))
	    {
		if(*ep == '(')
		    inner++;
		else if(*ep == ')')
		{
		    if(inner)
			inner--;
		    else
			break;
		}
		ep++;
	    }
	    if(*ep != ')')
	    {
		/* parse error */
		fprintf(stderr, "parse error at line %d\n", line);
		reg_free_reg(prg);
		continue;
	    }
	    *ep = '\0';
	    prg->app = g_strdup(p);

	    /* find args */
	    p = ep + 1;
	    while(*p && (p < buf_end))
	    {
		if(*p == '(')
		    break;
		p++;
	    }
	    if(*p == '(')
	    {
		inner = 0;
		p++;
		ep = p;
		while(*ep && (ep < buf_end))
		{
		    if(*ep == '(')
			inner++;
		    else if(*ep == ')')
		    {
			if(inner)
			    inner--;
			else
			    break;
		    }
		    ep++;
		}
		if(*ep != ')')
		{
		    /* parse error */
		    fprintf(stderr, "parse error at line %d\n", line);
		    reg_free_reg(prg);
		    continue;
		}
		*ep = '\0';
		if(p != ep)
		    prg->arg = g_strdup(p);
	    }
	    /* check for coherent values */
	    /* only if  DISPLAY is :0.0 to avoid false removes from remotes */
	    /* if it is a directory register, does the directory exist? */
	    if(strcmp(getenv("DISPLAY"), ":0.0") == 0)
	    {
		gchar *test;
		if(*(prg->sfx) == '/')
		{
		    struct stat s;
		    if(stat(prg->sfx, &s) < 0)
		    {
			fprintf(stderr, "xftree:removing %s from xtree.reg\n", prg->sfx);
			reg_free_reg(prg);
			continue;
		    }
		}
		/* does the application exist? glob the path */
		test=g_find_program_in_path(prg->app);
		if(!test)
		{
		    fprintf(stderr, "xffm:removing %s application from xtree.reg\n", prg->app);
		    reg_free_reg(prg);
		    continue;
		} else g_free(test);
	    }
	    reg_list = g_list_append(reg_list, prg);
	}
    }
    fclose(fp);
    return;
}

/*
 */
char *reg_app_by_suffix(char *sfx)
{
    GList *tmp_list = reg_list;
    reg *prg;
    while(tmp_list)
    {
	prg = tmp_list->data;
	if(compare_sfx(prg->sfx, sfx) == 0)
	{
	    return (prg->app);
	}
	tmp_list = tmp_list->next;
    }
    return (NULL);
}

/*
 */
reg_t *reg_prog_by_suffix(char *sfx)
{
    reg_t *prg;
    GList *tmp_list = reg_list;
    while(tmp_list)
    {
	prg = tmp_list->data;
	/*printf("DBG: ojo %s %s\n",prg->app,prg->arg); */
	if(compare_sfx(prg->sfx, sfx) == 0)
	{
	    return (prg);
	}
	tmp_list = tmp_list->next;
    }
    return (NULL);
}
reg_t *
reg_prog_by_file (char *file)
{
  reg_t *prg;
  int len;
  GList *tmp_list;

  if (!file)
    return NULL;
  len = strlen (file);

  for(tmp_list = reg_list; tmp_list; tmp_list = tmp_list->next)
  {
    prg = tmp_list->data;
    if ((!prg) || (prg->len > len)) continue;
    if (strcmp (file + (len - prg->len), prg->sfx) == 0) return (prg);
  }
  return (NULL);
}


/*
 */
char *reg_app_by_file(char *file)
{
    reg *prg;
    char *loc;
    GList *tmp_list;
    static char *app_arg = NULL;

    if(app_arg){
	g_free(app_arg);
	app_arg=NULL;
    }
    

    if(!file)
	return NULL;

    for(tmp_list = reg_list; tmp_list; tmp_list = tmp_list->next)
    {
	prg = tmp_list->data;
	if(!prg)
	    continue;

	if(strchr(file, '.'))
	    loc = strrchr(file, '.');
	else
	    loc = file;

	if(compare_sfx(loc, prg->sfx) == 0)
	{
	    int len;
	    len = (prg->arg) ? strlen(prg->arg) : 0;
	    len += ((prg->app) ? strlen(prg->app) : 0);
	    len += 2;
	    app_arg = (char *)malloc(len);
	    if(!app_arg)
		g_assert_not_reached();

	    if(prg->arg)
		sprintf(app_arg, "%s %s", prg->app, prg->arg);
	    else
		sprintf(app_arg, "%s", prg->app);

	    return (app_arg);
	}
    }
    return (NULL);
}

void reg_add_suffix(char *sfx, char *program, char *args)
{
    reg *prg = NULL;
    GList *g_tmp = reg_list;
    int found = 0;
    /* is suffix already registered?
     * check it out ..
     */
    while(g_tmp)
    {
	prg = g_tmp->data;
	if(compare_sfx(prg->sfx, sfx) == 0)
	{
	    found = 1;
	    break;
	}
	g_tmp = g_tmp->next;
    }
    if(found)
    {
	g_free(prg->app);
	prg->app=NULL;
	g_free(prg->arg);
	prg->arg=NULL;
	prg->app = g_strdup(program);
	prg->arg = NULL;
	if(args)
	{
	    prg->arg = g_strdup(args);
	}
    }
    else
    {
	prg = g_malloc(sizeof(reg));
	prg->app = g_strdup(program);
	prg->sfx = g_strdup(sfx);
	prg->len = strlen(sfx);
	if(args)
	{
	    prg->arg = g_strdup(args);
	}
	else
	{
	    prg->arg = NULL;
	}
	reg_list = g_list_append(reg_list, prg);
    }
    if(reg_list)
	reg_list = g_list_sort(reg_list, (GCompareFunc) compare_reg);
    return;
}

/*
 */
void reg_destroy_list(GList * list)
{
    GList *g_tmp = list;
    reg *prg;
    while(g_tmp)
    {
	prg = (reg *) g_tmp->data;
	g_free(prg->sfx);
	prg->sfx=NULL;
	g_free(prg->app);
	prg->app=NULL;
	if(prg->arg){
	    g_free(prg->arg);
	    prg->arg=NULL;
	}
	g_free(prg);
	prg=NULL;
	g_tmp = g_tmp->next;
    }
    g_list_free(list);
    list = NULL;
}


/*
 * save registry to named file
 */
int reg_save(void)
{
    FILE *fp;
    reg *prg;
    GList *tmp_list = reg_list;

    if(!regfile)
	return (0);
    fp = fopen(regfile, "w");
    if(!fp)
	return (0);
    fprintf(fp, "# (suffix) (program) (args)\n");
    while(tmp_list)
    {
	prg = tmp_list->data;
	if(prg)
	{
	    /* printf("DBG: writing out %s %s\n",prg->sfx,prg->app); */
	    if(prg->arg)
	    {
		fprintf(fp, "(%s) (%s) (%s)\n", prg->sfx, prg->app, prg->arg);
	    }
	    else
	    {
		fprintf(fp, "(%s) (%s) ()\n", prg->sfx, prg->app);
	    }
	}
	tmp_list = tmp_list->next;
    }
    fclose(fp);
    return (TRUE);
}

/*
 * return a list of all registered applications with arguments
 */
GList *reg_app_list(void)
{
    GList *g_apps = NULL;
    GList *g_tmp;
    char *app_arg;
    GList *tmp_list = reg_list;

    while(tmp_list)
    {
	char *app, *arg;
	int len;
	app = ((reg *) tmp_list->data)->app;
	arg = ((reg *) tmp_list->data)->arg;
	len = (arg) ? strlen(arg) : 0;
	len += strlen(app);
	len += 2;
	app_arg = (char *)malloc(len);
	if(app_arg)
	{
	    if(arg)
		sprintf(app_arg, "%s %s", app, arg);
	    else
		sprintf(app_arg, "%s", app);
	    g_apps = g_list_append(g_apps, app_arg);
	}
	tmp_list = tmp_list->next;
    }
    if(g_apps)
	g_apps = g_list_sort(g_apps, (GCompareFunc) strcmp);
    /* remove dupes */
    g_tmp = g_apps;
    while(g_tmp)
    {
	if(g_tmp->next)
	{
	    if(strcmp((char *)g_tmp->data, (char *)g_tmp->next->data) == 0)
	    {
		char *rem;
		rem = g_tmp->data;
		g_tmp = g_apps = g_list_remove(g_apps, rem);
		g_free(rem);
		rem=NULL;
		continue;
	    }
	}
	if(!g_tmp)
	    break;
	else
	    g_tmp = g_tmp->next;
    }
    return g_apps;
}

GList *reg_app_list_free(GList * g_apps)
{
    char *rem;
    GList *g_tmp;
    g_tmp = g_apps;
    while(g_tmp)
    {
	rem = g_tmp->data;
	if(rem)
	{
	    g_tmp = g_apps = g_list_remove(g_apps, rem);
	    g_free(rem);
	    rem=NULL;
	}
	if(!g_tmp)
	    break;
	else
	    g_tmp = g_tmp->next;
    }
    return NULL;
}
#endif
