.\" $Xorg: protocol.ms,v 1.3 2000/08/17 19:42:40 cpqbld Exp $
.\" $XdotOrg: xc/doc/specs/Xi/protocol.ms,v 1.1.10.1 2004/03/25 04:56:42 alanc Exp $
.\" Input Extension
.EH ''''
.OH ''''
.EF ''''
.OF ''''
.ps 11
.nr PS 11
\0
.sp 10
.ce 500
.ps 20
\fBX11 Input Extension Protocol Specification
.ps 12
.sp 2
Version 1.0
.sp 1
X Consortium Standard
.sp 1
X Version 11, Release 6.7
.sp 16
.ps 15
\fBMark Patrick\0\0\0\0Ardent Computer
.sp 1
\fBGeorge Sachs\0\0\0\0Hewlett-Packard
.ps 12
.ce 0
.bp
\0
.sp 10
.fi
.LP
Copyright \(co 1989, 1990, 1991 by Hewlett-Packard Company and Ardent Computer
.LP
Permission to use, copy, modify, and distribute this documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
Ardent and Hewlett-Packard make no representations about the suitability 
for any purpose of the information in this document.  It is provided "as is" 
without express or implied warranty.
.sp 5
Copyright \(co 1989, 1990, 1991, 1992 X Consortium
.LP
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the ``Software''), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
.LP
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
.LP
THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.LP
Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.
.sp 3
\fIX Window System\fP is a trademark of The Open Group.
.ps
.vs
.bp 1
.EH '\fBX Input Extension Protocol Specification\fP''\fBX11, Release 6.7\fP'
.OH '\fBX Input Extension Protocol Specification\fP''\fBX11, Release 6.7\fP'
.EF ''\fB\\\\n(PN\fP''
.OF ''\fB\\\\n(PN\fP''
.\"  Force the heading counter for level 1 to one
.\"
.nr Ej 1
.\"
.\"
.\"  Print table of contents to level 4 headings
.\"
.nr Cl 4
.\"
.\"  Page eject for each level 1 heading
.\"
.nr H1 1
.if \n(GS .nr nh*hl 1
.nr P 1
.\"
.\"  Define Ch to contain the chapter string.
.\"
.ds Ch Input Extension Overview
.\"
.\"
.\"  Pull in the layout macro package.
.\"
.\"
.tr ~
.NH 2
Input Extension Overview
.XS
\*(SN Input Extension Overview
.XE
.LP
This document defines an extension to the X11 protocol to support 
input devices other than the core X keyboard and pointer. 
An accompanying document defines a corresponding extension to Xlib 
(similar extensions for languages other than C are anticipated).
This first section gives an overview of the input extension.  The 
next section defines the new protocol requests defined by the extension.
We conclude with a description of the new input events generated by
the additional input devices.
.NH 2
Design Approach
.XS
\*(SN Design Approach
.XE
.LP
The design approach of the extension is to define requests
and events analogous to the core requests and events. This allows
extension input devices to be individually distinguishable from each other 
and from the core input devices.  These requests and events make use
of a device identifier and support the reporting of n-dimensional motion 
data as well as other data that is not reportable via the core 
input events.
.NH 2
Core Input Devices
.XS
\*(SN Core Input Devices
.XE
.LP
The X server core protocol supports two input devices:  a pointer and a
keyboard.  The pointer device has two major functions. 
First, it may be used to generate motion information
that client programs can detect. Second, it may also be used to indicate the
current location and focus of the X keyboard.  To accomplish this, the server 
echoes a cursor at the current position of the X pointer.  Unless the X
keyboard has been explicitly focused, this cursor also shows the current
location and focus of the X keyboard.
.LP
The X keyboard is used to generate input that client programs can detect.
.LP
The X keyboard and X pointer are referred to in this document as 
the \fIcore devices\fP, and the input
events they generate (\fBKeyPress\fP, \fBKeyRelease\fP, \fBButtonPress\fP, 
\fBButtonRelease\fP, and
\fBMotionNotify\fP) are known as the \fIcore input events\fP.  All other
input devices are referred to as \fIextension input devices\fP and the 
input events they generate are referred to as \fIextension input events\fP.
.NT
This input extension does not change the behavior or functionality of the
core input devices, core events, or core protocol requests, with the
exception of the core grab requests.  These requests may affect the
synchronization of events from extension devices.  See the explanation
in the section titled "Event Synchronization and Core Grabs".
.NE
.LP
Selection of the physical devices to be initially used by the server as the 
core devices is left implementation-dependent.  Requests are defined that
allow client programs to change which physical devices are used as the
core devices.
.NH 2
Extension Input Devices
.XS
\*(SN Extension Input Devices
.XE
.LP
The input extension controls access to input devices other than the X keyboard
and X pointer.  It allows client programs to select input from these devices 
independently from each other and independently from the core devices.  
.LP
A client that wishes to access a specific device must first determine
whether that device is connected to the X server.  This is done through the
\fBListInputDevices\fP request, which will return a list of all devices that
can be opened by the X server.  A client can then open one or more of these
devices using the \fBOpenDevice\fP request, specify what events they are
interested in receiving, and receive and process input events from extension
devices in the same way as events from the X keyboard and X pointer.
Input events from these devices are of extension types (\fBDeviceKeyPress\fP, 
\fBDeviceKeyRelease\fP, \fBDeviceButtonPress\fP, \fBDeviceButtonRelease\fP, 
\fBDeviceMotionNotify\fP, etc.) and contain a device identifier so that events 
of the same type coming from different input devices can be distinguished.
.LP
Any kind of input device may be used as an extension input device.
Extension input devices may have 0 or more keys, 0 or more buttons,
and may report 0 or more axes of motion.  Motion may be reported 
as relative movements from a previous position or as an absolute
position.  All valuators reporting motion information for a given
extension input device must report the same kind of motion information
(absolute or relative).
.LP
This extension is designed to accommodate new types of input devices that
may be added in the future.  The protocol requests that refer to
specific characteristics of input devices organize that information
by \fBinput classes\fP.  Server implementors may add new
classes of input devices without changing the protocol requests.
Input classes are unique numbers registered with the X Consortium.
Each extension input device may support multiple input classes.
.LP
All extension input devices are treated like the core X keyboard in 
determining their location and focus.  The server does not track the 
location of these devices on an individual basis, and therefore
does not echo a cursor to indicate their current location.
Instead, their location is determined by the location of the core X pointer.
Like the core X keyboard, some may be explicitly focused. If they are
not explicitly focused,  their focus is determined by the location of the 
core X pointer.
.LP
Input events reported by the server to a client are of fixed size (32 bytes).
In order to represent the change in state of an input device the extension
may need to generate a sequence of input events.  A client side library
(such as Xlib) will typically take these raw input events and format
them into a form more convenient to the client. 
.NH 3
Event Classes
.XS
\*(SN Event Classes
.XE
.LP
In the core protocol a client registers interest in receiving certain
input events directed to a window by modifying that window's event-mask.
Most of the bits in the event mask are already used to specify interest
in core X events.  The input extension specifies a different mechanism by which
a client can express interest in events generated by this extension.
.LP
When a client opens a extension input device via the \fBOpenDevice\fP request, 
an \fBXDevice\fP structure is returned.  Macros are provided that extract 
32-bit numbers called \fBevent classes\fP from that structure, that a client 
can use to register interest in extension events via the 
\fBSelectExtensionEvent\fP request.  The event class combines the desired 
event type and device id, and may be thought of as the equivalent of core
event masks.
.NH 3
Input Classes
.XS
\*(SN Input Classes
.XE
.LP
Some of the input extension requests divide input devices into classes
based on their functionality.  This is intended to allow new classes of input
devices to be defined at a later time without changing the semantics of 
these requests.  The following input device classes are currently
defined:
.RS
.in +5n
.IP "\fBKEY\fP"
The device reports key events.
.IP "\fBBUTTON\fP"
The device reports button events.
.IP "\fBVALUATOR\fP"
The device reports valuator data in motion events.
.IP "\fBPROXIMITY\fP"
The device reports proximity events.
.IP "\fBFOCUS\fP"
The device can be focused and reports focus events.
.IP "\fBFEEDBACK\fP"
The device supports feedbacks.
.IP "\fBOTHER\fP"
The \fBChangeDeviceNotify\fP, \fBDeviceMappingNotify\fP, and 
\fBDeviceStateNotify\fP macros may be invoked passing the \fBXDevice\fP 
structure returned for this device.
.in -5n
.RE
.LP
Each extension input device may support multiple input classes.
Additional classes may be added in the future.
Requests that support multiple input classes, such as the 
\fBListInputDevices\fP function that lists all available input devices,
organize the data they return by input class.  Client programs that
use these requests should not access data unless it matches a 
class defined at the time those clients were compiled.  In this way,
new classes can be added without forcing existing clients that use
these requests to be recompiled.
.NH 1
Requests
.XS
\*(SN Requests
.XE
.LP
Extension input devices are accessed by client programs through the 
use of new protocol requests.  This section summarizes the new requests
defined by this extension.  The syntax and type definitions used below 
follow the notation used for the X11 core protocol.  
.NH 2
Getting the Extension Version
.XS
\*(SN Getting the Extension Version
.XE
.LP
The \fBGetExtensionVersion\fP request returns version information about 
the input extension.
.sp 1.5
GetExtensionVersion
.in +.5i
name: STRING
.in -.5i
=>
.in +.5i
.br
present: BOOL
.br
protocol-major-version: CARD16
.br
protocol-minor-version: CARD16
.br
.sp
The protocol version numbers returned indicate the version of the input
extension supported by the target X server.  The version numbers can be 
compared to constants defined in the header file \fBXI.h\fP.  Each version is
a superset of the previous versions.
.NH 2
Listing Available Devices
.XS
\*(SN Listing Available Devices
.XE
.LP
A client that wishes to access a specific device must first determine 
whether that device is connected to the X server.  This is done through the
\fBListInputDevices\fP request, which will return a list of all devices that
can be opened by the X server.
.sp 1.5
ListInputDevices
.br
=>
.in +.5i
.br
input-devices: LISTofDEVICEINFO
.br
.sp
.in -.5i
where
.in +.5i
.br
.TS
l lw(4i).
T{
DEVICEINFO:
T}	T{
[type: ATOM
.br
\ id: CARD8
.br
\ num_classes: CARD8
.br
\ use: {IsXKeyboard, IsXPointer, IsExtensionDevice}
.br
\ info: LISTofINPUTINFO
.br
\ name: STRING8]
T}
.sp
T{
INPUTINFO:
T}	T{
{KEYINFO, BUTTONINFO, VALUATORINFO}
T}
.sp
T{
KEYINFO:
T}	T{
[class: CARD8
.br
\ length: CARD8
.br
\ min-keycode: KEYCODE
.br
\ max-keycode: KEYCODE
.br
\ num-keys: CARD16]
T}
.sp
T{
BUTTONINFO:
T}	T{
.br
[class: CARD8
.br
\ length: CARD8
.br
\ num-buttons: CARD16]
T}
.sp
T{
VALUATORINFO:
T}	T{
[class: CARD8
.br
\ length: CARD8
.br
\ num_axes: CARD8
.br
\ mode: SETofDEVICEMODE
.br
\ motion_buffer_size: CARD32
.br
\ axes: LISTofAXISINFO]
T}
.sp
T{
AXISINFO:
T}	T{
[resolution: CARD32
.br
\ min-val: CARD32
.br
\ max-val: CARD32]
T}
.sp
T{
DEVICEMODE:
T}	T{
{Absolute, Relative}
T}
.TE
.br
Errors: None
.in -.5i
.sp 1.5
This request returns a list of all devices that can be opened by the X 
server,  
including the core X keyboard and X pointer.  Some implementations may open
all input devices as part of X initialization, while others may not open
an input device until requested to do so by a client program.
.LP
.IP \(bu 3n
The information returned for each device is as follows:
.LP
The \fBtype\fP field is of type \fBAtom\fP and indicates the nature of the 
device.  Clients may determine device types by invoking the \fBXInternAtom\fP
request passing one of the names defined in the header file \fBXI.h\fP.  The
following names have been defined to date:
.DS
\fBMOUSE\fP	
\fBTABLET\fP
\fBKEYBOARD\fP	
\fBTOUCHSCREEN\fP
\fBTOUCHPAD\fP	
\fBBUTTONBOX\fP	
\fBBARCODE\fP
\fBKNOB_BOX\fP
\fBTRACKBALL\fP	
\fBQUADRATURE\fP
\fBSPACEBALL\fP
\fBDATAGLOVE\fP
\fBEYETRACKER\fP
\fBCURSORKEYS\fP
\fBFOOTMOUSE\fP
\fBID_MODULE\fP
\fBONE_KNOB\fP
\fBNINE_KNOB\fP
.DE
.LP
The \fBid\fP is a small cardinal value in the range 0-128 that uniquely 
identifies the device.  It is assigned to the device when it is initialized by 
the server.  Some implementations may not open an input device until requested
by a client program, and may close the device when the last client accessing
it requests that it be closed.
If a device is opened by a client program via \fBXOpenDevice\fP,
then closed via \fBXCloseDevice\fP, then opened again, it is not guaranteed
to have the same id after the second open request.
.LP
The \fBnum_classes\fP field is a small cardinal value in the range 0-255
that specifies the number of input classes supported by the device for
which information is returned by \fBListInputDevices\fP.  Some input classes,
such as class \fBFocus\fP and class \fBProximity\fP do not have any information
to be returned by \fBListInputDevices\fP.
.LP
The \fBuse\fP field specifies how the device is currently being used.  If the
value is \fBIsXKeyboard\fP, the device is currently being used as the 
X keyboard.  If the value is \fBIsXPointer\fP, the device is currently
being used as the X pointer.  If the value is \fBIsXExtensionDevice\fP,
the device is available for use as an extension device.
.LP
The \fBname\fP field contains a pointer to a null-terminated string that
corresponds to one of the defined device types.
.IP \(bu 3n
\fBInputInfo\fP is one of: \fBKeyInfo\fP, \fBButtonInfo\fP or 
\fBValuatorInfo\fP.  The first two fields are common to all three:
.LP
The \fBclass\fP field is a cardinal value in the range 0-255.  It uniquely
identifies the class of input for which information is returned.
.LP
The \fBlength\fP field is a cardinal value in the range 0-255.  It specifies
the number of bytes of data that are contained in this input class.  The
length includes the class and length fields.
.LP
The remaining information returned for input class \fBKEYCLASS\fP is as follows:
.LP
\fBmin_keycode\fP is of type KEYCODE.  It specifies the minimum keycode that
the device will report.  The minimum keycode will not be smaller than 8.
.LP
\fBmax_keycode\fP is of type KEYCODE.  It specifies the maximum keycode that
the device will report.  The maximum keycode will not be larger than 255.
.LP
\fBnum_keys\fP is a cardinal value that specifies the number of keys that the
device has.
.LP
The remaining information returned for input class \fBBUTTONCLASS\fP is as 
follows:
.LP
\fBnum_buttons\fP is a cardinal value that specifies the number of buttons 
that the device has.
.LP
The remaining information returned for input class \fBVALUATORCLASS\fP is as 
follows:
.LP
\fBmode\fP is a constant that has one of the following values: \fBAbsolute\fP
or \fBRelative\fP.  Some devices allow the mode to be changed dynamically
via the \fBSetDeviceMode\fP request.
.LP
\fBmotion_buffer_size\fP is a cardinal number that specifies the number of 
elements that can be contained in the motion history buffer for the device.
.LP
The \fBaxes\fP field contains a pointer to an AXISINFO struture.
.IP \(bu 3n
The information returned for each axis reported by the device is:
.LP
The \fBresolution\fP is a cardinal value in counts/meter.
.LP
The \fBmin_val\fP field is a cardinal value in that contains the minimum
value the device reports for this axis.  For devices whose mode is 
\fBRelative\fP, the min_val field will contain 0.
.LP
The \fBmax_val\fP field is a cardinal value in that contains the maximum
value the device reports for this axis.  For devices whose mode is 
\fBRelative\fP, the max_val field will contain 0.
.NH 2
Enabling Devices
.XS
\*(SN Enabling Devices
.XE
.LP
Client programs that wish to access an extension device must request that
the server open that device.  This is done via the \fBOpenDevice\fP
request.  
.sp 1.5
OpenDevice
.in +.5i
id: CARD8
.in -.5i
=>
.in +.5i
.br
.TS
l lw(4i).
T{
DEVICE:
T}	T{
[device_id: XID
.br
\ num_classes: INT32
.br
\ classes: LISTofINPUTCLASSINFO]
T}
.sp
T{
INPUTCLASSINFO:
T}	T{
[input_class: CARD8
.br
\ event_type_base: CARD8]
T}
.TE
.sp
Errors: Device
.in -.5i
.sp 1.5
.LP
This request returns the event classes to be used by the client to indicate 
which events the client program wishes to receive.  Each input class
may report several event classes.  For example, input class \fBKeys\fP reports
\fBDeviceKeyPress\fP and \fBDeviceKeyRelease\fP event classes.  Input classes 
are unique numbers registered with the X Consortium.  Input class 
\fBOther\fP exists
to report event classes that are not specific to any one input class,
such as \fBDeviceMappingNotify\fP, \fBChangeDeviceNotify\fP, and 
\fBDeviceStateNotify\fP.
.LP
.IP \(bu 3n
The information returned for each device is as follows:
.LP
The \fBdevice_id\fP is a number that uniquely identifies the device.
.LP
The \fBnum_classes\fP field contains the number of input classes supported
by this device.
.LP
.IP \(bu 3n
For each class of input supported by the device,
the \fBInputClassInfo\fP structure contains the following information:
.LP
The \fBinput_class\fP is a small cardinal number that identifies the class
of input.
.LP
The \fBevent_type_base\fP is a small cardinal number that specifies the 
event type of one of the events reported by this input class.  This information
is not directly used by client programs.  Instead, the \fBDevice\fP is used
by macros that return extension event types and event classes.  This is 
described in the section of this document entitled "Selecting Extension
Device Events".
.LP
Before it exits,
the client program should explicitly request that the server close
the device.  This is done via the \fBCloseDevice\fP request.
.LP
A client may open the same extension device more than once.  Requests
after the first successful one return an additional \fBXDevice\fP structure
with the same information as the first, but otherwise have no effect.
A single \fBCloseDevice\fP request will terminate that client's access to
the device.
.LP
Closing a device releases any active or passive grabs the requesting client
has established.  If the device is frozen only by an active grab of the
requesting client, the queued events are released when the client terminates.
.LP
If a client program terminates without closing a device, the server will
automatically close that device on behalf of the client.  This does not
affect any other clients that may be accessing that device.
.LP
.sp 1.5
CloseDevice
.in +.5i
device: DEVICE
.br
.sp
Errors: Device
.br
.in -.5i
.sp 1.5
.NH 2
Changing The Mode Of A Device
.XS
\*(SN Changing The Mode Of A Device
.XE
.LP
Some devices are capable of reporting either relative or absolute motion
data.  To change the mode of a device from relative to absolute, use the
\fBSetDeviceMode\fP request.  The valid values are \fBAbsolute\fP or 
\fBRelative\fP.
.LP
This request will fail and return \fBDeviceBusy\fP if another client already
has the device open with a different mode.   It will fail and return 
\fBAlreadyGrabbed\fP if another client has the device grabbed.
The request will fail with
a \fBBadMatch\fP error if the requested mode is not supported by the device.
.sp 1.5
SetDeviceMode
.in +.5i
device: DEVICE 
.br
mode: {Absolute, Relative}
.br
.sp
Errors: Device, Match, Mode
.br
.in -.5i
.sp 1.5
=>
.in +.5i
status: {Success, DeviceBusy, AlreadyGrabbed}
.br
.sp
.in -.5i
.NH 2
Initializing Valuators on an Input Device
.XS
\*(SN Initializing Valuators on an Input Device
.XE
.LP
Some devices that report absolute positional data can be initialized to a 
starting value.  Devices that are capable of reporting relative motion or
absolute positional data may require that their valuators be initialized 
to a starting value after the mode of the device is changed to \fBAbsolute\fP.
To initialize the valuators on such a device, use the \fBSetDeviceValuators\fP
request.
.sp 1.5
SetDeviceValuators
.in .5i
device: DEVICE
.br
first_valuator: CARD8
.br
num_valuators: CARD8
.br
valuators: LISTOFINT32
.br
.sp
Errors: Length, Device, Match, Value
.br
.in -.5i
.sp 1.5
=>
.in +.5i
status: {Success, AlreadyGrabbed}
.br
.sp
.in -.5i
.LP
This request initializes the specified valuators on the specified extension
input device.  Valuators are numbered beginning with zero.  Only the valuators
in the range specified by first_valuator and num_valuators are set.  If the
number of valuators supported by the device is less than the expression
first_valuator + num_valuators, a \fBValue\fP error will result.
.LP
If the request succeeds, \fBSuccess\fP is returned.  If the specifed device is 
grabbed by some other client, the request will fail and a status of
\fBAlreadyGrabbed\fP will be returned.
.NH 2 
Getting Input Device Controls
.XS
\*(SN Getting Input Device Controls
.XE
.LP
.sp 1.5
GetDeviceControl
.in .5i
device: DEVICE
.br
control: XID
.br
.sp
Errors: Length, Device, Match, Value
.br
.in -.5i
.sp 1.5
=>
.in +.5i
controlState: {DeviceState}
.br
.sp
.in -.5i
.LP
where
.in +.5i
.br
.TS
l lw(4i).
T{
DeviceState:
T}	T{
DeviceResolutionState
T}
.TE
.in -.5i
.br
.sp
Errors: Length, Device, Match, Value
.LP
This request returns the current state of the specified device control.
The device control must be supported by the target server and device or an 
error will result.  
.LP
If the request is successful, a pointer to a generic DeviceState 
structure will be returned.  The information returned varies according to 
the specified control and is mapped by a structure appropriate for that
control.
.LP
GetDeviceControl will fail with a BadValue error if the server does not support
the specified control.  It will fail with a BadMatch error if the device
does not support the specified control.
.LP
Supported device controls and the information returned for them include:
.LP
.TS
l lw(4i).
T{
DEVICE_RESOLUTION:
T}	T{
[control: CARD16
.br
\ length: CARD16
.br
\ num_valuators: CARD8
.br
\ resolutions: LISTofCARD32
.br
\ min_resolutions: LISTofCARD32
.br
\ max_resolutions: LISTofCARD32]
T}
.TE
.LP
This device control returns a list of valuators and the range of valid 
resolutions allowed for each.  Valuators are numbered beginning with 0.
Resolutions for all valuators on the device are returned.  
For each valuator i on the device, resolutions[i] returns the current setting
of the resolution, min_resolutions[i] returns the minimum valid setting,
and max_resolutions[i] returns the maximum valid setting.
.LP
When this control is specified, XGetDeviceControl will fail with a BadMatch
error if the specified device has no valuators.
.sp 1.5
ChangeDeviceControl
.in .5i
device: DEVICE
.br
XID: controlId
.br
control: DeviceControl
.br
.sp
.in -.5i
.LP
where
.in +.5i
.br
.TS
l lw(4i).
T{
DeviceControl:
T}	T{
DeviceResolutionControl
T}
.TE
.in -.5i
.br
.sp
Errors: Length, Device, Match, Value
.br
=>
.in +.5i
status: {Success, DeviceBusy, AlreadyGrabbed}
.br
.sp
.in -.5i
.LP
ChangeDeviceControl changes the specifed device control according to the values
specified in the DeviceControl structure.  The device control must be supported
by the target server and device or an error will result.
.LP
The information passed with this request varies according to the specified 
control and is mapped by a structure appropriate for that control.
.LP
ChangeDeviceControl will fail with a BadValue error if the server does not 
support the specified control.  It will fail with a BadMatch error if the 
server supports the specified control, but the requested device does not.
The request will fail and return a status of DeviceBusy if another client 
already has the device open with a device control state that conflicts with
the one specified in the request.  It will fail with a status of 
AlreadyGrabbed if some other client has grabbed the specified device.  If 
the request succeeds, Success is returned.  If it fails, the device control 
is left unchanged.
.LP
Supported device controls and the information specified for them include:
.LP
.TS
l lw(4i).
T{
DEVICE_RESOLUTION:
T}	T{
[control: CARD16
.br
\ length: CARD16
.br
\ first_valuator: CARD8
.br
\ num_valuators: CARD8
.br
\ resolutions: LISTofCARD32]
T}
.TE
.LP
This device control changes the resolution of the specified valuators
on the specified extension input device.  Valuators are numbered beginning
with zero.  Only the valuators in the range specified by first_valuator
and num_valuators are set.  A value of -1 in the resolutions list indicates 
that the resolution for this valuator is not to be changed.  num_valuators 
specifies the number of valuators in the resolutions list.
.LP
When this control is specified, XChangeDeviceControl will fail with a BadMatch
error if the specified device has no valuators.  If a resolution is specified
that is not within the range of valid values (as returned by XGetDeviceControl)
the request will fail with a BadValue error.  If the number of valuators
supported by the device is less than the expression first_valuator + 
num_valuators, a BadValue error will result.
.LP
If the request fails for any reason, none of the valuator resolutions will be 
changed.
.NH 2
Selecting Extension Device Events
.XS
\*(SN Selecting Extension Device Events
.XE
.LP
Extension input events are selected using the \fBSelectExtensionEvent\fP
request.
.sp 1.5
SelectExtensionEvent
.in .5i
window: WINDOW
.br
interest: LISTofEVENTCLASS
.br
.sp
Errors: Window, Class, Access
.br
.in -.5i
.sp 1.5
.LP
This request specifies to the server the events within the specified window
which are of interest to the client.  As with the core \fBXSelectInput\fP
function, multiple clients can select input on the same window.
.LP
\fBXSelectExtensionEvent\fP requires a list of \fIevent classes\fP.
An event class is a 32-bit number that combines an event type and
device id, and is used to indicate which event a client wishes to 
receive and from which device it wishes to receive it.  Macros
are provided to obtain event classes from the data returned by
the \fBXOpenDevice\fP request.  The names of these macros correspond
to the desired events, i.e. the \fBDeviceKeyPress\fP is used to 
obtain the event class for \fBDeviceKeyPress\fP events.  The syntax
of the macro invocation is:
.sp 1.5
DeviceKeyPress (device, event_type, event_class);
.in .5i
device: DEVICE
.br
event_type: INT
.br
event_class: INT
.in -.5i
.br
.LP
The value returned in \fBevent_type\fP is the value that will be contained in
the event type field of the \fBXDeviceKeyPressEvent\fP when it is received by 
the client.  The value returned in \fBevent_class\fP is the value that should
be passed in making an \fBXSelectExtensionEvent\fP request to receive
\fBDeviceKeyPress\fP events.
.LP
For \fBDeviceButtonPress\fP events, the client may specify whether
or not an implicit passive grab should be done when the button is
pressed.  If the client wants to guarantee that it will receive
a \fBDeviceButtonRelease\fP event for each \fBDeviceButtonPress\fP
event it receives, it should specify the \fBDeviceButtonPressGrab\fP
event class as well as the \fBDeviceButtonPress\fP event class.
This restricts the client in that only one client at a time
may request \fBDeviceButtonPress\fP events from the same device and
window if any client specifies this class.
.LP
If any client has specified the \fBDeviceButtonPressGrab\fP class, any requests
by any other client that specify the same device and window and specify
\fBDeviceButtonPress\fP or \fBDeviceButtonPressGrab\fP will
cause an \fBAccess\fP error to be generated.
.LP
If only the \fBDeviceButtonPress\fP class is specified, no implicit
passive grab will be done when a button is pressed on the device.
Multiple clients may use this class to specify the same device and
window combination.
.LP
A client may also specify the \fBDeviceOwnerGrabButton\fP class.  If it has
specified both the \fBDeviceButtonPressGrab\fP and the  
\fBDeviceOwnerGrabButton\fP classes, implicit passive grabs will activate
with owner_events set to \fBTrue\fP.  If only the 
\fBDeviceButtonPressGrab\fP class is specified, implicit passive grabs will
activate with owner_events set to \fBFalse\fP.
.LP
The client may select \fBDeviceMotion\fP events only when a 
button is down.  It does this by specifying the event classes 
\fBButton1Motion\fP through \fBButton5Motion\fP, or \fBButtonMotion\fP.  
An input device will only support
as many button motion classes as it has buttons.
.NH 2
Determining Selected Events
.XS
\*(SN Determining Selected Events
.XE
.LP
To determine which extension events are currently selected from a given
window, use \fBGetSelectedExtensionEvents\fP.
.sp 1.5
GetSelectedExtensionEvents 
.in .5i
window: WINDOW
.br
.in -.5i
=>
.in +.5i
.br
this-client: LISTofEVENTCLASS
.br
all-clients: LISTofEVENTCLASS
.br
.sp
Errors: Window
.br
.in -.5i
.sp 1.5
.LP
This request returns two lists specifying the events selected on the specified
window.  One list gives the extension events selected by this client from
the specified window.  The other list gives the extension events selected by
all clients from the specified window.  This information is equivalent
to that returned by your-event-mask and all-event-masks in a
\fBGetWindowAttributes\fP request. 
.NH 2
Controlling Event Propagation
.XS
\*(SN Controlling Event Propagation
.XE
.LP
Extension events propagate up the window hierarchy in the same manner
as core events.  If a window is not interested in an extension event, 
it usually propagates to the closest ancestor that is interested,
unless the dont_propagate list prohibits it.
Grabs of extension devices may alter the set of windows that receive a 
particular extension event.
.LP
Client programs may control extension event propagation through the use
of the following two requests.  
.LP
\fBXChangeDeviceDontPropagateList\fP adds an event to or deletes an event from 
the do_not_propagate list of extension events for the specified window.  This
list is maintained for the life of the window, and is not altered if the 
client terminates.
.LP
.sp 1.5
ChangeDeviceDontPropagateList
.in .5i
window: WINDOW
.br
eventclass: LISTofEVENTCLASS
.br
mode: {AddToList, DeleteFromList}
.br
.sp
Errors: Window, Class, Mode
.br
.in -.5i
.sp 1.5
.LP
This function modifies the list specifying the events that are not propagated
to the ancestors of the specified window.  You may use the modes \fBAddToList\fP
or \fBDeleteFromList\fP.
.sp 1.5
GetDeviceDontPropagateList
.in .5i
window: WINDOW
.br
.sp
Errors: Window
.br
.in -.5i
=>
.in +.5i
dont-propagate-list: LISTofEVENTCLASS
.br
.sp
.in -.5i
.sp 1.5
.LP
This function returns a list specifying the events that are not propagated
to the ancestors of the specified window.
.NH 2
Sending Extension Events
.XS
\*(SN Sending Extension Events
.XE
.LP
One client program may send an event to another via the 
\fBXSendExtensionEvent\fP function.
.LP
The event in the \fBXEvent\fP structure must be one of the events defined
by the input extension, so that the X server can correctly byte swap the
contents as necessary.  The contents of the event are otherwise unaltered
and unchecked by the X server except to force send_event to \fBTrue\fP
in the forwarded event and to set the sequence number in the event correctly.
.LP
XSendExtensionEvent returns zero if the conversion-to-wire protocol
failed, otherwise it returns nonzero.
.sp 1.5
SendExtensionEvent
.in .5i
device: DEVICE
.br
destination: WINDOW
.br
propagate: BOOL
.br
eventclass: LISTofEVENTCLASS
.br
event: XEVENT
.in -.5i
.sp
.br
Errors: Device, Value, Class, Window
.NH 2
Getting Motion History
.XS
\*(SN Getting Motion History
.XE
.LP
.sp 1.5
GetDeviceMotionEvents 
.in .5i
device: DEVICE
.br
start, stop: TIMESTAMP or CurrentTime
.br
.in -.5i
=>
.br
.in +.5i
nevents_return: CARD32
.br
mode_return: {Absolute, Relative}
.br
axis_count_return: CARD8
.br
events: LISTofDEVICETIMECOORD
.br
.sp
.in -.5i
where
.br
.in +.5i
.TS
l lw(4i).
T{
DEVICETIMECOORD:
T}	T{
[data:LISTofINT32
\ time:TIMESTAMP]
T}
.TE
.sp
Errors: Device, Match
.br
.in -.5i
.sp 1.5
.LP
This request returns all positions in the device's motion history buffer
that fall between the specified start and stop times inclusive.  If the
start time is in the future, or is later than the stop time, no positions
are returned.
.LP
The data field of the DEVICETIMECOORD structure is a sequence of 
data items.  Each item is of type INT32, and there is one data item
per axis of motion reported by the device.  
The number of axes reported
by the device is returned in the axis_count variable.
.LP
The value of the data items depends on the mode of the device, which
is returned in the mode variable.
If the mode is Absolute, the data items are the raw values 
generated by the device.  These may be scaled by the client program 
using the maximum values that the device can generate for each axis 
of motion that it reports.  The maximum and minimum values for each 
axis are reported by the \fBListInputDevices\fP request.
.LP
If the mode is Relative, the data items are the relative values
generated by the device.  The client program must choose an initial
position for the device and maintain a current position by 
accumulating these relative values.
.NH 2
Changing The Core Devices
.XS
\*(SN Changing The Core Devices
.XE
.LP
These requests are provided to change which physical device is used
as the X pointer or X keyboard.
.NT
Using these requests may change the characteristics of the core devices.
The new pointer device may have a different number of buttons than the 
old one did, or the new keyboard device may have a different number of
keys or report a different range of keycodes.  Client programs may be
running that depend on those characteristics.  For example, a client
program could allocate an array based on the number of buttons on the
pointer device, and then use the button numbers received in button events
as indicies into that array.  Changing the core devices could cause
such client programs to behave improperly or abnormally terminate.
.NE
.LP
These requests change the X keyboard or X pointer device and generate
an \fBChangeDeviceNotify\fP event and a \fBMappingNotify\fP event.  
The \fBChangeDeviceNotify\fP event is sent only to those clients that have 
expressed an interest in receiving that event via the 
\fBXSelectExtensionEvent\fP request.
The specified device becomes the
new X keyboard or X pointer device.  The location of the core device
does not change as a result of this request.
.LP
These requests fail and return \fBAlreadyGrabbed\fP if either the specified
device or the core device it would replace are grabbed by some other
client.  They fail and return \fBGrabFrozen\fP if either device is frozen
by the active grab of another client.
.LP
These requests fail with a \fBBadDevice\fP error if the specified device is
invalid, or has not previously been opened via \fBOpenDevice\fP.
.sp 2
To change the X keyboard device, use the \fBChangeKeyboardDevice\fP request.
The specified device must support input class Keys (as reported in the
ListInputDevices request) or the request will fail with a \fBBadMatch\fP error.
Once the device has successfully replaced one of the core devices, it
is treated as a core device until it is in turn replaced by another
ChangeDevice request, or until the server terminates.  The termination
of the client that changed  the device will not cause it to change back.
Attempts to use the CloseDevice request to close the new core device will
fail with a BadDevice error.
.LP
The focus state of the new keyboard is the same as the focus state of the old 
X keyboard.  If the new keyboard was not initialized with a \fBFocusRec\fP,
one is added by the \fBChangeKeyboardDevice\fP request.  The X keyboard is 
assumed to have a \fBKbdFeedbackClassRec\fP.  If the device was initialized
without a \fBKbdFeedbackClassRec\fP, one will be added by this request.
The \fBKbdFeedbackClassRec\fP will specify a null routine as the control 
procedure and the bell procedure.
.sp 1.5
ChangeKeyboardDevice 
.in .5i
device: DEVICE
.br
.sp
Errors: Device, Match
.br
.in -.5i
=>
.br
.in +.5i
status: Success, AlreadyGrabbed, Frozen
.br
.sp 1.5
.LP
To change the X pointer device, use the \fBChangePointerDevice\fP request.
The specified device must support input class Valuators (as reported in the
ListInputDevices request) or the request will fail with a BadMatch error.
The valuators to be used as the x- and y-axes of the pointer device must
be specified.  Data from other valuators on the device will be ignored.
.LP
The X pointer device does not contain a \fBFocusRec\fP.  If the new
pointer was initialized with a \fBFocusRec\fP, it is freed by the 
\fBChangePointerDevice\fP request.  The X pointer is assumed to have a
\fBButtonClassRec\fP and a \fBPtrFeedbackClassRec\fP.  If the device
was initialized without a \fBButtonClassRec\fP or a \fBPtrFeedbackClassRec\fP,
one will be added by this request.  The \fBButtonClassRec\fP added will
have no buttons, and the \fBPtrFeedbackClassRec\fP will specify a null
routine as the control procedure.
.LP
If the specified device reports absolute positional information, and the 
server implementation does not allow such a device to be used as the 
X pointer, the request will fail with a \fBBadDevice\fP error.
.LP
Once the device has successfully replaced one of the core devices, it
is treated as a core device until it is in turn replaced by another
ChangeDevice request, or until the server terminates.  The termination
of the client that changed  the device will not cause it to change back.
Attempts to use the CloseDevice request to close the new core device will
fail with a BadDevice error.
.sp 1.5
ChangePointerDevice 
.in .5i
device: DEVICE
.br
xaxis: CARD8
.br
yaxis: CARD8
.sp
Errors: Device, Match
.br
.in -.5i
=>
.br
.in +.5i
status: Success, AlreadyGrabbed, Frozen
.br
.sp 1.5
.NH 2
Event Synchronization And Core Grabs
.XS
\*(SN Event Synchronization And Core Grabs
.XE
.LP
Implementation of the input extension requires an extension of the
meaning of event synchronization for the core grab requests.  This is
necessary in order to allow window managers to freeze all input devices
with a single request.
.LP
The core grab requests require a \fBpointer_mode\fP and \fBkeyboard_mode\fP
argument.  The meaning of these modes is changed by the input extension.
For the \fBXGrabPointer\fP and \fBXGrabButton\fP requests, \fBpointer_mode\fP
controls synchronization of the pointer device, and \fBkeyboard_mode\fP
controls the synchronization of all other input devices.  
For the \fBXGrabKeyboard\fP
and \fBXGrabKey\fP requests, \fBpointer_mode\fP controls the synchronization
of all input devices except the X keyboard, while \fBkeyboard_mode\fP controls
the synchronization of the keyboard.  When using one of the core grab
requests, the synchronization of extension devices
is controlled by the mode specified for the device not being grabbed.
.NH 2
Extension Active Grabs
.XS
\*(SN Extension Active Grabs
.XE
.LP
Active grabs of extension devices are supported via the \fBGrabDevice\fP
request in the same way that core devices are grabbed using the core 
GrabKeyboard request, except that a \fIDevice\fP is passed as
a function parameter.  A list of events that the client wishes to 
receive is also passed.  The \fBUngrabDevice\fP request allows a
previous active grab for an extension device to be released.
.LP
To grab an extension device, use the \fBGrabDevice\fP request.
The device must have previously been opened using the \fBOpenDevice\fP 
request.
.sp 1.5
GrabDevice 
.br
.in .5i
device: DEVICE
.br
grab-window: WINDOW
.br
owner-events: BOOL
.br
event-list: LISTofEVENTCLASS
.br
this-device-mode: {Synchronous, Asynchronous}
.br
other-device-mode: {Synchronous, Asynchronous}
.br
time:TIMESTAMP or CurrentTime
.br
.in -.5i
=>
.br
.in +.5i
status: Success, AlreadyGrabbed, Frozen, InvalidTime, NotViewable
.br
.sp
Errors:  Device, Window, Value
.br
.in -.5i
.sp 1.5
.LP
This request actively grabs control of the specified input device.  Further 
input events from this device are reported only to the grabbing client. 
This request overrides any previous active grab by this client for this
device.
.LP
The event-list parameter is a pointer to a list of event classes.  These
are used to indicate which events the client wishes to receive while the 
device is grabbed.  Only event classes obtained from the grabbed device
are valid.
.LP
If owner-events is \fBFalse\fP, input events generated from this 
device are reported with respect to grab-window, and are only reported if
selected by being included in the event-list.
If owner-events is 
\fBTrue\fP, then if a generated event would normally be reported to this 
client, it is reported normally, otherwise the event is reported with 
respect to the grab-window, and is only reported if selected by being
included in the event-list.  For either value of owner-events, unreported
events are discarded.
.LP
If this-device-mode is \fBAsynchronous\fP, device event processing continues 
normally.  If the device is currently frozen by this client, then processing 
of device events is resumed.  If this-device-mode is \fBSynchronous\fP, 
the state of the grabbed device (as seen by means of the protocol) appears 
to freeze,
and no further device events are generated by the server until the grabbing 
client issues a releasing \fBAllowDeviceEvents\fP request or until the device 
grab is released.  Actual device input events are not lost while the device 
is frozen; they are simply queued for later processing.
.LP
If other-device-mode is \fBAsynchronous\fP, event processing is 
unaffected by activation of the grab.  If other-device-mode is 
\fBSynchronous\fP, the state of all input devices except the grabbed one
(as seen by means of the protocol) appears to 
freeze, and no further events are generated by the server until 
the grabbing client issues a releasing \fBAllowDeviceEvents\fP request or 
until the device grab is released.  Actual events are not lost
while the devices are frozen; they are simply queued for later
processing.
.LP
This request generates \fBDeviceFocusIn\fP and \fBDeviceFocusOut\fP events.  
.LP
This request fails and returns:
.IP \(bu 3n
\fBAlreadyGrabbed\fP
If the device is actively grabbed by some other client.
.IP \(bu 3n
\fBNotViewable\fP
If grab-window is not viewable.
.IP \(bu 3n
\fBInvalidTime\fP
If the specified time is earlier
than the last-grab-time for the specified device
or later than the current X server time. Otherwise,
the last-grab-time for the specified device is set
to the specified time and 
\fBCurrentTime\fP
is replaced by the current X server time.
.IP \(bu 3n
\fBFrozen\fP
If the device is frozen by an active grab of another client.
.LP
If a grabbed device is closed by a client while an active grab by that 
client is in
effect, that active grab will be released.  Any passive grabs established by
that client will be released.  If the device is frozen only by an active grab
of the requesting client, it is thawed.
.LP
To release a grab of an extension device, use \fBUngrabDevice\fP.
.sp 1.5
UngrabDevice 
.br
.in .5i
device: DEVICE
.br
time: TIMESTAMP or CurrentTime
.br
.sp
Errors:  Device
.br
.in -.5i
.sp 1.5
.LP
This request releases the device if this client has it actively grabbed
(from either \fBGrabDevice\fP or \fBGrabDeviceKey\fP) and releases
any queued events.  If any devices were frozen by the grab,
\fBUngrabDevice\fP thaws them.
The request has no effect if the specified time is earlier 
than the last-device-grab time or is later than the current server time.  
.LP
This request generates \fBDeviceFocusIn\fP and \fBDeviceFocusOut\fP events.  
.LP
An \fBUngrabDevice\fP is performed automatically if the event window for an
active device grab becomes not viewable.
.NH 2
Passively Grabbing A Key
.XS
\*(SN Passively Grabbing A Key
.XE
.LP
Passive grabs of buttons and keys on extension devices are supported
via the \fBGrabDeviceButton\fP and \fBGrabDeviceKey\fP requests.
These passive grabs are released via the \fBUngrabDeviceKey\fP and
\fBUngrabDeviceButton\fP requests.
.LP
To passively grab a single key on an extension device, use \fBGrabDeviceKey\fP.
That device must have previously been opened using the \fBOpenDevice\fP 
request.
.sp 1.5
GrabDeviceKey 
.br
.LP
.in .5i
device: DEVICE
.br
keycode: KEYCODE or AnyKey
.br
modifiers: SETofKEYMASK or AnyModifier
.br
modifier-device: DEVICE or NULL
.br
grab-window: WINDOW
.br
owner-events: BOOL
.br
event-list: LISTofEVENTCLASS
.br
this-device-mode: {Synchronous, Asynchronous}
.br
other-device-mode: {Synchronous, Asynchronous}
.br
.sp
Errors:  Device, Match, Access, Window, Value
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBGrabKey\fP request.  It establishes a 
passive grab on a device.  Consequently, In the future:
.IP \(bu 3n
IF the device is not grabbed and the specified key, which itself can be a 
modifier key, is logically pressed when the specified modifier keys 
logically are down on the specified modifier device (and no other 
keys are down),
.IP \(bu 3n
AND no other modifier keys logically are down,
.IP \(bu 3n
AND EITHER the grab window is an ancestor of (or is) the focus window
OR the grab window is a descendent of the focus window and contains the pointer,
.IP \(bu 3n
AND a passive grab on the same device and key combination does not exist on any
ancestor of the grab window,
.IP \(bu 3n
THEN the device is actively grabbed, as for \fBGrabDevice\fP,
the last-device-grab time is set to the time at which the key was pressed
(as transmitted in the \fBDeviceKeyPress\fP event), and the 
\fBDeviceKeyPress\fP event is reported.
.LP
The interpretation of the remaining arguments is as for \fBGrabDevice\fP.
The active grab is terminated automatically when logical state of the
device has the specified key released (independent of the logical state of the 
modifier keys).
.LP
Note that the logical state of a device (as seen by means of the X protocol)
may lag the physical state if device event processing is frozen.
.LP
A modifier of \fBAnyModifier\fP is equivalent to issuing the request for all
possible modifier combinations (including the combination of no modifiers).  
It is not required that all modifiers specified have currently assigned 
keycodes.
A key of \fBAnyKey\fP is equivalent to issuing
the request for all possible keycodes.  Otherwise, the key must be in
the range specified by min-keycode and max-keycode in the \fBListInputDevices\fP
request.  If it is not within that range, \fBGrabDeviceKey\fP generates a
\fBValue\fP error.
.LP
\fBNULL\fP may be passed for the modifier_device.  If the modifier_device is
\fBNULL\fP, the core X keyboard is used as the modifier_device.
.LP
An \fBAccess\fP error is generated if some other client has issued a 
\fBGrabDeviceKey\fP with the same device and key combination on the 
same window.  When using \fBAnyModifier\fP or \fBAnyKey\fP,
the request fails completely and the X server generates a \fBAccess\fP
error and no grabs are established if there is a conflicting grab for any 
combination.
.LP
This request cannot be used to grab a key on the X keyboard device.  
The core \fBGrabKey\fP request should be used for that purpose.
.LP
To release a passive grab of a single key on an extension device, 
use \fBUngrabDeviceKey\fP.
.sp 1.5
UngrabDeviceKey
.LP
.in .5i
device: DEVICE
.br
keycode: KEYCODE or AnyKey
.br
modifiers: SETofKEYMASK or AnyModifier
.br
modifier-device: DEVICE or NULL
.br
grab-window: WINDOW
.br
.sp
Errors:  Device, Match, Window, Value, Alloc
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBUngrabKey\fP request.  It releases 
the key combination on the specified window if it was grabbed by this 
client.  A modifier of \fBAnyModifier\fP is equivalent to issuing the 
request for all possible modifier combinations (including the combination 
of no modifiers).  A key of \fBAnyKey\fP is equivalent to issuing the 
request for all possible keycodes.  This request has no effect on an 
active grab.
.LP
\fBNULL\fP may be passed for the modifier_device.  If the modifier_device is
\fBNULL\fP, the core X keyboard is used as the modifier_device.
.NH 2
Passively Grabbing A Button
.XS
\*(SN Passively Grabbing A Button
.XE
.LP
To establish a passive grab for a single button on an extension device,
use \fBGrabDeviceButton\fP.
.sp 1.5
GrabDeviceButton 
.LP
.in .5i
device: DEVICE
.br
button: BUTTON or AnyButton
.br
modifiers: SETofKEYMASK or AnyModifier
.br
modifier-device: DEVICE or NULL
.br
grab-window: WINDOW
.br
owner-events: BOOL
.br
event-list: LISTofEVENTCLASS
.br
this-device-mode: {Synchronous, Asynchronous}
.br
other-device-mode: {Synchronous, Asynchronous}
.br
.sp
Errors:  Device, Match, Window, Access, Value
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBGrabButton\fP request.  It 
establishes an explicit passive grab for a button on an extension input 
device.  Since the server does not track extension devices, no cursor is 
specified with this request.  For the same reason, there is no 
confine-to parameter.  The device must have previously been opened using the
\fBOpenDevice\fP request.
.LP
The \fBGrabDeviceButton\fP request establishes a passive grab on a device.
Consequently, in the future, 
.IP \(bu 3n
IF the device is not grabbed and the specified button is logically pressed
when the specified modifier keys logically are down 
(and no other buttons or modifier keys are down),
.IP \(bu 3n
AND the grab window contains the device,
.IP \(bu 3n
AND a passive grab on the same device and button/ key combination does not 
exist on any ancestor of the grab window,
.IP \(bu 3n
THEN the device is actively grabbed, as for \fBGrabDevice\fP,
the last-grab time is set to the time at which the button was pressed
(as transmitted in the \fBDeviceButtonPress\fP event), and the 
\fBDeviceButtonPress\fP event is reported.
.LP
The interpretation of the remaining arguments is as for 
\fBGrabDevice\fP.
The active grab is terminated automatically when logical state of the
device has all buttons released (independent of the logical state of 
the modifier keys).
.LP
Note that the logical state of a device (as seen by means of the X protocol)
may lag the physical state if device event processing is frozen.
.LP
A modifier of \fBAnyModifier\fP is equivalent to issuing the request for all
possible modifier combinations (including the combination of no modifiers).  
It is not required that all modifiers specified have currently assigned 
keycodes.  A button of \fBAnyButton\fP is equivalent to issuing the request 
for all possible buttons.  It is not required that the 
specified button be assigned to a physical button.
.LP
\fBNULL\fP may be passed for the modifier_device.  If the modifier_device is
\fBNULL\fP, the core X keyboard is used as the modifier_device.
.LP
An \fBAccess\fP error is generated if some other client has issued a 
\fBGrabDeviceButton\fP with the same device and button combination on the 
same window.  When using \fBAnyModifier\fP or \fBAnyButton\fP, the request 
fails completely and the X server generates a \fBAccess\fP
error and no grabs are established if there is a conflicting grab for any 
combination.  The request has no effect on an active grab.
.LP
This request cannot be used to grab a button on the X pointer
device.  The core \fBGrabButton\fP request should be used for that
purpose.
.LP
To release a passive grab of a button on an extension device, use 
\fBUngrabDeviceButton\fP.
.sp 1.5
UngrabDeviceButton
.br
.LP
.in .5i
device: DEVICE
.br
button: BUTTON or AnyButton
.br
modifiers: SETofKEYMASK or AnyModifier
.br
modifier-device: DEVICE or NULL
.br
grab-window: WINDOW
.br
.sp
.br
Errors:  Device, Match, Window, Value, Alloc
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core UngrabButton request.  It releases 
the passive button/key combination on the specified window if it was grabbed
by the client.  A modifiers of \fBAnyModifier\fP is equivalent to issuing the
request for all possible modifier combinations (including the combination
of no modifiers).  A button of \fBAnyButton\fP is equivalent to issuing the
request for all possible buttons.  This request has no effect on an
active grab. The device must have previously been opened using the
\fBOpenDevice\fP request otherwise a \fBDevice\fP error will be 
generated.
.LP
\fBNULL\fP may be passed for the modifier_device.  If the modifier_device is
\fBNULL\fP, the core X keyboard is used as the modifier_device.
.LP
This request cannot be used to ungrab a button on the X pointer
device.  The core \fBUngrabButton\fP request should be used for that 
purpose.
.NH 2
Thawing A Device
.XS
\*(SN Thawing A Device
.XE
.LP
To allow further events to be processed when a device has been frozen,
use \fBAllowDeviceEvents\fR.
.sp 1.5
AllowDeviceEvents 
.br
.in .5i
device: DEVICE
.br
event-mode: {AsyncThisDevice, SyncThisDevice, AsyncOtherDevices, 
ReplayThisdevice, AsyncAll, or SyncAll}
.br
time:TIMESTAMP or CurrentTime
.br
.sp
Errors:  Device, Value
.br
.in -.5i
.sp 1.5
.LP
The \fBAllowDeviceEvents\fP request releases some queued events if the client
has caused a device to freeze.  The request has no effect if the 
specified time is earlier than the last-grab time of the most recent 
active grab for the client, or if the specified time is later than the 
current X server time.
.LP
The following describes the processing that occurs depending on what constant
you pass to the event-mode argument:
.IP \(bu 3n \fBAsyncThisDevice\fP
If the specified device is frozen by the client,
event processing for that device
continues as usual.  If the device is frozen multiple times  by the client on 
behalf of multiple separate grabs, AsyncThisDevice thaws for all.
AsyncThisDevice has no effect if the specified device is not frozen by the 
client, but the device need not be grabbed by the client.
.IP \(bu 3n \fBSyncThisDevice\fP 
If the specified device is frozen and actively grabbed by the client,
event processing for that device continues normally until the next 
button or key event is reported to the client.
At this time, 
the specified device again appears to freeze.
However, if the reported event causes the grab to be released,
the specified device does not freeze.
SyncThisDevice has no effect if the specified device is not frozen by the client
or is not grabbed by the client.
.IP \(bu 3n \fBReplayThisDevice\fP
If the specified device is actively grabbed by the client and is frozen 
as the result of an event having been sent to the client (either from the 
activation of a GrabDeviceButton or from a previous AllowDeviceEvents with 
mode SyncThisDevice, but not from a Grab),
the grab is released and that event is completely reprocessed.
This time, however, the request ignores any passive grabs at or above 
(towards the root) the grab-window of the grab just released.
The request has no effect if the specified device is not grabbed by the client
or if it is not frozen as the result of an event.
.IP \(bu 3n \fBAsyncOtherDevices\fP
If the remaining devices are frozen by the client,
event processing for them continues as usual.
If the other devices are frozen multiple times  by the client on behalf of 
multiple separate grabs,
AsyncOtherDevices ``thaws'' for all.
AsyncOtherDevices has no effect if the devices are not frozen by the client,
but those devices need not be grabbed by the client.
.IP \(bu 3n \fBSyncAll\fP
If all devices are frozen by the client,
event processing (for all devices) continues normally until the next
button or key event is reported
to the client for a grabbed device (button event for the grabbed device, key
or motion event for the device), at which time the devices again appear to
freeze.  However, if the reported event causes the grab to be released,
then the devices do not freeze (but if any device is still
grabbed, then a subsequent event for it will still cause all devices
to freeze).  
SyncAll has no effect unless all devices
are frozen by the client.  If any device is frozen twice
by the client on behalf of two separate grabs, 
SyncAll "thaws" for both (but a subsequent freeze for SyncAll
will only freeze each device once).
.IP \(bu 3n \fBAsyncAll\fP
If all devices are frozen by the
client, event processing (for all devices) continues normally.
If any device is frozen multiple times by the client on behalf of multiple
separate grabs, AsyncAll "thaws" for all.
AsyncAll has no effect unless all
devices are frozen by the client.
.LP
AsyncThisDevice, SyncThisDevice, and ReplayThisDevice 
have no effect on the processing of events from the remaining devices.
AsyncOtherDevices has no effect on the processing of events from the 
specified device.
When the event_mode is SyncAll or AsyncAll, the 
device parameter is ignored.
.LP
It is possible for several grabs of different devices (by the same 
or different clients) to be active simultaneously.
If a device is frozen on behalf of any grab,
no event processing is performed for the device.
It is possible for a single device to be frozen because of several grabs.
In this case,
the freeze must be released on behalf of each grab before events can 
again be processed.
.LP
.NH 2
Controlling Device Focus
.XS
\*(SN Controlling Device Focus
.XE
.LP
The current focus window for an extension input device can be 
determined using the \fBGetDeviceFocus\fP request.
Extension devices are focused using the \fBSetDeviceFocus\fP
request in the same way that the keyboard is focused using
the \fBSetInputFocus\fP request, except that a device is specified as
part of the request. One additional focus state, \fBFollowKeyboard\fP,
is provided for extension devices.
.LP
To get the current focus state, revert state, and focus time of an extension device,
use \fBGetDeviceFocus\fP.
.sp 1.5
GetDeviceFocus
.br
.LP
.in .5i
device: DEVICE
.br
.in -.5i
=>
.in +.5i
focus: WINDOW, PointerRoot, FollowKeyboard, or None
.br
revert-to: Parent, PointerRoot, FollowKeyboard, or None
.br
focus-time: TIMESTAMP
.br
.sp
Errors:  Device, Match
.br
.in -.5i
.sp 1.5
.LP
This request returns the current focus state, revert-to state, 
and last-focus-time of an extension device.
.LP
To set the focus of an extension device, use \fBSetDeviceFocus\fP.
.sp 1.5
SetDeviceFocus 
.br
.in .5i
device: DEVICE
.br
focus: WINDOW, PointerRoot, FollowKeyboard, or None
.br
revert-to: Parent, PointerRoot, FollowKeyboard, or None
.br
focus-time: TIMESTAMP
.br
.sp
Errors:  Device, Window, Value, Match
.br
.in -.5i
.sp 1.5
.LP
This request changes the focus for an extension input device and the 
last-focus-change-time.  The request has no effect if the specified 
time is earlier than the last-focus-change-time or is later than the
current X server time.  Otherwise, the last-focus-change-time is set to the
specified time, with CurrentTime replaced by the current server time.
.LP
The action taken by the server when this request is requested depends
on the value of the focus argument:
.IP \(bu 3n
If the focus argument is \fBNone\fP, all input events from this device
will be discarded until a new focus window is set.  In this case, the
revert-to argument is ignored.
.IP \(bu 3n
If a window ID is assigned to the focus argument, it becomes the focus
window of the device.  If an input event from the device would normally
be reported to this window or to one of its inferiors, the event is 
reported normally.  Otherwise, the event is reported relative to the focus 
window.
.IP \(bu 3n
If you assign \fBPointerRoot\fP to the focus argument, the focus window is 
dynamically taken to be the root window of whatever screen the pointer is
on at each input event.  In this case, the revert-to argument is ignored.
.IP \(bu 3n
If you assign \fBFollowKeyboard\fP to the focus argument, the focus window is 
dynamically taken to be the same as the focus of the X keyboard at each
input event.
.LP
The specified focus window must be viewable at the time of the request 
(else a \fBMatch\fP error).  If the focus window later becomes not viewable, 
the X server evaluates the revert-to argument
to determine the new focus window.
.IP \(bu 3n
If you assign \fBRevertToParent\fP
to the revert-to argument, the focus reverts to the parent
(or the closest viewable ancestor), and the new revert-to value is taken to
be \fBRevertToNone\fP.
.IP \(bu 3n
If you assign \fBRevertToPointerRoot\fP, \fBRevertToFollowKeyboard\fP, or \fBRevertToNone\fP
to the revert-to argument, the focus reverts to that value.
.LP
When the focus reverts,
the X server generates \fBDeviceFocusIn\fP
and \fBDeviceFocusOut\fP
events, but the last-focus-change time is not affected.
.LP
This request causes the X server to generate \fBDeviceFocusIn\fP and 
\fBDeviceFocusOut\fP events.
.NH 2
Controlling Device Feedback
.XS
\*(SN Controlling Device Feedback
.XE
.LP
To get the settings of feedbacks on an extension device, use
\fBGetFeedbackControl\fP.   This request provides functionality equivalent to
the core \fBGetKeyboardControl\fP and \fBGetPointerControl\fP functions.  It
also provides a way to control displays associated with an input device that
are capable of displaying an integer or string.
.sp 1.5
GetFeedbackControl 
.br
.in .5i
device: DEVICE
.br
.in -.5i
=>
.in +.5i
num_feedbacks_return: CARD16
.br
return_value: LISTofFEEDBACKSTATE
.br
.sp
where
.br
.in +.5i
.TS
l lw(4i).
T{
FEEDBACKSTATE:
T}	T{
{KbdFeedbackState, PtrFeedbackState, IntegerFeedbackState, StringFeedbackState, BellFeedbackState, LedFeedbackState}
T}
.TE
.in -1.0i
.LP
Feedbacks are reported by class.  Those
feedbacks that are reported for the core keyboard device are in class
\fBKbdFeedback\fP, and are returned in the 
\fBKbdFeedbackState\fP structure.  The members of that structure are as follows:
.in +.5i
.TS
l lw(4i).
T{
CLASS Kbd:
T}	T{
[class: CARD8
.br 
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ key_click_percent: CARD8
.br
\ bell_percent: CARD8
.br
\ bell_pitch: CARD16
.br
\ bell_duration: CARD16
.br
\ led_value: BITMASK
.br
\ global_auto_repeat: {AutoRepeatModeOn, AutoRepeatModeOff}
.br
\ auto_repeats: LISTofCARD8]
T}
.TE
.in -.5i
.LP
Those feedbacks that are equivalent to those reported for the core pointer
are in feedback class \fBPtrFeedback\fP and are reported in the 
\fBPtrFeedbackState\fP structure.  The members of that structure are:
.LP
.in +.5i
.TS
l lw(4i).
T{
CLASS Ptr:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ accelNumerator: CARD16
.br
\ accelDenominator: CARD16
.br
\ threshold: CARD16]
T}
.TE
.in -.5i
.LP
Some input devices provide a means of displaying an integer.  Those devices
will support feedback class \fBIntegerFeedback\fP, which is reported in the 
\fBIntegerFeedbackState\fP structure.  The members of that structure are:
.LP
.br
.sp
.in +.5i
.TS
l lw(4i).
T{
CLASS Integer:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ resolution: CARD32
.br
\ min-val: INT32
.br
\ max-val: INT32]
T}
.TE
.in -.5i
.br
.LP
Some input devices provide a means of displaying a string.  Those devices
will support feedback class \fBStringFeedback\fP, which is reported in the 
\fBStringFeedbackState\fP structure.  The members of that structure are:
.LP
.in +.5i
.TS
l lw(4i).
T{
CLASS String:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ max_symbols: CARD16
.br
\ num_keysyms_supported: CARD16
.br
\ keysyms_supported: LISTofKEYSYM]
T}
.TE
.in -.5i
.br
.LP
Some input devices contain a bell.  Those devices
will support feedback class \fBBellFeedback\fP, which is reported in the 
\fBBellFeedbackState\fP structure.  The members of that structure are:
.LP
.sp
.in +.5i
.TS
l lw(4i).
T{
CLASS Bell:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ percent: CARD8
.br
\ pitch: CARD16
.br
\ duration: CARD16]
T}
.TE
.in -.5i
.br
.sp
The percent sets the base volume for the bell between 0 (off) and 100
(loud) inclusive, if possible.  Setting to \-1 restores the default.
Other negative values generate a \fBValue\fP error.
.LP
The pitch sets the pitch (specified in Hz) of the bell, if possible.
Setting to \-1 restores the default.  Other negative values generate a 
\fBValue\fP error.
.LP
The duration sets the duration (specified in milliseconds) of the
bell, if possible.  Setting to \-1 restores the default.
Other negative values generate a \fBValue\fP error.
.LP
A bell generator connected with the console but not directly on the
device is treated as if it were part of the device.
Some input devices contain LEDs.  Those devices
will support feedback class \fBLed\fP, which is reported in the 
\fBLedFeedbackState\fP structure.  The members of that structure are:
.LP
.sp
.in +.5i
.TS
l lw(4i).
T{
CLASS Led:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ led_mask: BITMASK
.br
\ led_value: BITMASK]
T}
.TE
.in -.5i
.br
.LP
Each bit in led_mask indicates that the corresponding led is supported by
the feedback.  At most 32 LEDs per feedback are supported.  
No standard interpretation of LEDs is defined.
.LP
This function will fail with a \fBBadMatch\fP error if the device specified 
in the request does not support feedbacks.
.LP
Errors:  Device, Match
.LP
To change the settings of a feedback on an extension device, use
\fBChangeFeedbackControl\fP.
.sp 1.5
ChangeFeedbackControl 
.br
.in .5i
device: DEVICE
.br
feedbackid: CARD8
.br
value-mask: BITMASK
.br
value: FEEDBACKCONTROL
.br
.sp
Errors:  Device, Match, Value
.br
.in -.5i
.sp 1.5
.TS
l lw(4i).
.sp
T{
FEEDBACKCONTROL:
T}	T{
{KBDFEEDBACKCONTROL, PTRFEEDBACKCONTROL, INTEGERFEEDBACKCONTROL,
STRINGFEEDBACKCONTROL, BELLFEEDBACKCONTROL, LEDFEEDBACKCONTROL}
T}
.TE
.br
.LP
Feedback controls are grouped by class.  Those feedbacks that are 
equivalent to those supported by the core keyboard are controlled
by feedback class \fBKbdFeedbackClass\fP using the \fBKbdFeedbackControl\fP
structure.  The members of that structure are:
.in +.5i
.TS
l lw(4i).
T{
KBDFEEDBACKCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ key_click_percent: INT8
.br
\ bell_percent: INT8
.br
\ bell_pitch: INT16
.br
\ bell_duration: INT16
.br
\ led_mask: INT32
.br
\ led_value: INT32
.br
\ key: KEYCODE
.br
\ auto_repeat_mode: {AutoRepeatModeOn,
.br
\ \ AutoRepeatModeOff, AutoRepeatModeDefault}]
T}
.TE
.in -.5i
.LP
The key_click_percent sets the volume for key clicks between 0 (off) and
100 (loud) inclusive, if possible.  Setting to \-1 restores the default.
Other negative values generate a \fBValue\fP error.
.LP
If both auto_repeat_mode and key are specified, then the auto_repeat_mode 
of that key is changed, if possible.  If only auto_repeat_mode is specified,
then the global auto-repeat mode for the entire keyboard is changed,
if possible, without affecting the per-key settings.  It is a \fBMatch\fP
error if a key is specified without an auto_repeat_mode.
.LP
The order in which controls are verified and altered is server-dependent.
If an error is generated, a subset of the controls may have been altered.
.LP
Those feedback controls equivalent to those of the core pointer are 
controlled by feedback class \fBPtrFeedbackClass\fP using the 
\fBPtrFeedbackControl\fP
structure.  The members of that structure are as follows:
.LP
.in +.5i
.TS
l lw(4i).
T{
PTRFEEDBACKCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ accelNumerator: INT16
.br
\ accelDenominator: INT16
.br
\ threshold: INT16]
T}
.TE
.in -.5i
.LP
The acceleration, expressed as a fraction, is a multiplier 
for movement. For example, specifying 3/1 means the device moves three 
times as fast as normal.  The fraction may be rounded arbitrarily by the 
X server.  Acceleration only takes effect if the device moves more than 
threshold pixels at once and only applies to the amount beyond the value 
in the threshold argument.  Setting a value to -1 restores the default.
The values of the do-accel and do-threshold arguments must be nonzero for
the device values to be set.  Otherwise, the parameters will be unchanged.
Negative values generate a \fBValue\fP error, as does a zero value
for the accel-denominator argument.
.LP
Some devices are capable of displaying an integer.  This is done using
feedback class \fBIntegerFeedbackClass\fP using the \fBIntegerFeedbackControl\fP
structure.  The members of that structure are as follows:
.sp
.in +.5i
.TS
l lw(4i).
T{
INTEGERCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ int_to_display: INT32]
T}
.TE
.in -.5i
.LP
Some devices are capable of displaying an string.  This is done using
feedback class \fBStringFeedbackClass\fP using the \fBStringFeedbackCtl\fP
structure.  The members of that structure are as follows:
.sp
.in +.5i
.TS
l lw(4i).
T{
STRINGCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ syms_to_display: LISTofKEYSYMS]
T}
.TE
.in -.5i
.LP
Some devices contain a bell.  This is done using
feedback class \fBBellFeedbackClass\fP using the \fBBellFeedbackControl\fP
structure.  The members of that structure are as follows:
.sp
.in +.5i
.TS
l lw(4i).
T{
BELLCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ percent: INT8
.br
\ pitch: INT16
.br
\ duration: INT16]
T}
.TE
.in -.5i
.LP
Some devices contain leds.  These can be turned on and off using
the \fBLedFeedbackControl\fP
structure.  The members of that structure are as follows:
.sp
.in +.5i
.TS
l lw(4i).
T{
LEDCTL:
T}	T{
[class: CARD8
.br
\ length: CARD16
.br
\ feedback id: CARD8
.br
\ led_mask: BITMASK
.br
\ led_value: BITMASK]
T}
.TE
.in -.5i
.LP
Errors:  Device, Match, Value
.LP
.NH 2
Ringing a Bell on an Input Device
.XS
\*(SN Ringing a Bell on an Input Device
.XE
.LP
To ring a bell on an extension input device, use \fBDeviceBell\fP.
.sp 1.5
DeviceBell
.br
.LP
.in .5i
device: DEVICE
.br
feedbackclass: CARD8
.br
feedbackid: CARD8
.br
percent: INT8
.br
.sp
Errors: Device, Value
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBBell\fP request.  It rings the 
specified bell on the specified input device feedback, using the specified
volume.
The specified volume is relative to the base volume for the feedback.
If the value for the percent argument is not in the range -100 to 100
inclusive, a \fBValue\fP error results.
The volume at which the bell rings when the percent argument is nonnegative is:
.LP
.DS
	  base - [(base * percent) / 100] + percent
.DE
.LP
The volume at which the bell rings
when the percent argument is negative is:
.DS
	  base + [(base * percent) / 100]
.DE
.LP
To change the base volume of the bell, use \fBChangeFeedbackControl\fP request.
.LP
.NH 2
Controlling Device Encoding
.XS
\*(SN Controlling Device Encoding
.XE
.LP
To get the keyboard mapping of an extension device that has keys, use 
\fBGetDeviceKeyMapping\fP.
.sp 1.5
GetDeviceKeyMapping
.br
.LP
.in .5i
device: DEVICE
.br
first-keycode: KEYCODE
.br
count: CARD8
.br
.in -.5i
=>
.in +.5i
keysyms-per-keycode: CARD8
.br
keysyms: LISTofKEYSYM
.br
.sp
Errors: Device, Match, Value
.br
.in -.5i
.sp 1.5
.LP
This request returns the symbols for the specified number of keycodes for the 
specified extension device, starting with the specified keycode.
The first-keycode must be greater than or equal to
min-keycode as returned in the connection setup (else a \fBValue\fP error),
and
.LP
.DS
first-keycode + count \- 1
.DE
.LP
must be less than or equal to max-keycode as returned in the connection setup
(else a \fBValue\fP error).
The number of elements in the keysyms list is
.LP
.DS
count * keysyms-per-keycode
.DE
and KEYSYM number N (counting from zero) for keycode K has an index
(counting from zero) of
.LP
.DS
(K \- first-keycode) * keysyms-per-keycode + N
.DE
.LP
in keysyms.
The keysyms-per-keycode value is chosen arbitrarily by the server
to be large enough to report all requested symbols.
A special KEYSYM value of
\fBNoSymbol\fP
is used to fill in unused elements for individual keycodes.
.LP
If the specified device has not first been opened by this client via
\fBOpenDevice\fP, or if that device does not support input class Keys,
this request will fail with a \fBDevice\fP error.
.LP
To change the keyboard mapping of an extension device that has keys, use 
\fBChangeDeviceKeyMapping\fP.
.sp 1.5
ChangeDeviceKeyMapping
.br
.in .5i
device: DEVICE
.br
first-keycode: KEYCODE
.br
keysyms-per-keycode: CARD8
.br
keysyms: LISTofKEYSYM
.br
num_codes: CARD8
.br
.sp
Errors:  Device, Match, Value, Alloc
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBChangeKeyMapping\fP request.  
It defines the symbols for the specified number of keycodes for the 
specified extension device.
If the specified device has not first been opened by this client via
\fBOpenDevice\fP, or if that device does not support input class Keys,
this request will fail with a \fBDevice\fP error.
.LP
The number of elements in the keysyms list must be a multiple of
keysyms_per_keycode.  Otherwise, \fBChangeDeviceKeyMapping\fP generates
a \fBLength\fP error.  The specified first_keycode must be greater
than or equal to the min_keycode value returned by the \fBListInputDevices\fP
request, or this request will fail with a \fBValue\fP error.  In addition,
if the following expression is not less than the max_keycode value returned by
the \fBListInputDevices\fP request, the request will fail with a \fBValue\fP
error:
.LP
.DS
	  first_keycode + (num_codes / keysyms_per_keycode) - 1
.DE
.LP
To obtain the keycodes that are used as modifiers on an 
extension device that has keys, use \fBGetDeviceModifierMapping\fP.
.sp 1.5
GetDeviceModifierMapping
.br
.in .5i
device: DEVICE
.br
.in -.5i
=>
.br
.in +.5i
keycodes-per-modifier: CARD8
.br
keycodes: LISTofKEYCODE
.br
.sp
Errors:  Device, Match
.br
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBGetModifierMapping\fP request.  
This request returns the keycodes of the keys being used as modifiers.
The number of keycodes in the list is 8*keycodes-per-modifier.
The keycodes are divided into eight sets, with each set containing 
keycodes-per-modifier elements.  The sets are assigned in order to the 
modifiers \fBShift\fP, \fBLock\fP, \fBControl\fP, \fBMod1\fP, \fBMod2\fP,
\fBMod3\fP, \fBMod4\fP, and \fBMod5\fP. The keycodes-per-modifier value is 
chosen arbitrarily by the server; zeroes are used to fill in unused elements 
within each set.  If only zero values are given in a set, the use of the 
corresponding modifier has been disabled.  The order of keycodes within 
each set is chosen arbitrarily by the server.
.LP
To set which keycodes that are to be used as modifiers for an extension
device, use \fBSetDeviceModifierMapping\fP.
.sp 1.5
SetDeviceModifierMapping
.br
.LP
.in .5i
device: DEVICE
.br
keycodes-per-modifier: CARD8
.br
keycodes: LISTofKEYCODE
.br
.in -.5i
=>
.br
.in +.5i
status: {Success, Busy, Failed}
.br
.sp
Errors:  Device, Match, Value, Alloc
.in -.5i
.sp 1.5
.LP
This request is analogous to the core \fBSetModifierMapping\fP request.  
This request specifies the keycodes (if any) of the keys to be used as
modifiers.  The number of keycodes in the list must be 
8*keycodes-per-modifier (else a \fBLength\fP error).  The keycodes are 
divided into eight sets, with the sets, with each set containing 
keycodes-per-modifier elements.  The sets are assigned in order to the 
modifiers \fBShift\fP, \fBLock\fP, \fBControl\fP, \fBMod1\fP, \fBMod2\fP,
\fBMod3\fP, \fBMod4\fP, and \fBMod5\fP.  Only non-zero keycode values are 
used within each set; zero values are ignored.  All of the non-zero 
keycodes must be in the range specified by min-keycode and max-keycode 
in the \fBListInputDevices\fP request (else a \fBValue\fP error).  The order of 
keycodes within a set does not matter.  If no non-zero values are specified 
in a set, the use of the corresponding modifier is disabled, and the 
modifier bit will always be zero.  Otherwise, the modifier bit will be 
one whenever at least one of the keys in the corresponding set is in the down
position.
.LP
A server can impose restrictions on how modifiers can be changed (for example,
if certain keys do not generate up transitions in hardware or if multiple keys 
per modifier are not supported).  The status reply is \fBFailed\fP
if some such restriction is violated, and none of the modifiers are changed.
.LP
If the new non-zero keycodes specified for a modifier differ from those
currently defined, and any (current or new) keys for that modifier are
logically in the down state, then the status reply is \fBBusy\fP,
and none of the modifiers are changed.
.IP
This request generates a \fPDeviceMappingNotify\fP event on a
\fBSuccess\fP status.  The \fPDeviceMappingNotify\fP event will be sent only
to those clients that have expressed an interest in receiving that event
via the \fBXSelectExtensionEvent\fP request.
.LP
A X server can impose restrictions on how modifiers can be changed, 
for example, if certain keys do not generate up transitions in hardware 
or if multiple modifier keys are not supported.  If some such restriction 
is violated, the status reply is
\fBMappingFailed\fP , and none of the modifiers are changed.
If the new keycodes specified for a modifier differ from those
currently defined and any (current or new) keys for that modifier are
in the logically down state, the status reply is \fBMappingBusy\fP, 
and none of the modifiers are changed.  
.NH 2
Controlling Button Mapping
.XS
\*(SN Controlling Button Mapping
.XE
.LP
These requests are analogous to the core \fBGetPointerMapping\fP
and \fBChangePointerMapping\fP requests.  They allow a client to
determine the current mapping of buttons on an extension device,
and to change that mapping.
.LP
To get the current button mapping for an extension device, use
\fBGetDeviceButtonMapping\fP.
.sp 1.5
GetDeviceButtonMapping 
.br
.in .5i
device: DEVICE
.br
nmap: CARD8
.br
.in -.5i
=>
.in +.5i
map_return: LISTofCARD8
.br
.sp
Errors:  Device, Match
.in -.5i
.br
.sp
.LP
The \fBGetDeviceButtonMapping\fP function returns the current mapping of
the buttons on the specified device.  Elements of the list are indexed
starting from one.  The length of the list indicates the number of 
physical buttons.  The nominal mapping is the identity mapping map[i]=i.
.LP
\fBnmap\fP indicates the number of elements in the \fBmap_return\fP 
array.  Only the first nmap entries will be copied by the library
into the map_return array.
.sp 2
.LP
To set the button mapping for an extension device, use
\fBSetDeviceButtonMapping\fP.
.sp 1.5
SetDeviceButtonMapping 
.br
.in .5i
device: DEVICE
.br
map: LISTofCARD8
.br
nmap: CARD8
.br
.sp
.in -.5i
=>
.in +.5i
status: CARD8
.br
.sp
Errors:  Device, Match, Value
.in -.5i
.br
.sp
.LP
The \fBSetDeviceButtonMapping\fP function sets the mapping of the specified
device and causes the X server to generate a \fBDeviceMappingNotify\fP
event on a status of \fBMappingSuccess\fP.  Elements of the list are
indexed starting from one.  The length of the list,
specified in \fBnmap\fP,
must be the same as
\fBGetDeviceButtonMapping\fP would return.  Otherwise,
\fBSetDeviceButtonMapping\fP generates a \fBValue\fP error.  A zero element
disables a buttons, and elements are not restricted in value by the 
number of physical buttons.  However, no two elements can have the
same nonzero value.  Otherwise, this function generates a
\fBValue\fP error.  If any of the buttons to be altered are in the 
down state, the status reply is \fBMappingBusy\fP and the mapping is
not changed. 
.NH 2
Obtaining The State Of A Device
.XS
\*(SN Obtaining The State Of A Device
.XE
.LP
To obtain vectors that describe the state of the keys, buttons and valuators
of an extension device, use \fBQueryDeviceState\fP.
.sp 1.5
QueryDeviceState 
.br
.in .5i
device: DEVICE
.br
.in -.5i
=>
.in +.5i
device-id: CARD8
.br
data: LISTofINPUTCLASS
.br
.sp
.in -.5i
where
.in +.5i
.br
.TS
l lw(4i).
T{
INPUTCLASS:
T}	T{
{VALUATOR, BUTTON, KEY}
T}
.sp
T{
CLASS VALUATOR:
T}	T{
[class: CARD8
.br
\ num_valuators: CARD8
.br
mode: CARD8
.in +.5i
.br
#x01 device mode
.in +.5i
.br
(0 = Relative, 1 = Absolute)
.br
.in -.5i
#x02 proximity state
.in +.5i
.br
(0 = InProximity, 1 = OutOfProximity)
.in -1.0i
.br
\ valuators: LISTofINT32]
T}
.br
.sp
T{
CLASS BUTTON:
T}	T{
[class: CARD8
.br
\ num_buttons: CARD8
.br
\ buttons: LISTofCARD8]
T}
.br
.sp
T{
CLASS KEY:
T}	T{
[class: CARD8
.br
\ num_keys: CARD8
.br
\ keys: LISTofCARD8]
T}
.TE
.br
.sp
Errors:  Device
.br
.in -.5i
.sp 1.5
.LP
The \fBQueryDeviceState\fP request returns the current logical state of the 
buttons, keys, and valuators on the specified input device.
The \fIbuttons\fP and \fIkeys\fP arrays, byte N (from 0) contains the
bits for key or button 8N to 8N+7 with the least significant bit in the
byte representing key or button 8N.
.LP
If the device has valuators, a bit in the mode field indicates whether the
device is reporting Absolute or Relative data.  If it is reporting Absolute
data, the valuators array will contain the current value of the valuators.
If it is reporting Relative data, the valuators array will contain undefined
data.
.LP
If the device reports proximity information, a bit in the mode field indicates
whether the device is InProximity or OutOfProximity.
.NH 1
Events
.XS
\*(SN Events
.XE
.LP
The input extension creates input events analogous to the core input events.
These extension input events are generated by manipulating one of the
extension input devices.  
.NH 2
Button, Key, and Motion Events
.XS
\*(SN Button, Key, and Motion Events
.XE
.LP
DeviceKeyPress
.br
DeviceKeyRelease
.br
DeviceButtonPress,
.br
DeviceButtonRelease 
.br
DeviceMotionNotify
.LP
.in .5i
device: CARD8
.br
root, event: WINDOW
.br
child: Window or None
.br
same-screen: BOOL
.br
root-x, root-y, event-x, event-y: INT16
.br
detail: <see below>
.br
state: SETofKEYBUTMASK
.br
time: TIMESTAMP
.TE
.in -.5i
.LP
These events are generated when a key, button, or valuator logically changes state.
The generation of these logical changes may lag the physical changes,
if device event processing is frozen.  Note that \fBDeviceKeyPress\fP
and \fBDeviceKeyRelease\fP are generated for all keys, even those mapped to modifier bits.
The ``source'' of the event is the window the pointer is in.
The window with respect to which the event is normally reported is found
by looking up the hierarchy (starting with the source window)
for the first window on which any client has selected interest in the event.
The actual window used for reporting can be modified by active grabs and
by the focus window.The window the event is reported with respect to is called 
the ``event'' window.  
.LP
The root is the root window of the ``source'' window, and root-x and root-y 
are the pointer coordinates relative to root's origin at the time of the event.
Event is the ``event'' window.  If the event window is on the same screen as 
root, then event-x and event-y are the pointer coordinates relative to the
event window's origin.  Otherwise, event-x and event-y are zero.  If the 
source window is an inferior of the event window, then child is set to 
the child of the event window that is an ancestor of (or is) the source window.
Otherwise, it is set to None. The state component gives the logical state of 
the buttons on the core X pointer and modifier keys on the core X keyboard
just before the event.  
The detail component type varies with the event type:
.TS
allbox;
l l.
T{
Event
T}	T{
Component
T}
T{
DeviceKeyPress, 
.br
DeviceKeyRelease
T}	T{
KEYCODE
T}
T{
DeviceButtonPress, 
.br
DeviceButtonRelease
T}	T{
BUTTON
T}
T{
DeviceMotionNotify
T}	T{
{ Normal , Hint }
T}
.TE
.LP
The granularity of motion events is not guaranteed, but a client selecting 
for motion events is guaranteed to get at least one event when a valuator
changes. If \fBDeviceMotionHint\fP is selected, the server is free to send 
only one \fBDeviceMotionNotify\fP event (with detail \fBHint\fP) to the
client for the event window, until either a key or button changes state,
the pointer leaves the event window, or the client issues a
\fBQueryDeviceState\fP or \fBGetDeviceMotionEvents\fP request.
.NH 2
DeviceValuator Event
.XS
\*(SN DeviceValuator Event
.XE
.LP
DeviceValuator
.LP
.in .5i
device: CARD8
.br
device_state: SETofKEYBUTMASK
.br
num_valuators: CARD8
.br
first_valuator: CARD8
.br
valuators: LISTofINT32
.TE
.in -.5i
.LP
DeviceValuator events are generated to contain valuator information for which
there is insufficient space in DeviceKey, DeviceButton, DeviceMotion, and
Proximity wire events.  For events of these types, a second event of type
DeviceValuator follows immediately.  The library combines these events into
a single event that a client can receive via XNextEvent.  DeviceValuator
events are not selected for by clients, they only exist to contain information
that will not fit into some event selected by clients.
.LP
The device_state component gives the state of the 
buttons and modifiers on the device generating the event.  
.LP
Extension motion devices may report motion data for a variable number of 
axes.  The valuators array contains the values of all axes reported by the
device.  If more than 6 axes are reported, more than one DeviceValuator event 
will be sent by the server, and more than one DeviceKey, DeviceButton,
DeviceMotion, or Proximity event will be reported by the library.  
Clients should examine the corresponding fields of the event reported by
the library to determine the total number of axes reported, and the first axis
reported in the current event.  Axes are numbered beginning with zero.
.LP
For Button, Key and Motion events on a device reporting absolute motion data
the current value of the device's valuators is reported.  For devices that
report relative data, Button and Key events may be followed by a DeviceValuator
event that contains 0s in the num_valuators field.   In this case, only the
device_state component will have meaning.
.NH 2
Device Focus Events
.XS
\*(SN Device Focus Events
.XE
.LP
DeviceFocusIn
.br
DeviceFocusOut
.LP
.in .5i
device: CARD8
.br
time: TIMESTAMP
.br
event: WINDOW
.br
mode: { Normal, WhileGrabbed, Grab, Ungrab}
.br
detail: { Ancestor, Virtual, Inferior, Nonlinear, NonlinearVirtual, Pointer, PointerRoot, None}
.br
.in -.5i
.LP
These events are generated when the input focus changes and are reported to 
clients selecting \fBDeviceFocusChange\fP for the specified device and window.
Events generated by \fBSetDeviceFocus\fP when the device is not grabbed
have mode \fBNormal\fP. Events generated by \fBSetDeviceFocus\fP when the 
device is grabbed have mode \fBWhileGrabbed\fP.  Events generated when a 
device grab actives have mode \fBGrab\fP, and events generated when a device
grab deactivates have mode \fBUngrab\fP.  
.LP
All \fBDeviceFocusOut\fP events caused by a window unmap are generated after 
any \fBUnmapNotify\fP event, but the ordering of \fBDeviceFocusOut\fP with
respect to generated \fBEnterNotify\fP, \fBLeaveNotify\fP, 
\fBVisibilityNotify\fP and \fBExpose\fP events is not constrained.
.LP
\fBDeviceFocusIn\fP and \fBDeviceFocusOut\fP events are generated for
focus changes of extension devices in the same manner as focus events for 
the core devices are generated.
.NH 2
Device State Notify Event
.XS
\*(SN Device State Notify Event
.XE
.LP
DeviceStateNotify
.LP
.in .5i
time: TIMESTAMP
.br
device: CARD8
.br
num_keys: CARD8
.br
num_buttons: CARD8
.br
num_valuators: CARD8
.br
classes_reported: CARD8 {SetOfDeviceMode | SetOfInputClass}
.in +.5i
.br
SetOfDeviceMode:
.in +.5i
.br
#x80 ProximityState
.in +.5i
.br
0 = InProxmity, 1 = OutOfProximity
.in -.5i
.br
#x40 Device Mode
.in +.5i
.br
(0 = Relative, 1 = Absolute)
.br
.in -1.0i
SetOfInputClass:
.in +.5i
.br
#x04 reporting valuators
.br
#x02 reporting buttons
.br
#x01 reporting keys
.in -1.0i
.br
buttons: LISTofCARD8
.br
keys: LISTofCARD8
.br
valuators: LISTofCARD32
.br
.TE
.in -.5i
.LP
This event reports the state of the device just as in the 
\fBQueryDeviceState\fP request.  This event is reported to clients selecting 
\fBDeviceStateNotify\fP for the device and window and is generated immediately 
after every \fBEnterNotify\fP and \fBDeviceFocusIn\fP.  If the device has
no more than 32 buttons, no more than 32 keys, and no more than 3 valuators,
This event can report the state of the device.  If the device has more
than 32 buttons, the event will be immediately followed by a 
DeviceButtonStateNotify event.  If the device has more than 32 keys, the
event will be followed by a DeviceKeyStateNotify event.  If the device has more
than 3 valuators, the event will be followed by one or more DeviceValuator
events.
.NH 2
Device KeyState and ButtonState Notify Events
.XS
\*(SN Device KeyState and ButtonState Notify Events
.XE
.LP
DeviceKeyStateNotify
.LP
.in .5i
device: CARD8
.br
keys: LISTofCARD8
.in -.5i
.LP
DeviceButtonStateNotify
.LP
.in .5i
device: CARD8
.br
buttons: LISTofCARD8
.in -.5i
.LP
These events contain information about the state of keys and buttons on a 
device that will not fit into the DeviceStateNotify wire event.  These events
are not selected by clients, rather they may immediately follow a
DeviceStateNotify wire event and be combined with it into a single 
DeviceStateNotify client event that a client may receive via XNextEvent.
.NH 2
DeviceMappingNotify Event
.XS
\*(SN DeviceMappingNotify Event
.XE
.LP
DeviceMappingNotify
.LP
.in .5i
time: TIMESTAMP
.br
device: CARD8
.br
request: CARD8
.br
first_keycode: CARD8
.br
count: CARD8
.in -.5i
.LP
This event reports a change in the mapping of keys, modifiers, or buttons on
an extension device.  This event is reported to clients selecting 
\fBDeviceMappingNotify\fP for the device and window and is generated
after every client \fBSetDeviceButtonMapping\fP, \fBChangeDeviceKeyMapping\fP,
or  \fBChangeDeviceModifierMapping\fP request.
.NH 2
ChangeDeviceNotify Event
.XS
\*(SN ChangeDeviceNotify Event
.XE
.LP
ChangeDeviceNotify
.LP
.in .5i
device: CARD8
.br
time: TIMESTAMP
.br
request: CARD8
.in -.5i
.LP
This event reports a change in the physical device being used as the core
X keyboard or X pointer device.
\fBChangeDeviceNotify\fP events are reported to clients selecting 
\fBChangeDeviceNotify\fP for the device and window and is generated
after every client \fBChangeKeyboardDevice\fP
or  \fBChangePointerDevice\fP request.
.NH 2
Proximity Events
.XS
\*(SN Proximity Events
.XE
.LP
ProximityIn
.br
ProximityOut
.LP
.in .5i
device: CARD8
.br
root, event: WINDOW
.br
child: Window or None
.br
same-screen: BOOL
.br
root-x, root-y, event-x, event-y: INT16
.br
state: SETofKEYBUTMASK
.br
time: TIMESTAMP
.br
device-state: SETofKEYBUTMASK
.br
axis-count: CARD8
.br
first-axis: CARD8
.br
axis-data: LISTofINT32
.br
.in -.5i
.TE
.LP
These events are generated by some devices (such as graphics tablets or 
touchscreens) to indicate that a stylus has moved into or out of contact
with a positional sensing surface.
.LP
The ``source'' of the event is the window the pointer is in.
The window with respect to which the event is normally reported is found
by looking up the hierarchy (starting with the source window)
for the first window on which any client has selected interest in the event.
The actual window used for reporting can be modified by active grabs and
by the focus window.The window the event is reported with respect to is called
the ``event'' window.
.LP
The root is the root window of the ``source'' window, and root-x and root-y
are the pointer coordinates relative to root's origin at the time of the event.
Event is the ``event'' window.  If the event window is on the same screen as
root, then event-x and event-y are the pointer coordinates relative to the
event window's origin.  Otherwise, event-x and event-y are zero.  If the
source window is an inferior of the event window, then child is set to
the child of the event window that is an ancestor of (or is) the source window.
Otherwise, it is set to None. The state component gives the logical state of
the buttons on the core X pointer and modifier keys on the core X keyboard
just before the event.  The device-state component gives the state of the
buttons and modifiers on the device generating the event.
.bp
