#ifndef BASE_MAIN_H
#define BASE_MAIN_H

#include <kmainwindow.h>


class BaseInterface;
class KToggleAction;
class KKeyDialog;
class KConfigDialog;

class BaseMainWindow : public KMainWindow
{
    Q_OBJECT
public:
    BaseMainWindow();
    virtual ~BaseMainWindow();

signals:
    void settingsChanged();

private slots:
    void toggleMenubar();
    void start();
    void pause();
    void showHighscores();
    void configureSettings();
    void configureKeys();
    void configureHighscores();
    void configureNotifications();

protected:
    BaseInterface     *_inter;

    bool eventFilter(QObject *, QEvent *);
    bool queryExit();
    void readSettings();
    void buildGUI(QWidget *);
    virtual void addConfig(KConfigDialog *) {}
    virtual void addKeys(KKeyDialog &) {}
    virtual void saveKeys() {}

private:
    KToggleAction *_menu, *_pause;
};

#endif
