/***************************************************************************
                           guesswidget.h  -  description
                             -------------------
    begin                : Sat Feb 16 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#ifndef GUESSWIDGET_H
#define GUESSWIDGET_H

#include "quizwidget.h"

class KStatusBar;
class KPushButton;
class KLineEdit;
class QLabel;

class GuessWidget : public QuizWidget
{
  Q_OBJECT

public: 
  GuessWidget(KStatusBar *statusBar, bool randomQuiz,
	      QWidget *parent, const char *name = 0);
  ~GuessWidget();

  virtual void cut();
  virtual void copy();
  virtual void paste();
  virtual bool hasSelectedText() const;

protected:
  virtual QString completeMessage() const;

private:
  void setupLayout();
  virtual void showCard(const Card &card);
  
  bool random;
  mutable int numberCorrect;
  QString answer;
  QLabel *cardLabel;
  KLineEdit *guessLineEdit;
  KPushButton *showAnswerButton;
  KPushButton *checkButton;

private slots:
  void checkAnswer();
  void showAnswer();
  void callNextCard();
};

#endif
