#include "qtsharp.h"
#include <cstdio>

static qtsharp_EventDelegate QtSharp_EventDelegate = 0;

static int qtsharp_delegateBridge (void *arg1, char *arg2, void *arg3, char *arg4)
{
	if (QtSharp_EventDelegate)
		(*QtSharp_EventDelegate)(arg1, arg2, arg3, arg4);

	return 0;
}

extern "C"
void qtsharp_QObject_registerEventDelegate (qtsharp_EventDelegate delegate)
{
	QtSharp_EventDelegate = delegate;
	qt_QObject_registerEventDelegate (qtsharp_delegateBridge);
	return;
}

QObject *csharp_connect_void (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(void))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (void)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_item_void (QMenuData *instance, int id, QObject *receiver, void (*ptr)(void))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! instance->connectItem (id, cs, SLOT (callback (void)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_bool (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(bool))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (bool)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_short (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(short))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (short)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_int (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_item_int (QMenuData *instance, int id, QObject *receiver, void (*ptr)(int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! instance->connectItem (id, cs, SLOT (callback (int)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_long (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(long))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (long)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_float (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(float))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (float)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_double (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(double))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (double)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QDockWindow (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QDockWindow*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QDockWindow*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QDropEvent (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QDropEvent*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QDropEvent*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QDropEventQListViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QDropEvent*,QListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QDropEvent*,QListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QIconViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QIconViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QIconViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QListBoxItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QListBoxItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QListBoxItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QListViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QListViewItemQListViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QListViewItem*,QListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QListViewItem*,QListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QListViewItemQListViewItemQListViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QListViewItem*,QListViewItem*,QListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QListViewItem*,QListViewItem*,QListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QNetworkOperation (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QNetworkOperation*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QNetworkOperation*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QObject (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QObject*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QObject*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QToolBar (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QToolBar*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QToolBar*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_QWidget (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(QWidget*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (QWidget*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_intQIconViewItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int,QIconViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int,QIconViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_intQListBoxItem (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int,QListBoxItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int,QListBoxItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_intbool (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int,bool))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int,bool)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_intint (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int,int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int,int)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

QObject *csharp_connect_intintint (QObject *sender, const char *signal, QObject *receiver, void (*ptr)(int,int,int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! QObject::connect (sender, signal, cs, SLOT (callback (int,int,int)))) {
		delete cs;
		cs = 0L;
	}
	return (QObject *)cs;
}

