/***************************************************************************
                            KToolBarButton.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTOOLBARBUTTON_H
#define KTOOLBARBUTTON_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QToolButton.h>

/**

 A toolbar button. This is used internally by @ref KToolBar, use the
 KToolBar methods instead.

 
 @short 
 A toolbar button.
*/
@class KInstance; 

@interface KToolBarButton : QToolButton 

/** 
 Construct a button with an icon loaded by the button itself.
 This will trust the button to load the correct icon with the
 correct size.

*/
- initWithText: (NSString *)icon identifier: (int)identifier parent: (QWidget *)parent name: (NSString *)name txt: (NSString *)txt _instance: (KInstance*)_instance;
- initWithText: (NSString *)icon identifier: (int)identifier parent: (QWidget *)parent ;

/** 
 Construct a button with an existing pixmap.  It is not
 recommended that you use this as the internal icon loading code
 will almost always get it "right".

*/
- initWithPixmap: (QPixmap *)pixmap identifier: (int)identifier parent: (QWidget *)parent name: (NSString *)name txt: (NSString *)txt;
- initWithPixmap: (QPixmap *)pixmap identifier: (int)identifier parent: (QWidget *)parent ;

/** 
 Construct a separator button

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Standard destructor
   
*/
- (void) dealloc;

/** 
 Enable/Disable this button

*/
- setEnabled: (BOOL)enable;
- setEnabled;

/** 
 Set the pixmap directly for this button.  This pixmap should be
 the active one... the dimmed and disabled pixmaps are constructed
 based on this one.  However, don't use this function unless you
 are positive that you don't want to use @ref setIcon.

*/
- setPixmap: (QPixmap *)pixmap;

/** 
 Set the pixmap directly for this button.  This pixmap should be
 the active one.. however, the disabled and default pixmaps will
 only be constructed if @ref  #-generate is true.  In any event,
 don't use this function unless you are positive that you don't
 want to use @ref setIcon.

*/
- setPixmap: (QPixmap *)pixmap generate: (BOOL)generate;

/** 
 Force the button to use this pixmap as the default one rather
 then generating it using effects.

*/
- setDefaultPixmap: (QPixmap *)pixmap;

/** 
 Force the button to use this pixmap when disabled one rather then
 generating it using effects.

*/
- setDisabledPixmap: (QPixmap *)pixmap;

/** 
 Set the text for this button.  The text will be either used as a
 tooltip (IconOnly) or will be along side the icon

*/
- setText: (NSString *)text;

/** 
 Set the icon for this button.  This icon should be the active
 one... the dimmed and disabled icons are constructed based on
 this one.  The actual pixmap will be loaded internally.  This
 function is preferred over @ref setPixmap

*/
- setIcon: (NSString *)icon;

/** 
 Set the active icon for this button.  The pixmap itself is loaded
 internally based on the icon size...  .. the disabled and default
 pixmaps, however will only be constructed if @ref  #-generate is
 true.  This function is preferred over @ref setPixmap

*/
- setIcon: (NSString *)icon generate: (BOOL)generate;

/** 
 Force the button to use this icon as the default one rather
 then generating it using effects.

*/
- setDefaultIcon: (NSString *)icon;

/** 
 Force the button to use this icon when disabled one rather then
 generating it using effects.

*/
- setDisabledIcon: (NSString *)icon;

/** 
 Set the pixmaps for this toolbar button from a QIconSet.
 If you call this you don't need to call any of the other methods
 that set icons or pixmaps.

*/
- setIconSet: (QIconSet*)iconset;

/** 
 Turn this button on or off

*/
- on: (BOOL)flag;
- on;

/** 
 Toggle this button
   
*/
- toggle;

/** 
 Turn this button into a toggle button or disable the toggle
 aspects of it.  This does not toggle the button itself.  Use @ref
 toggle for that.

*/
- setToggle: (BOOL)toggle;
- setToggle;

/** 
 Return a pointer to this button's popup menu (if it exists)
   
*/
- (QPopupMenu*) popup;

/** 
 Give this button a popup menu.  There will not be a delay when
 you press the button.  Use @ref setDelayedPopup if you want that
 behavior. You can also make the popup-menu
 "sticky", i.e. visible until a selection is made or the mouse is
 clikced elsewhere, by simply setting the second argument to true.
 This "sticky" button feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.

*/
- setPopup: (QPopupMenu*)p toggle: (BOOL)toggle;
- setPopup: (QPopupMenu*)p ;

/** 
 Gives this button a delayed popup menu.

 This function allows you to add a delayed popup menu to the button.
 The popup menu is then only displayed when the button is pressed and
 held down for about half a second.  You can also make the popup-menu
 "sticky", i.e. visible until a selection is made or the mouse is
 clikced elsewhere, by simply setting the second argument to true.
 This "sticky" button feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.

*/
- setDelayedPopup: (QPopupMenu*)p toggle: (BOOL)toggle;
- setDelayedPopup: (QPopupMenu*)p ;

/** 
 Turn this button into a radio button

*/
- setRadio: (BOOL)f;
- setRadio;

/** 
 Toolbar buttons naturally will assume the global styles
 concerning icons, icons sizes, etc.  You can use this function to
 explicitely turn this off, if you like.

*/
- setNoStyle: (BOOL)no_style;
- setNoStyle;

/** 
 This slot should be called whenever the toolbar mode has
 potentially changed.  This includes such events as text changing,
 orientation changing, etc.
   
*/
- modeChange;
- setTextLabel: (NSString *)arg1 tipToo: (BOOL)tipToo;
- paletteChange: (QPalette *)arg1;
- drawButton: (QPainter *)p;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
- showMenu;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- (QSize*) minimumSize;
- makeDefaultPixmap;
- makeDisabledPixmap;
- slotClicked;
- slotPressed;
- slotReleased;
- slotToggled;
- slotDelayTimeout;
@end

/** Override these methods in subclasses of KToolBarButton to customise event handling behaviour */
@protocol KToolBarButtonEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
